﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<NewsThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="News-EditNews" </asp:content>
<asp:content runat="server" contentplaceholderid="manageContent">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />
  <%    bool isShowPage = ViewData.GetBool("isShowPage", true);
        int newsApplicationID = ApplicationIDs.Instance().News();
        string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");

        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType != StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            }
            TempData["StatusMessageType"] = null;
        }   
    %>
  <div id="editNews" class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-news">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <%if (ViewData.GetBool("isSection", false))
        {
            NewsThread thread = ViewData.Model;%>
      <form id="editor" action="<%=SPBUrlHelper.Action("CreateUpdateNews","News",new RouteValueDictionary{{"userDomainName",userDomainName},{"newsID",thread.ThreadID}}) %>"
                method="post"class="tn-helper-reset">
        <div class="tn-form tn-label-right">
          <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
            <%if (thread.ThreadID > 0) { Response.Write(GetResourceString("Title_EditNews", newsApplicationID)); } else { Response.Write(GetResourceString("Title_ReleaseNews", newsApplicationID)); } %>
            <%--<%=GetResourceString("Description_AsteriskMustInput", newsApplicationID)%>--%></h4>
         
          <div class="tn-form-row tn-title">
            <input type="text" id="title" name="title" class="tn-textbox tn-input-longest tn-border-gray" value="<%=Formatter.FormatSingleLinePlainTextForEdit(thread.Title) %>" />
            <span class="tn-form-required"><%=GetResourceString("Description_Required")%></span> </div>
            
          <div class="tn-form-row tn-editor">
            <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateNewsAttachments", "ChannelNews", new RouteValueDictionary { { "threadID", Model.ThreadID }, { "isImage", true } });
               string uploadAttachmentUrl = SPBUrlHelper.Action("UserContentSelector_UpdateNewsAttachments", "ChannelNews", new RouteValueDictionary { { "threadID", Model.ThreadID }, { "isImage", false } }); %>
            <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body",string.IsNullOrEmpty(thread.GetBodyForEdit())?thread.BodyForDataTransmission:thread.GetBodyForEdit(), new RouteValueDictionary { { "id", "body" },{"style","width:100%;height:300px;"}}, uploadPhotoUrl, uploadAttachmentUrl,true)%> </div>
             <div class="tn-form-row tn-category">
            <label class="tn-form-label"><%=GetResourceString("Label_NewsProgram", newsApplicationID)%>：</label>
            <select name="sectionDDL" id="sectionDDL" class="tn-dropdownlist">
              <option <%if(thread.ThreadID<=0)Response.Write("selected=\"selected\""); %> value="">请选择</option>
              <%foreach (var toSection in ViewData["allSections"] as List<NewsSection>)
                {%>
              <option <%if(thread.SectionID==toSection.SectionID)Response.Write(" selected=\"selected\""); %>
                                        value="<%=toSection.SectionID %>">
              <%for (int i = 0; i < toSection.Depth; i++) { Response.Write("&nbsp; &nbsp; &nbsp; &nbsp; "); } %>
              <%=toSection.GetMultilingualSectionName(CurrentUserLanguage)%></option>
              <%}%>
            </select>
            <span class="tn-form-required"><%=GetResourceString("Description_MustSelect")%></span> </div>
            
          <div class="tn-form-row tn-author">
            <label class="tn-form-label"> <%=GetResourceString("Label_NewsAuthor", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input id="author" name="author" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=thread.OriginalAuthor %>" />
            </div><div class="tn-form-row tn-news-source">
            <label class="tn-form-label"> <%=GetResourceString("Label_NewsSource", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input id="copyFrom" name="copyFrom" type="text" class="tn-textbox tn-input-medium tn-border-gray" value="<%=thread.CopyFrom %>" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Title_AdditionalOptions") %><%=GetResourceString("Common_Colon") %></label>
            <input id="downloadRemoteImage" name="downloadRemoteImage" type="checkbox" class="tn-checkbox" <%if(thread.IsDownloadRemoteImage)Response.Write(" checked=\"checked\""); %> value="true" />
            <label for="downloadRemoteImage"><%=GetResourceString("Label_DownloadRomotePhoto",ApplicationIDs.Instance().News()) %> </label>
          </div>
          <div class="tn-form-row tn-write-summary tn-textarea-wrap">
            <label class="tn-form-label"> <%=GetResourceString("Label_NewsSummary", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
            <textarea name="excerpt" class="tn-textarea tn-input-longest tn-border-gray" id="excerpt"><%=thread.Excerpt %></textarea>
            <span style="display:none"></span>
          </div>
          <div class="tn-collapsible tn-collapsible-closed">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
              <h4 class="tn-helper-reset"><a href="javascript:;;"><%=GetResourceString("Title_AdvancedSettings") %></a></h4>
            </div>
            <div class="tn-blank10"></div>
            <div class="tn-collapsible-content" style="display:block;">
            
            <%if (isShowPage)
              { %>
            <div class="tn-form-row">
              <lable class="tn-form-label">分页方式：
              </lable>
        
              <input id="managepager" type="radio" class="tn-radiobutton" checked="checked" name="isAutoPage" value="false" onclick="$('#autoPageSpan').hide();$('#pageTip').show();  $('#body_pagebreak').parent().show();" />
                          <label class="dt-label" for="managepager">手动</label>
                          <input id="autopager" type="radio" class="tn-radiobutton" name="isAutoPage" value="true" onclick="$('#autoPageSpan').show();$('#pageTip').hide(); $('#body_pagebreak').parent().hide();" />
                          <label class="dt-label" for="autopager">自动</label>
                          <span id="autoPageSpan" style="display:none;"> &nbsp; 大小：<input type="text" class="tn-textbox tn-border-gray" id="pageSize" name="pageSize" value="5" />千字/每页</span>
        
            </div>
         <%} %>
            
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_AssistantTitle", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input id="subtitle" name="subtitle" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=thread.Subtitle %>" />
              </div>
              <%if ((ViewData["dict"] as Dictionary<int, string>) != null && (ViewData["dict"] as Dictionary<int, string>).Count > 0)
                {%>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_TitlePrefix", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <select name="prefixDDL" id="prefixDDL" class="tn-dropdownlist">
                  <option <%if(thread.ThreadID<=0)Response.Write("selected=\"selected\""); %> value=""><%=GetResourceString("Common_PleaseChoose") %></option>
                  <%foreach (var dict in ViewData["dict"] as Dictionary<int, string>)
                    {%>
                  <option <%if(thread.PrefixID==dict.Key)Response.Write(" selected=\"selected\""); %>
                                        value="<%=dict.Key %>"> <%=dict.Value%></option>
                  <%}%>
                </select>
              </div>
              <%} %>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_PivotalWord", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input id="keywords" name="keywords" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=thread.Keywords %>" />
              </div>
              <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
                <label class="tn-form-label"> <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></label>
                <%        
                    ViewData["TagInputName"] = "newsTags";
                    ViewData["applicationTagItemKey"] = ApplicationTagItemKeys.Instance().News();
                    ViewData["SelectedUserTags"] = Model.Tags;
                    Html.RenderPartial("Controls/ApplicationTagSelector.ascx", ViewData);
            %>
              </div>
              
               <div class="tn-form-row">
                <label class="tn-form-label">原文链接<%=GetResourceString("Common_Colon") %></label>
                <input id="OriginalLinks" name="OriginalLinks" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=thread.OriginalLinks %>" />
              </div>
              
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_OpenComment")%><%=GetResourceString("Common_Colon") %></label>
                <input id="enableComments-true" type="radio" <%if(thread.EnableComments)Response.Write(" checked=\"checked\""); %>
                                    value="true" name="enableComments" class="tn-radiobutton" />
                <label for="enableComments-true"> <%=GetResourceString("Common_Yes") %></label>
                <input id="enableComments-false" type="radio" <%if(!thread.EnableComments)Response.Write(" checked=\"checked\""); %>
                                    value="false" name="enableComments" class="tn-radiobutton" />
                <label for="enableComments-false"><%=GetResourceString("Common_No")%></label>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_ReadCharge", newsApplicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" id="pointConsumption" name="pointConsumption" value="<%=thread.PointConsumption %>" class="tn-textbox tn-input-short tn-border-gray" />
                <em class="tn-text-note"><%=GetResourceString("Description_SetReadPoint", newsApplicationID)%></em> </div>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("saveNewsEditButton", GetResourceString("Button_OK"))%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
            <%} %>
          </div>
          <input type="hidden" value="<%=thread.FeaturedImageAttachmentID %>" id="featurePicAttachmentID" name="featurePicAttachmentID"/>
          <div class="tn-widget">
            <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %></span>
              <div class="tn-helper-flowfix"> <strong><%=GetResourceString("Description_FriendlyHint",ApplicationIDs.Instance().News()) %>：</strong> <%=GetResourceString("Description_PersonalPledge", newsApplicationID)%></div>
            </div>
          </div>
        </div>
      </form>
      <%}
        else
        {%>
      <div id="selectSection" class="container">
        <div id="ctl00_ctl00_CenterContentRegion_EditNews___TipArea" class="containerText">
          <p> <strong><%=GetResourceString("Description_FriendlyHint", newsApplicationID)%></strong></p>
          <p> <%=GetResourceString("Description_NowNeedAdministratorCreateProgram", newsApplicationID)%></p>
        </div>
      </div>
      <%}%>
    </div>
  </div>
  <script type="text/javascript" rel="forceLoad">
        $(document).ready(function() {
        
        		$(".tn-collapsible").collapsibleBox();
        		$("#title").qtip({content:'<%=string.Format(GetResourceString("Description_Pattern_TitleLimitWordCount", newsApplicationID), NewsConfiguration.Instance().MaxLengthForTitle)%>'});
              
                $("#excerpt").qtip({content:'<%=string.Format(GetResourceString("Description_Pattern_SummaryLimitWordCount", newsApplicationID), NewsConfiguration.Instance().MaxLengthForExcerpt)%>'});
                $("#keywords").qtip({content:'<%=GetResourceString("Label_SetNewsPageMetaTag",newsApplicationID)%>'});
        
         $("#title").watermark("<%=GetResourceString("Validate_InputTitle")%>").select();
        
            $("#editor").validate({
                rules: {
                    title: { required: true,minBlength:<%=NewsConfiguration.Instance().MinLengthForTitle %>, maxBlength: <%=NewsConfiguration.Instance().MaxLengthForTitle %> },
                    subtitle: { maxBlength: <%=NewsConfiguration.Instance().MaxLengthForSubtitle %> },
                    sectionDDL: { required: true },
                    author:{ maxBlength: 60 },
                    keywords:{ maxBlength: 60 },
                    copyFrom:{ maxBlength: 256 },
                    pageSize:{number: true, digits: true },
                    excerpt :{maxBlength: <%=NewsConfiguration.Instance().MaxLengthForExcerpt %> },
                    body: { htmlEditorRequired: true, htmlEditorRange: [<%=NewsConfiguration.Instance().MinLengthForBody %>, <%=NewsConfiguration.Instance().MaxLengthForBody %>] },
                    allowededUserRank: { required: true, digits: true },
                    pointConsumption: { required: true, number: true, min: 0 }
                },
                messages: {
                    title: { required: "<%=GetResourceString("Validate_InputTitle")%>",minBlength:"<%=string.Format(GetResourceString("Validate_MinLengthWordCount", newsApplicationID), NewsConfiguration.Instance().MinLengthForTitle)%>", maxBlength: "<%=string.Format(GetResourceString("Validate_MaxLengthNotExceedWord", newsApplicationID), NewsConfiguration.Instance().MaxLengthForTitle)%>" },
                    subtitle: { maxBlength: "<%=string.Format(GetResourceString("Validate_MaxLengthNotExceedWord", newsApplicationID), NewsConfiguration.Instance().MaxLengthForSubtitle)%>" },
                    author:{ maxBlength: "最多可以输入60个字" },
                    keywords:{ maxBlength: "最多可以输入60个字" },
                    copyFrom:{ maxBlength: "最多可以输入256个字" },
                     pageSize:{number: "只可以输入正整数"},
                    sectionDDL: { required: "<%=string.Format(GetResourceString("Validate_SelectProgram", newsApplicationID), NewsConfiguration.Instance().MaxLengthForTitle)%>" },
                    excerpt :{maxBlength: "<%=string.Format(GetResourceString("Validate_SelectProgram", newsApplicationID), NewsConfiguration.Instance().MaxLengthForExcerpt)%>" },
                    body: { htmlEditorRequired: "<%=GetResourceString("Validate_InputBody", newsApplicationID)%>", htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_WordCountConfine", newsApplicationID), NewsConfiguration.Instance().MinLengthForBody, NewsConfiguration.Instance().MaxLengthForBody)%>" },
                    allowededUserRank: { required: "<%=GetResourceString("Validate_InputBody", newsApplicationID)%>", digits: "<%=GetResourceString("Validate_InputPositiveInteger", newsApplicationID)%>" },
                    pointConsumption: { required: "<%=GetResourceString("Validate_InputBody", newsApplicationID)%>", number: "<%=GetResourceString("Validate_InputNumber", newsApplicationID)%>", min: "<%=GetResourceString("Validate_InputPositiveInteger", newsApplicationID)%>" }
                }
            });
            
               $("#saveNewsEditButton").submit(function() {
                if (!$("#editor").valid()) {
                    return false;
                }
            });
        }); 
        
 
    </script>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
<%int newsApplicationID = ApplicationIDs.Instance().News();%>
  <div id="NewsMenu">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
         <h3 class="tn-helper-reset"><%=GetResourceString("Title_ManageNews", newsApplicationID)%></h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% ViewData["newsMenuType"] = NewsMenuTypes.Create; %>
        <% Html.RenderPartial("Controls/News/NewsMenu.ascx", ViewData); %>
      </div>
    </div>
  </div>
</asp:content>
