﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<NewsThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="News-ListNews"
</asp:content>
<asp:content runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int newsApplicationID = ApplicationIDs.Instance().News();%>
    
          <div id="ListNews">
          <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-all">
            <%if (TempData["StatusMessageType"] != null)
              {
                  StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2500));
                  TempData["StatusMessageType"]=null;
              } %>
            <div class="tn-list-header tn-border-gray tn-border-bottom">
  
  <div class="tn-toolbar-area tn-helper-clearfix">
            <%=GetResourceString("Label_Select", newsApplicationID)%><%=GetResourceString("Common_Colon") %>
              <%AuditingStatusesForDisplay? status = (AuditingStatusesForDisplay?)ViewData["status"];%>
              <select name="sortBy" id="sortBy" class="tn-dropdownlist" onchange="window.location.href='<%=SPBUrlHelper.Action("ListNews","News",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>?status='+$(this).val();">
                <option <%if (status == null) Response.Write(" selected=\"selected\""); %> value="All"> <%=GetResourceString("Enum_AuditingStatusesForDisplay_All",newsApplicationID)%></option>
                <option <%if (status == AuditingStatusesForDisplay.Pending) Response.Write(" selected=\"selected\""); %> value="Pending"><%=GetResourceString("Enum_AuditingStatusesForDisplay_Pending", newsApplicationID)%></option>
                <option <%if (status == AuditingStatusesForDisplay.Success) Response.Write(" selected=\"selected\""); %> value="Success"><%=GetResourceString("Enum_AuditingStatusesForDisplay_Success", newsApplicationID)%></option>
                <option <%if (status == AuditingStatusesForDisplay.Fail) Response.Write(" selected=\"selected\""); %> value="Fail"><%=GetResourceString("Enum_AuditingStatusesForDisplay_Fail", newsApplicationID)%></option>
                <option <%if (status == AuditingStatusesForDisplay.Again) Response.Write(" selected=\"selected\""); %> value="Again"><%=GetResourceString("Enum_AuditingStatusesForDisplay_Again", newsApplicationID)%></option>
              </select>
            </div>
            </div>
            <table class="tn-table-grid">
              <tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Subject")%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_ReleaseDate",newsApplicationID)%> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Status") %> </th>
                <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </th>
              </tr>
              <% foreach (var thread in ViewData.Model.Records)
                 {%>
              <tr class="tn-table-grid-row">
                <td class="tn-border-gray tn-border-bottom tn-width-auto"><a target="_blank" href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>"> <%=StringUtils.Trim(thread.Title,20) %></a> </td>
                <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><em class="tn-date tn-text-note"><%=Formatter.FormatDate(thread.PostDate) %></em> </td>
                <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap"><%switch (thread.AuditingStatus)
                                                                        {
                                                                            case AuditingStatuses.Again:
                                                                                Response.Write(GetResourceString("Enum_AccountStatuses_Again"));
                                                                                break;
                                                                            case AuditingStatuses.Fail:
                                                                                Response.Write(GetResourceString("Enum_AccountStatuses_Fail"));
                                                                                break;
                                                                            case AuditingStatuses.Pending:
                                                                                Response.Write(GetResourceString("Enum_AccountStatuses_Pending"));
                                                                                break;
                                                                            case AuditingStatuses.Success:
                                                                                Response.Write(GetResourceString("Enum_AccountStatuses_Success"));
                                                                                break;
                                                                            default:
                                                                                break;
                                                                        } %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap"><%if (CurrentUser != null && thread.AuditingStatus == AuditingStatuses.Success && NewsPermission.Validate(thread, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EidtApprovedContributedNewsThread()))
                                                                        {%>
                  <a href="<%=SPBUrlHelper.Action("EditNews","News",new RouteValueDictionary{{"userDomainName",WebUtils.UrlEncode(userDomainName)},{"newsID",thread.ThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a>&nbsp;
                  &nbsp;
                  <%}
                                                                        else if (CurrentUser != null && thread.AuditingStatus != AuditingStatuses.Success && NewsPermission.Validate(thread, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditNewsThread()))
                                                                        {%>
                  <a href="<%=SPBUrlHelper.Action("EditNews","News",new RouteValueDictionary{{"userDomainName",WebUtils.UrlEncode(userDomainName)},{"newsID",thread.ThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a>&nbsp;
                  &nbsp;
                  <%}%>
                  <%if (CurrentUser!=null && NewsPermission.Validate(thread, Globals.GetCurrentUser(), PermissionItemKeys.Instance().DeleteNewsThread()))
                    {%>
                  <a href="<%=SPBUrlHelper.Action("DeleteNews","News",new RouteValueDictionary{{"userDomainName",userDomainName},{"newsID",thread.ThreadID},{"status",status}}) %>" onclick="if (!confirm('<%=GetResourceString("Message_ConfirmDeleteNews", newsApplicationID) %>')){return false;}"> <%=GetResourceString("Action_Delete")%></a>
                  <%}%>
                </td>
              </tr>
              <%}%>
            </table>
            <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
              {%>
            <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("ListNews", "News", new RouteValueDictionary { { "userDomainName", userDomainName }, { "status", status }, { "pageIndex", "{0}" } }))%> 
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
            </div>
            <%}%>
          </div>
 </div>
 </div>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
<%int newsApplicationID = ApplicationIDs.Instance().News();%>
   <div id="NewsMenu">
          <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset"><%=GetResourceString("Title_ManageNews", newsApplicationID)%></h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <% ViewData["newsMenuType"] = NewsMenuTypes.ListAll; %>
            <% Html.RenderPartial("Controls/News/NewsMenu.ascx", ViewData);
              %>
          </div>
          </div>
          </div>

</asp:content>
