﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Photo-EditPhoto" </asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
     Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <% 
      PhotoThread currentPhoto = (PhotoThread)ViewData.Model;
      int applicationID = ApplicationIDs.Instance().Photo();
      User currentDomainUser = ViewData.Get<User>("currentDomainUser");
      string userDomainName = currentDomainUser.UserName;
      if (currentPhoto != null)
      {
          bool isFeaturedPhoto = ViewData.GetBool("isFeaturedPhoto", false);
     %>
  <div id="EditPhoto" class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-photo">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,ApplicationIDs.Instance().Photo()) %>"><%=GetResourceString("Action_GoBackAllGalerllery", applicationID)%></a></span>
      <h3 class="tn-helper-reset"><%= GetResourceString("Title_EditPhoto", ApplicationIDs.Instance().Photo())%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form id="EditPhotoForm" action="<%=SPBUrlHelper.Action("UpdatePhoto","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",currentPhoto.ThreadID}}) %>"
    method="post">
        <div class="tn-form tn-label-right tn-helper-clearfix">
          <div class="tn-helper-left"><%=SPBHtmlHelper.Instance().ShowPicture(currentPhoto.ThreadID, PhotoImageType.SecondaryThumbnail, currentPhoto.Subject)%><br />
            <label>
              <input name="IsFeature" id="IsFeature" class="tn-checkbox" type="checkbox" value="true" <%if(isFeaturedPhoto){Response.Write("checked=\"checked\"");} %> />
              <%=GetResourceString("Label_SetTitlePicture")%> </label>
          </div>
          <div class="tn-list-item-area-main">
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_BelongToPhoto", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <% Html.RenderAction<PhotoController>(n => n.Control_PhotoUserCategoryDropdownList(userDomainName, currentPhoto.UserCategoryID, "photoUserCategoryDDL", "tn-dropdownlist")); %>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%= GetResourceString("Label_PhotoName",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %> </label>
              <input type="text" maxlength="256" class="tn-textbox tn-input-long tn-border-gray" value="<%=Formatter.FormatSingleLinePlainTextForEdit(currentPhoto.Subject) %>" name="PhotoName" id="PhotoName" />
            </div>
            <div class="tn-form-row tn-textarea-wrap">
              <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
              <textarea class="tn-textarea tn-input-long tn-border-gray" rows="" cols="" name="PhotoDescription" id="PhotoDescription"><%=currentPhoto.GetBodyForOwner()%></textarea>
              <span style="display:none"></span>
               </div>
            <%if (PhotoConfiguration.Instance().EableUserEntrySiteCategory)
                    { %>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon")%></label>
              <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Photo(), PhotoConfiguration.Instance().SiteCategoryLevel - 1, "photoSiteCategoryDDL", currentPhoto.SiteCategoryID, "tn-dropdownlist")); %>
            </div>
            <%} %>
            <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
              <label class="tn-form-label"> <%=GetResourceString("Label_SetTag",ApplicationIDs.Instance().Photo()) %><%=GetResourceString("Common_Colon") %></label>
              <%
                        ViewData["TagInputName"] = "userTags";
                        ViewData["userTagItemKey"] = UserTagItemKeys.Instance().Photo();
                        Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);
                        %>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("savePhoto",GetResourceString("Button_Save"), ButtonSizes.Large,null, null) %>
            <% if (Request.UrlReferrer != null) { Response.Write(SPBHtmlHelper.Instance().LinkButton("candler", GetResourceString("Button_Cancel"), Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary)); } %>
          </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
              $(document).ready(function() {
               
               	$("#EditPhotoForm").validate({
		           rules: {
			        PhotoName: {required: true, rangelength:[<%=PhotoConfiguration.Instance().MinLengthForTitle %>,<%=PhotoConfiguration.Instance().MaxLengthForTitle %>]},
			        PhotoDescription: { maxBlength: <%=PhotoConfiguration.Instance().MaxLengthForBody %>}
			        <%if (PhotoConfiguration.Instance().EableUserEntrySiteCategory)
                   { %>,
                    photoSiteCategoryDDL:{required:<%=PhotoConfiguration.Instance().SiteCategoryRequired.ToString().ToLower() %>}
                    <%} %>
		          },
		          messages: {
			        PhotoName: { required:"<%=GetResourceString("Validate_PleaseInputPhotoName",ApplicationIDs.Instance().Photo()) %>",rangelength:"<%=string.Format(GetResourceString("Validate_PhotosWordLimit",ApplicationIDs.Instance().Photo()),PhotoConfiguration.Instance().MinLengthForTitle ,PhotoConfiguration.Instance().MaxLengthForTitle) %>"},
			        PhotoDescription: { maxBlength: "<%=string.Format(GetResourceString("Message_DescriptionPhotoWord",ApplicationIDs.Instance().Photo()),PhotoConfiguration.Instance().MaxLengthForBody ) %>" }
			        <%if (PhotoConfiguration.Instance().EableUserEntrySiteCategory)
                  { %>,
                   photoSiteCategoryDDL:{required:"<%=GetResourceString("Description_Required")%>"}
                   <%} %>
		          }
                });
             }); 
    </script>
  <%
      }
   %>
</asp:content>
