﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<PhotoThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Photo-EditPhotos" </asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"> </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%
      int applicationID = ApplicationIDs.Instance().Photo();
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      PagingDataSet<PhotoThread> photos = (PagingDataSet<PhotoThread>)ViewData.Model;
      string editPhotoIDs = ViewData.GetString("editPhotoIDs", string.Empty); 
     %>
  <div id="EditPhotos" class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-photos">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-widget">
        <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
          <div class="tn-helper-flowfix"> <strong><%=GetResourceString("Message_Tips",applicationID)%><%=GetResourceString("Common_Colon") %></strong><%=GetResourceString("Message_PhotoAddContentAndTitle",ApplicationIDs.Instance().Photo())%></div>
        </div>
      </div>
      <div class="tn-form tn-label-right">
        <ul class="tn-list tn-helper-reset">
          <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-main">
              <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <h4><%=GetResourceString("Title_Unity",applicationID) %><%=GetResourceString("Title_AddPhotosMessage",applicationID) %></h4>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Title_Unity",applicationID) %><%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="editAllSubject"/>
              </div>
              <div class="tn-form-row tn-textarea-wrap">
                <label class="tn-form-label"> <%=GetResourceString("Title_Unity",applicationID) %><%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
                <textarea class="tn-textarea tn-input-long tn-border-gray" id="editAllDesc"></textarea>
                <span style="display:none"></span>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Title_Unity",applicationID) %><%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon") %></label>
                <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(applicationID, PhotoConfiguration.Instance().SiteCategoryLevel - 1, "photoSiteCategoryDDL_All", null, "tn-dropdownlist")); %>
              </div>
            </div>
          </li>
        </ul>
        <form action="<%=SPBUrlHelper.Action("UpdatePhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"photoIDs",editPhotoIDs}}) %>"
                    method="post">
          <ul class="tn-list tn-helper-reset" id="listPhotoUL">
            <% if (photos != null && photos.Records.Count > 0)
                     {
                         foreach (PhotoThread photo in photos.Records)
                         {
                             if (photo != null)
                             {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
              <div class="tn-list-item-area-left"><%=SPBHtmlHelper.Instance().ShowPicture(photo.ThreadID, PhotoImageType.SecondaryThumbnail)%><br />
                <label>
                  <input type="radio" name="categoryFeatureItemID" value="<%=photo.ThreadID %>" />
                  <%=GetResourceString("Label_SetFace",ApplicationIDs.Instance().Photo())%> </label>
              </div>
              <div class="tn-list-item-area-main">
                <div class="tn-form-row">
                  <label class="tn-form-label"> <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="subject_<%=photo.ThreadID %>" value="<%=photo.Subject %>" maxlength="<%=PhotoConfiguration.Instance().MaxLengthForTitle %>"
                                        name="subject_<%=photo.ThreadID %>" />
                </div>
                <div class="tn-form-row tn-textarea-wrap">
                  <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
                  <textarea class="tn-textarea tn-input-long tn-border-gray" maxlength="<%=PhotoConfiguration.Instance().MaxLengthForBody %>" id="body_<%=photo.ThreadID %>" name="body_<%=photo.ThreadID %>" ></textarea>
                  <span style="display:none"></span>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"> <%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon") %></label>
                  <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(applicationID, PhotoConfiguration.Instance().SiteCategoryLevel - 1, "photoSiteCategoryDDL_" + photo.ThreadID, null, "tn-dropdownlist")); %>
                </div>
                <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
                  <label class="tn-form-label"> <%=GetResourceString("Label_BelongTo",applicationID) %><%=GetResourceString("Common_Colon") %></label>
                  <%
                            ViewData["TagInputName"] = "userTags_" + photo.ThreadID;
                            ViewData["userTagItemKey"] = UserTagItemKeys.Instance().Photo();
                            Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);
                        %>
                </div>
              </div>
            </li>
            <%}
                         }
                     } %>
          </ul>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("savePhoto",GetResourceString("Button_Save"), ButtonSizes.Large,null,null) %>
            <% if (Request.UrlReferrer != null) { Response.Write(SPBHtmlHelper.Instance().LinkButton("candlerUploadPhotos", GetResourceString("Button_Cancel"), Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary)); } %>
          </div>
        </form>
      </div>
    </div>
  </div>
  <script type="text/javascript">
    $(document).ready(function() {
        $('#editAllSubject').keyup(function() {
            $('#listPhotoUL input[name^="subject_"]').val(this.value);
        });
        $('#editAllDesc').keyup(function() {
            $('#listPhotoUL textarea[name^="body_"]').text(this.value);
        });
        $("#photoSiteCategoryDDL_All").change(function() {
            $('#listPhotoUL select[name^="photoSiteCategoryDDL_"] option').removeAttr('selected');
            $('#listPhotoUL select[name^="photoSiteCategoryDDL_"] option[value=' + this.value + ']').attr('selected', 'selected');
        });
    });
</script>
</asp:content>
