﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<List<UserCategory>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-Home"
</asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
    <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContentRegion">
</asp:content>
<asp:content id="templateContentRegion" runat="server" contentplaceholderid="templateContentRegion">
<%
    int nowPageIndex = Request.QueryString.GetInt("PageIndex", 1);
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().Photo();
    bool isManger = ViewData.GetBool("isManger", false);
    bool isAllowDel = ViewData.GetBool("isAllowDel", true);
%>
<div class="tn-template-r-170 tn-helper-clearfix">                        
   <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000001", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
                        <div class="tn-main">
                            <div class="tn-block">                               
                                <div id="photoHome" class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-albums">
              <div class="tn-box-content tn-widget-content tn-corner-all">
                <%if (isManger)
                  { %>
                <div class="tn-list-header">
                  <div class="tn-list-header-row"><%=SPBHtmlHelper.Instance().LinkButton("addCategory", GetResourceString("Title_NewAlbum", applicationID), SPBUrlHelper.Action("Control_EditUserCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%> </div>
                </div>
                <%} %>
                <ul class="tn-album-list tn-widget tn-helper-reset tn-helper-clearfix">
                <%
                    if (Model != null && Model.Count > 0)
                    {
                        foreach (UserCategory category in Model)
                        {
                            if (category.PrivacyStatus == PrivacyStatuses.Public || (CurrentUser != null && category.PrivacyStatus == PrivacyStatuses.OnlyFriend && Friends.IsFriend(CurrentUser.UserID, Users.GetUser(userDomainName, false).UserID)) || category.PrivacyStatus == PrivacyStatuses.NeedPassword || isManger)
                            { 
                 %>
                  <li class="tn-album-item tn-helper-clearfix tn-restricted">
                    <div class="tn-album-cover tn-widget-content tn-border-gray">
                      <div class="tn-photo-wrap tn-widget-content tn-border-gray"><a href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,category.CategoryID) %>">
                      <%
                                string srcUrl = SiteUrls.Instance().CategoryFeaturedPhotoUrl(category);
                                if (category.PrivacyStatus == PrivacyStatuses.NeedPassword && !isManger)
                                    srcUrl = WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/album_lock.png");
                             %>
                      <img src="<%=srcUrl %>" />
                      </a>
                      <%if (category.PrivacyStatus != PrivacyStatuses.Public && category.PrivacyStatus != PrivacyStatuses.NeedPassword)
                        { %>
                      <div class="spb-icon-wrap tn-cue-highlight">
                      <%if (category.PrivacyStatus == PrivacyStatuses.Privacy)
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Stop, "仅自己可见"));
                        else if (category.PrivacyStatus == PrivacyStatuses.OnlyFriend)
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, "仅好友可见")); %>
                     </div>
                     <%} if (category.PrivacyStatus == PrivacyStatuses.NeedPassword && isManger)
                        {%>
                     <div class="spb-icon-wrap tn-cue-highlight"><span class="tn-icon tn-icon-lock" title="访问需要密码"></span></div>
                     <%} %>
                         </div>
                    </div>
                    <p class="tn-text-heading"><a href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,category.CategoryID) %>" title="<%=category.CategoryName %>"><%=StringUtils.Trim(category.CategoryName,4,string.Empty) %></a></p>
                    <%if (isManger)
                      { %>
                    <p><span class="tn-action"><a href="<%=SPBUrlHelper.Action("Control_EditUserCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", category.CategoryID } })%>" class="tn-action-text editCategoryModal"><%=GetResourceString("Action_Edit")%></a> </span><span class="tn-action">
                    <%if (isAllowDel)
                      { %>
                    <a onclick="if(!confirm('<%=GetResourceString("Message_ConfidentDelete", applicationID)%>')){return false;}" href="<%=SPBUrlHelper.Action("DeleteUserCategory","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",category.CategoryID}}) %>" class="tn-action-text"><%=GetResourceString("Action_Delete")%></a>
                    <%}
                      else
                      { %>
                    <a onclick="alert('<%=GetResourceString("Message_DenyDelete",applicationID)%>');" href="javascript:;" class="tn-action-text"><%=GetResourceString("Action_Delete")%></a>
                    <%}%>
                     </span></p>
                    <%} %>
                  </li>
                <%}
                        }
                    }
                 %>  
                </ul>
                </div>
            </div>
<script type="text/javascript">
<!--
    $(document).ready(function () {
        $('#addCategory,.editCategoryModal').nyroModal({
            resizeable: true
        });
    }); 
//-->
</script>
                            </div>
                        </div>
                        <div class="tn-block">
    <div id="PhotoSearch">
    <%Html.RenderAction<PhotoController>(n => n.Control_Search(userDomainName));%>
    </div>
    <div id="LatestPhotosBlock">
    <%Html.RenderAction<PhotoController>(n => n.Control_LatestPhotosBlock(userDomainName));%>
    </div>
    <div id="ListPhotoUserTags">
    <%Html.RenderAction<PhotoController>(n => n.Control_ListPhotoUserTags(userDomainName));%>
    </div>
    <div id="PhotoRss">
    <%Html.RenderAction<PhotoController>(n => n.Control_PhotoRss(userDomainName));%>
    </div>
                        </div>    
                        <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001100000002", userDomainName, new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>                    
                    </div>
</asp:content>
