﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Photo-ManagePhotoSectionSettings" </asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
  <% ViewData["PhotoSubMenu"] = null;
     Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="templateContentRegion" runat="server" contentplaceholderid="templateContentRegion"></asp:content>
<asp:Content ID="manageContent" runat="server" ContentPlaceHolderID="manageContent">
  <spb:Script ID="jquery_ui_stars" runat="server" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js"
        SetExpireDays="30" />
  <% PhotoSection currentGallery = (PhotoSection)ViewData.Model;
     string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
     int applicationID = ApplicationIDs.Instance().Photo();
       %>
  <div id="ManagePhotoSectionSettings">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <form id="ManageGallerySettingsForm" action="<%=SPBUrlHelper.Action("UpdateGallerySettings","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" method="post">
          <div class="tn-form-box">
            <%
                          if (TempData["StatusMessageType"] != null)
                          {
                              StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                              if (messageType == StatusMessageType.Success)
                              {
                                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, GetResourceString("Message_SetSaved"), 3000, false));
                              }
                              else
                              {
                                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, GetResourceString("Message_UpdateFailed"), 3000, true));
                              }
                              TempData["StatusMessageType"] = null;
                          } %>
            <table>
              <tr>
                <th><%=GetResourceString("Label_OpenComment", applicationID)%><%=GetResourceString("Common_Colon") %></th>
                <td><input type="radio" value="true" name="EnableComment" id="ynRepaly-true" <%if (currentGallery.EnableComments) Response.Write("checked=\"checked\""); %>  onclick="$('#allowComment').css('display','')" class="tn-radiobutton" />
                  <label for="ynRepaly-true"  onclick="$('#allowComment').css('display','')" ><%=GetResourceString("Common_Yes") %></label>
                  <input type="radio" value="false" name="EnableComment" id="ynRepaly-false" <%if (!currentGallery.EnableComments) Response.Write("checked=\"checked\""); %> class="tn-radiobutton"  onclick="$('#allowComment').css('display','none')"/>
                  <label for="ynRepaly-false"  onclick="$('#allowComment').css('display','none')"><%=GetResourceString("Common_No") %></label></td>
              </tr>
              <tbody id="allowComment"  <%if (!currentGallery.EnableComments)Response.Write("style=\"display:none\""); %>>
                <tr>
                  <th><%=GetResourceString("Label_AnonymousUserComment", applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><%=SPBHtmlHelper.Instance().YesNoRadioButtonList("EnableAnonymousComment", currentGallery.EnableAnonymousPosting, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%> <em class="tn-text-note"><%=GetResourceString("Message_IfNotUseCannotCommentPhoto", applicationID)%> </em></td>
                </tr>
                <tr>
                  <th><%=GetResourceString("Label_CommentNeedAuditing", applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><%=SPBHtmlHelper.Instance().YesNoRadioButtonList("ModerateComments", currentGallery.ModerateComments, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%>  <em class="tn-text-note"><%=GetResourceString("Message_StartThisFunctionShow", applicationID)%> </em></td>
                </tr>
              </tbody>
              <tr>
                <th></th>
                <td><%=SPBHtmlHelper.Instance().SubmitButton("saveSubmit", GetResourceString("Button_Save"), ButtonSizes.Default, new RouteValueDictionary { { "class", "tn-button-text" } },null)%>
                  <% if (Request.UrlReferrer != null)
                    {%>
                  <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, Request.UrlReferrer.AbsoluteUri)%>
                  <%} %></td>
              </tr>
            </table>
          </div>
        </form>
      </div>
    </div>
  </div>
  <script type="text/javascript">
          $(document).ready(function(){
               $("#ManageGallerySettingsForm").validate({
		           rules: {
			        GalleryName: "required"
		          },
		          messages: {
			        GalleryName: "<%=GetResourceString("Validate_InputGalleryNames",applicationID)%>"
		          }
                });
          });
    </script>
</asp:content>
<asp:Content ID="manageMenusContent" runat="server" ContentPlaceHolderID="manageMenusContent">
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <div id="ManagePhotoMenu">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset"> <%=GetResourceString("Title_ManagerCallery",ApplicationIDs.Instance().Photo())%> </h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-side-menu">
          <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo())%></a></li>
          <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoComments","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_CommentManage")%></a></li>
          <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoUserTags","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_TagManage")%></a></li>
          <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoSectionSettings","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_SetGallery",ApplicationIDs.Instance().Photo())%></a></li>
        </ul>
      </div>
    </div>
  </div>
</asp:Content>
