﻿<%@ Page Language="C#"    Inherits="SpaceBuilder.Web.UserDomainViewPage" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-ManagePhotos"
</asp:content>
<asp:Content ID="subMenusContent" runat="server" ContentPlaceHolderID="subMenusContent">
    <% ViewData["PhotoSubMenu"] = null;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:Content>

<asp:Content ID="templateContentRegion" runat="server" ContentPlaceHolderID="templateContentRegion">
</asp:Content>
<asp:Content ID="manageContent" runat="server" ContentPlaceHolderID="manageContent">
    <div id="ManagePhotosList">
        <% int pageIndex = 1;
           if (ViewData["pageIndex"] != null)
               pageIndex = (int)ViewData.GetInt("pageIndex", 1);
           int categoryID = -1;
           if (ViewData["categoryID"] != null)
               categoryID = (int)ViewData.GetInt("categoryID", -1); %>
        <% Html.RenderAction<PhotoController>(n => n.Control_ManagePhotos(ViewContext.GetParameterFromRouteDateOrQueryString<string>("userDomainName"), pageIndex, categoryID)); %>
    </div>
</asp:Content>

<asp:Content ID="manageMenusContent" runat="server" ContentPlaceHolderID="manageMenusContent">
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>

 <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                <h3 class="tn-helper-reset">
                    <%=GetResourceString("Title_ManagerCallery",ApplicationIDs.Instance().Photo())%></h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <ul class="tn-side-menu">
                    <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a
                        class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo())%></a></li>
                    <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoComments","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_CommentManage")%></a></li>
                    <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoUserTags","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_TagManage")%></a></li>
                    <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoSectionSettings","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_SetGallery",ApplicationIDs.Instance().Photo())%></a></li>
                </ul>
            </div>
        </div>
</asp:Content>