﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-ShowPhoto"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="WideContentRegion"> </asp:content>
<asp:content id="templateContentRegion" runat="server" contentplaceholderid="templateContentRegion">
    <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="imgareaselect" Src="~/Utility/jquery/plugin/jquery.imgareaselect-0.9.6.js" SetExpireDays="30" />
    <%
        int applicationID = ApplicationIDs.Instance().Photo();
        PhotoThread currentPhoto = ViewData.Get<PhotoThread>("currentPhoto");
        User currentUser = Globals.GetCurrentUser();
        User currentDomainUser = ViewData.Get<User>("currentDomainUser");
        string currentDomainUserName = currentDomainUser.UserName;
        bool hasManagePermission = CurrentUser != null && (CurrentUser.IsContentAdministrator || (CurrentUser.UserID == currentDomainUser.UserID) || CurrentUser.IsAdministrator);
        bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
        string currentPhotoBody = string.Empty;
        bool passwordRight = ViewData.GetBool("passwordRight", false);
        bool isMyFriend = ViewData.GetBool("isMyFriend", false);
        bool isShowPhotos = false;
        if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
            currentPhotoBody = currentPhoto.GetBodyForOwner();
        else
            currentPhotoBody = currentPhoto.GetBody();      
%>
    <!--审核 begin-->
    <%if (errorAuditingStatus)
      {
          string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
    <div class="tn-widget">
        <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUserName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span> <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
            <div class="tn-helper-flowfix"><%=errorMessage %>
                <%
                    if (CurrentUser != null && CurrentUser.IsContentAdministrator)
                    {%>
                ,<%=GetResourceString("Label_YouAdminThoughCurrentPhoto",applicationID)%> <a href="<%=SPBUrlHelper.Action("UpdatePhotoAuditingStatus","Photo",new RouteValueDictionary{{"photoThreadID",currentPhoto.ThreadID},{"userDomainName",currentDomainUserName}})%>"><%=GetResourceString("Common_PassAudit")%></a>
                <%}%>
            </div>
        </div>
    </div>
    <div class="tn-blank10">
</div>
    <%}%>
    <!--审核 end-->
    <!--隐私 begin-->
    <%   if ((!errorAuditingStatus || hasManagePermission) && currentPhoto.UserCategory != null)
         {
             switch (currentPhoto.UserCategory.PrivacyStatus)
             {
                 case PrivacyStatuses.NeedPassword:
                     if (hasManagePermission || passwordRight)
                         isShowPhotos = true;
                     else
                     {%>
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
            }
            TempData.Remove("StatusMessageType");%>
    <%} %>
    <div class="tn-widget">
        <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUserName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-key"></span></span>
            <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowPhtotoNeedPassword",applicationID) %><a href="javascript:;" id="havepwd" onclick="$('#havepwd').hide();$('#inputpwd').show();$('#password').focus();"><%=GetResourceString("Common_HavePassword") %></a>
                <div id="inputpwd" style="display:none; padding:10px 0 0 0;">
                    <form id="passwordForm" method="post" action="<%=SPBUrlHelper.Action("ShowPhotoForPassword", "Photo", new RouteValueDictionary { { "userDomainName", currentDomainUserName }, { "threadID", currentPhoto.ThreadID } })%>">
                        <input type="password" class="tn-textbox tn-input-medium tn-border-gray" name="password" id="password" />
                        <%=SPBHtmlHelper.Instance().SubmitButton("save", GetResourceString("Button_OK"), ButtonSizes.Default, new RouteValueDictionary { { "onclick", "createEditPhotoSaveFunction();" } }, null)%> <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "onclick", "$('#havepwd').show();$('#inputpwd').hide();" } })%>
                    </form>
                    <script type="text/javascript">
                        $(document).ready(function () {
                            $("#passwordForm").validate({
                                rules: {
                                    password: { required: true }
                                },
                                messages: {
                                    password: { required: "*" }
                                }
                            });
                        });

                        var createEditPhotoSaveFunction = function () {
                            if ($("#passwordForm").valid()) {
                                $("#save").hide();
                                $("#save_ForHide").show();
                            }
                            return false;
                        }
    </script>
                </div>
            </div>
        </div>
    </div><div class="tn-blank10">
</div>

    <%} break;
                 case PrivacyStatuses.OnlyFriend:
                     if (hasManagePermission || isMyFriend)
                         isShowPhotos = true;
                     else
                     {
            %>
    <div class="tn-widget">
        <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUserName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-limit"></span></span>
            <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowPhtotoForFriend",applicationID) %>
                <%if (CurrentUser == null)
                  { %>
                <a href="<%=SiteUrls.Instance().Login(true) %>"><%=GetResourceString("Action_LoginFirst",ApplicationIDs.Instance().User()) %></a>
                <%}
                  else
                  { %>
                <a id="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,currentDomainUser.UserID)%>"> <%= GetResourceString("Action_AddFriend")%></a>
                <%} %>
            </div>
        </div>
    </div><div class="tn-blank10">
</div>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#addFriendModal').nyroModal({
                resizeable: true
            });
        }); 
    </script>
    <%   } break;
                 case PrivacyStatuses.Privacy:
                     if (hasManagePermission)
                         isShowPhotos = true;
                     else
                     {%>
    <div class="tn-widget">
        <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUserName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-lock"></span></span>
            <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowAlbumForSelf",applicationID) %></div>
        </div>
    </div><div class="tn-blank10">
</div>

    <%
        } break;
                 case PrivacyStatuses.Public:
                     isShowPhotos = true;
                     break;
                 default:
                     break;
             }
         }
%>
    <!--隐私 end-->
    <%  if (currentPhoto != null)
        {
            %>
            <% 
                if (!errorAuditingStatus || hasManagePermission)
                {
                    if (isShowPhotos)
                    {%>
                    <a name="photo"></a>
    <div id="ShowPhoto" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photo-show">
        <div class="tn-box-content tn-widget-content tn-corner-all">
        
            <div class="tn-template-r-230 tn-helper-clearfix">
                <div class="tn-main">
                    <div class="tn-block">
                        <div class="spb-photo-main">
                            <div class="spb-photo-container" id="showPhotoContainer">
                            <%if (currentUser != null && currentPhoto != null && currentUser.UserID == currentPhoto.OwnerUserID)
                              { %> 
                            <%=SPBHtmlHelper.Instance().ShowPicture(currentPhoto.ThreadID, PhotoImageType.Details, WebUtils.HtmlDecode(currentPhoto.Subject), string.Empty, string.Empty, currentPhoto.Password)%>
                            <%}
                              else
                              { %>
                            <%=SPBHtmlHelper.Instance().ShowPicture(currentPhoto.ThreadID, PhotoImageType.Details, WebUtils.HtmlDecode(currentPhoto.Subject), string.Empty, string.Empty, currentPhoto.Password)%>
                            <%} %>
                            </div>
                            <h2> <%=currentPhoto.Subject%>
                            <%if (currentPhoto.IsEssential)
                                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, "精华", new RouteValueDictionary { { "class", "tn-icon-inline " } }));
                              if (currentPhoto.SpecialOrder > 0)
                                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, "置顶", new RouteValueDictionary { { "class", "tn-icon-inline " } }));
                                   %>
                         
                            </h2>
                            
                            <div class="tn-actions tn-helper-align-right">
                                <% if (hasManagePermission)
                                   { %>
                                <span class="tn-action"><a href="<%=SPBUrlHelper.Action("EditPhoto","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUser.UserName},{"threadID",currentPhoto.ThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a></span><span class="tn-action"> <a href="javascript:;" onclick="if (confirm(' <%=GetResourceString("Message_DeletePhotoSure",ApplicationIDs.Instance().Photo())%>')) {  window.location = '<%=SPBUrlHelper.Action("DeletePhotoThread","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUser.UserName},{"ThreadID",currentPhoto.ThreadID},{"pageIndex",1},{"isManage",false}}) %>' }"><%=GetResourceString("Action_Delete")%></a></span>
                                <%}
                                   if (CurrentUser != null && CurrentUser.IsContentAdministrator && currentPhoto.PrivacyStatus == PrivacyStatuses.Public && currentPhoto.AuditingStatus == AuditingStatuses.Success)
                                   { %>
                                <span class="tn-action"> <a href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Photo(), currentDomainUser.UserID, currentPhoto.ThreadID, currentPhoto.Subject, "112002")%>" id="recommendPhotoModal"><%=GetResourceString("Common_ManagerRecommend")%></a> </span> <span class="tn-action"> <a id="setEssential" href="javascript:;" onClick=" essentialManage()">
                                <% if (currentPhoto.IsEssential) Response.Write(GetResourceString("Common_CancelEssential")); else Response.Write(GetResourceString("Common_SetEssential")); %>
                                </a> </span> <span class="tn-action"> <a id="setTop" href="javascript:;" onClick="topManage();">
                                <% if (currentPhoto.SpecialOrder > 0) Response.Write(GetResourceString("Common_CancelPutter")); else Response.Write(GetResourceString("Common_SetTop")); %>
                                </a> </span>
                                <%} %>
                                <input type="text" id="essentialHideInputStore" value="<%=Convert.ToInt32((currentPhoto.IsEssential))%>" style="display: none" />
                                <input type="text" id="topHideInputStore" value="<%=currentPhoto.SpecialOrder %>" style="display: none" />
                                </div>
                                <% 
                                    if (CurrentUser != null && currentDomainUser.UserType == UserTypes.PersonUser)
                                    { %>
                                <div id="photoNoteList" class="photoNoteList">
                                    <h4> <%=GetResourceString("Title_PhotoHave", ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon")%></h4>
                                    <p id="photo-tlist" class="tagged-users"></p>
                                </div>
                                <%} %>
                            <div id="photo-tagcaption" style="display:none" class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                                <div class="tn-helper-flowfix"><%=GetResourceString("Validate_MouseInPhotoTagFriend",ApplicationIDs.Instance().Photo())%>
                                            <%=SPBHtmlHelper.Instance().LinkButton("photo-finishtag", GetResourceString("Action_Finshed", ApplicationIDs.Instance().Photo()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default)%>
                                </div>
                            </div>

                            <div class="tn-feedback tn-helper-clearfix tn-border-gray tn-border-top ">
                                <div class="tn-helper-right">
                                    <% if (CurrentUser != null && currentDomainUser.UserType == UserTypes.PersonUser)
                                       { %>
                                    <%=SPBHtmlHelper.Instance().LinkButton("photo-starttag", GetResourceString("Action_StartTagged", ApplicationIDs.Instance().Photo()), "javascript:;", ButtonSizes.Default, HighlightStyles.Default)%>
                                    <%} %>
                                    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Info", ApplicationIDs.Instance().Photo()), SPBUrlHelper.Action("ShowPhotoExif", "Photo", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "threadID", currentPhoto.ThreadID } }), ButtonSizes.Default, HighlightStyles.Default)%>
                                    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Title_DifferSize", ApplicationIDs.Instance().Photo()), SPBUrlHelper.Action("ShowSizesPhoto", "Photo", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "threadID", currentPhoto.ThreadID } }), ButtonSizes.Default, HighlightStyles.Default)%> 
                                    <%=SPBHtmlHelper.Instance().LinkButton("reportThisPhoto", GetResourceString("Button_Report"), SiteUrls.Instance().NewImpeachReport(), ButtonSizes.Default, HighlightStyles.Default)%> 
                                    <%if (CurrentUser == null)
                                      {%>
                                      <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_Share", ApplicationIDs.Instance().Photo()), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
                                      <%}
                                      else
                                      { %>
                                      <%=SPBHtmlHelper.Instance().LinkButton("shareLink", GetResourceString("Button_Share", ApplicationIDs.Instance().Photo()), SiteUrls.Instance().ShareInModal(true, Request.RawUrl, currentPhoto.Subject, HtmlUtils.TrimHtml(currentPhoto.GetBody(), 140),SiteUrls.Instance().PictureUrl(currentPhoto.ThreadID, PhotoImageType.Icon,currentPhoto.Password), applicationID, currentPhoto.OwnerUserID, currentPhoto.Author), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
                                      <%} %>
                                </div>
                            </div>
                            <%if (!string.IsNullOrEmpty(currentPhotoBody))
                              { %>
                            <div class="tn-detail-text"> <%=currentPhotoBody%> </div>
                            <%} %>
                            <div class="tn-rating">
                                <div class="tn-rating-cont tn-helper-clearfix">
                                    <% if (CurrentUser == null)
                                       {%>
                                    <%=SPBHtmlHelper.Instance().ShowRating(currentPhoto.RatingSum, currentPhoto.TotalRatings)%>
                                    <%}
                                       else
                                       {%>
                                    <%=SPBHtmlHelper.Instance().RatingButton(currentPhoto.ThreadID, "photoRating", currentPhoto.RatingSum, currentPhoto.TotalRatings, SPBUrlHelper.Action("Rate", "ChannelPhoto"), "ratingCallback()")%>
                                    <%} %>
                                </div>
                            </div>
 <div id="ListRatingUsers">
                            <%IList<Rating> ratings = ViewData.Get<IList<Rating>>("ratings");
                              if (ratings.Count > 0)
                              {%>
                             
                            <% Html.RenderAction<ChannelPhotoController>(n => n.Control_ListRatingUsers(currentPhoto.ThreadID, 30)); %>
                          
                            <%} %>  </div>
                            <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001101120001", currentDomainUserName, new RouteValueDictionary { { "class", "spb-ad-main-bottom" } })%>
                            <div id="PhotoCommentsAndComment">
                            <% Html.RenderAction<PhotoController>(n => n.Control_PhotoComments(currentDomainUserName, currentPhoto.ThreadID, false, null)); %>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tn-block">
                    <div class="tn-text-heading tn-border-gray tn-border-bottom"> <strong>
                        <% if (currentPhoto.UserCategory != null) Response.Write(string.Format(GetResourceString("Message_Down", ApplicationIDs.Instance().Photo()), currentPhoto.UserCategory.CategoryName)); %>
                        <%=GetResourceString("Label_All_Photo", ApplicationIDs.Instance().Photo())%> (
                        <% if (currentPhoto.UserCategory != null) Response.Write(currentPhoto.UserCategory.ItemCount);
                           else
                           {
                               UserApplicationSettings settings = UserApplicationSettingss.GetUserApplicationSetting(currentDomainUser.UserID, ApplicationIDs.Instance().Photo());
                               if (settings != null) Response.Write(settings.ItemCount);
                           } %>
                        ) </strong> </div>
                    <div class="spb-photo-thumb-viewer">
                        <% Html.RenderAction<PhotoController>(n => n.Control_SlideListPhotos(currentDomainUserName, currentPhoto.ThreadID, ViewData.GetInt("sildePhotosPageIndex", 1))); %>
                    </div>
                    
                    <%if (currentPhoto.UserTags.Count > 0)
                      {%>
                    <div class="tn-text-heading tn-border-gray tn-border-bottom"> <strong><%=GetResourceString("Common_UserTag")%></strong></div>
                    <p class="tn-tags-cloud">
                        <% 
                            string tags = string.Empty;
                            foreach (string tagName in currentPhoto.UserTags)
                            {
                                tags += string.Format("<span><a href='{0}' title='" + GetResourceString("Action_UserTagPhoto", ApplicationIDs.Instance().Photo()) + "'>{1}</a></span>", SiteUrls.Instance().ListPhotosByUserTag(currentDomainUserName, tagName), tagName);
                            }
                            Response.Write(tags);
                           %>
                    </p>
                    <%} %>
                    <div class="tn-text-heading tn-border-gray tn-border-bottom"> <strong><%=GetResourceString("Title_PhotoOtherInfo", ApplicationIDs.Instance().Photo())%></strong></div>
                    <div class="tn-info-part">
                        <dl>
                            <dt><%=GetResourceString("Label_BelongToPhoto", ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%if (currentPhoto.UserCategory != null)
                                  { %>
                                <a href="<%=SPBUrlHelper.Action("ListThumbnailPhotosByCategory","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUser.UserName},{"categoryID",currentPhoto.UserCategoryID}}) %>"><%=currentPhoto.UserCategory.CategoryName%></a>&nbsp;&nbsp;
                                <%} %>
                                <% 
                                    if (CurrentUser != null && ((CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator) && currentPhoto.UserCategory != null && currentPhoto.PrivacyStatus == PrivacyStatuses.Public))
                                    {
                                        if (currentPhoto.ThreadID != currentPhoto.UserCategory.FeaturedItemID)
                                        { %>
                                <a id="setCategoryFeatureA" href="javascript:;" onClick="setCategoryFeature()"> <%=GetResourceString("Action_SetCharacter", ApplicationIDs.Instance().Photo())%> </a>
                                <%}
                                        else
                                        { %>
                                <%=GetResourceString("Message_WasSetChractorPhoto", ApplicationIDs.Instance().Photo())%>
                                <%}
                                    } %>
                                    </dd>
                                    </dl>
                                    <%if (currentPhoto.SiteCategory != null)
                                      { %>
                                    <dl>
                                    <dd><%= GetResourceString("Common_SiteCategory")%><%=GetResourceString("Common_Colon") %></dd>
                                    <dt><a href="<%=SPBUrlHelper.Action("ListPhotosByCategory","ChannelPhoto",new RouteValueDictionary{{"categoryID",currentPhoto.SiteCategoryID}}) %>"><%=currentPhoto.SiteCategory.CategoryName %></a></dt>
                        </dl>
                        <%} %>
                        <dl>
                            <dt><%=GetResourceString("Label_PostDate")%><%=GetResourceString("Common_Colon")%></dt>
                            <dd> <span class="tn-date"><%=Formatter.FormatDate(currentPhoto.PostDate)%></span></dd>
                        </dl>
                        <dl>
                            <dt><%=GetResourceString("Enum_BrowseTimes",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd> <span class="tn-count"> <%=currentPhoto.HitTimes.ToString()%></span></dd>
                        </dl>
                        <dl>
                            <dt><%=GetResourceString("Label_PhoteSizes",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd> <%=currentPhoto.Attachment.Friendlylength%></dd>
                        </dl>
                        <%--<dl>
                        <dt><%=GetResourceString("Label_Issue",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %></dt>
                        <dd> 
                        <% switch (currentPhoto.PrivacyStatus)
                           {
                               case PrivacyStatuses.NeedPassword:
                                   Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, "密码访问"));
                                   break;
                               case PrivacyStatuses.OnlyFriend:
                                   Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.User, "好友可见"));
                                   break;
                               case PrivacyStatuses.Privacy:
                                   Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "仅自己可见"));
                                   break;
                               case PrivacyStatuses.Public:
                                   Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, "所有人可见"));
                                   break;
                               default:
                                   break;
                           } %>
                     </dd>
                    </dl>--%>
                        <dl>
                            <dt><%=GetResourceString("Label_Hight",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd> <%=string.Format("{0}px", Convert.ToString(currentPhoto.Attachment.Height))%></dd>
                        </dl>
                        <dl>
                            <dt><%=GetResourceString("Label_Wide",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd><%=string.Format("{0}px", Convert.ToString(currentPhoto.Attachment.Width))%></dd>
                        </dl>
                    </div>
                    <%=SPBHtmlHelper.Instance().ShowAdvertisingInUserDomain("001101120002", currentDomainUserName, new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
                </div>
            </div>
        </div>
    </div>
            <%if (CurrentUser != null && CurrentUser.IsContentAdministrator)
              { %>
               <script type="text/javascript">
                         function essentialManage()
                {
                   if(($('#essentialHideInputStore').attr("value"))>0)
                   {
                      
                      $.get('<%=SPBUrlHelper.Action("CancelEssential","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUserName},{"threadID",currentPhoto.ThreadID }}) %>',{ threadID: '<%= currentPhoto.ThreadID %>' }, function(data){
                          $("#setEssential").text("<%=GetResourceString("Common_SetEssential")%>");
                          $("#essentialHideInputStore").val("0");
                        }); 
                   }
                   else
                   {
                        $.get('<%=SPBUrlHelper.Action("SetEssential","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUserName},{"threadID",currentPhoto.ThreadID}}) %>',{ threadID: '<%= currentPhoto.ThreadID %>' }, function(data){
                          $("#setEssential").text("<%=GetResourceString("Common_CancelEssential")%>");
                          $("#essentialHideInputStore").val("1");
                        }); 
                   }
                }
               function topManage()
                {
                  if(($('#topHideInputStore').attr("value"))>0)
                   {
                        $.get('<%=SPBUrlHelper.Action("CancelTop","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUserName},{"threadID",currentPhoto.ThreadID}}) %>',{ threadID: '<%= currentPhoto.ThreadID %>' }, function(data){
                          $("#setTop").text('<%=GetResourceString("Common_SetTop")  %>');
                          $('#topHideInputStore').val("0");
                        }); 
                   }
                   else
                   {
                       $.get('<%=SPBUrlHelper.Action("SetTop","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUserName},{"threadID",currentPhoto.ThreadID}}) %>',{ threadID: '<%= currentPhoto.ThreadID %>' }, function(data){
                          $("#setTop").text("<%=GetResourceString("Common_CancelPutter")%>");
                          $('#topHideInputStore').val('<%=ViewData.GetInt("topSpecialOrder", 100) %>');
                        }); 
                   }
                }
                  </script>
               <%} %>
    <script type="text/javascript">
                $(document).ready(function() {
                    $('#showPhotoContainer > img').mousemove(photoMouseMove);
                    $('#commendToClubsModal,#reportThisPhoto,#addFriendModal').nyroModal({
                        resizeable: true
                    });
                    $('#shareLink').nyroModal({
                            resizeable: true,
                            width:500
                    });
                    $('#recommendPhotoModal').nyroModal({
                          resizeable: true,
                          extImg: '[\.]{3}',//阻止识别为image
                          width: 500
                      });
                }); 
                function photoMouseMove(e){
                      var positionX = e.pageX;                      
                      var offset = $("#showPhotoContainer img").position();
                      
                      positionX = positionX - offset.left;
                      
                      if(positionX<=$(this).width()/2)
                      {
                        if(<%=currentPhoto.NextThreadID%>>0)
                        {
                            $(this).unbind( "click" );
                            $(this).attr('style','cursor: url(<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/pre.cur")) %>), auto;');
                            this.style.cursor = 'url(<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/pre.cur")) %>), auto;';
                            $(this).click(function(){window.location='<%=SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary() { {"userDomainName",currentDomainUserName},{"threadID",currentPhoto.NextThreadID}})%>#photo';});
                        }
                      }
                      else
                      {
                       if(<%=currentPhoto.PrevThreadID%>>0)
                       {
                          $(this).unbind( "click" );
                          $(this).attr('style','cursor: url(<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/next.cur")) %>), auto;');
                          this.style.cursor = 'url(<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/next.cur")) %>), auto;';
                          $(this).click(function(){window.location='<%=SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary() { {"userDomainName",currentDomainUserName},{"threadID",currentPhoto.PrevThreadID}})%>#photo';});
                       }
                      }
                     
                    }
            
                function setCategoryFeature()
                {
                    $.get('<%=SPBUrlHelper.Action("SetFeature","Photo",new RouteValueDictionary{{"userDomainName",currentDomainUserName},{"threadID",currentPhoto.ThreadID}}) %>',{ threadID: '<%= currentPhoto.ThreadID %>' }, function(data){
                      $("#setCategoryFeatureA").text("<%=GetResourceString("Message_WasSetChractorPhoto",ApplicationIDs.Instance().Photo())%>");
                      $("#setCategoryFeatureA").attr("class","false"); 
                    }); 
                }
          
    </script>
    <% if (CurrentUser != null && currentDomainUser.UserType == UserTypes.PersonUser)
       { %>
    <script type="text/javascript">
     

             function ratingCallback() {
            $("#ListRatingUsers").load("<%=SPBUrlHelper.Action("Control_ListRatingUsers","ChannelPhoto",new RouteValueDictionary{{"itemID",currentPhoto.ThreadID},{"topNumber",30}}) %>");
        }

        var notes = new Array;
        function getNotes() {
            notes.length = 0;
            $("#photo-tlist span.usertag").each(function (i) {
                var note = $(this).attr("hn_tag");
                if (note) {
                    var obj = eval('(' + note + ')');
                    notes[i] = obj;
                }
            });
        }
        function loadNotes() {
            getNotes();
            $(".note").remove();
            $(".notep").remove();
            $(notes).each(function () {
                appendnote(this);
            });
            $('#showPhotoContainer img').hover(
		function (event) {
		    $('.note').show();
		},
		function (event) {
		    $('.note').hide();
		}
		);
            tagHover();  //鼠标滑过用户名时，将在照片中显示方框
            showUserName();  //在照片中鼠标滑过所圈方框时，将会显示用户的名字	
        }
        //鼠标滑过用户名时，将在照片中显示方框
        function tagHover() {
            $("#photo-tlist span.usertag").each(function (i) {
                $(this).hover(
			function () {
			    $(".note:eq(" + i + ")").show();
			},
			function () {
			    $(".note:eq(" + i + ")").hide();
			}
		  );
            });
        }
        //在照片中鼠标滑过所圈方框时，将会显示用户的名字
        function showUserName() {
            $('div.note').each(function (i) {
                $currentNote = $(".note:eq(" + i + ")");
                $currentNote.hover(
			function () {
			    $(this).show();
			    $(this).next("div.notep").show();
			    $(this).css("z-index", 100);
			},
		    function () {
		        $(this).hide();
		        $(this).next(".notep").hide();
		        $(this).css("z-index", 0);
		    }
			);
            });
        }
        function appendnote(note_data) {
            imgOffset = $('#showPhotoContainer img').offset();
            note_left = parseInt(imgOffset.left) + parseInt(note_data.x1);
            note_top = parseInt(imgOffset.top) + parseInt(note_data.y1);
            note_p_top = note_top + parseInt(note_data.height) + 5;

            note_area_div = $('<div ' + "tag" + note_data.id + ' class="note"></div>').css({ left: note_left + 'px', top: note_top + 'px', width: note_data.width + 'px', height: note_data.height + 'px' });

            note_text_div = $('<div class="notep" >' + note_data.note + '</div>').css({ left: note_left + 'px', top: note_p_top + 'px' });
            $('body').append(note_area_div);
            $('body').append(note_text_div);
        }    
</script>
    <script type="text/javascript">    
    var imgAreaSelect = null;
      $(document).ready(function() {  
       imgAreaSelect= $('#showPhotoContainer > img').imgAreaSelect({
            instance: true,
            disable:true,
            hide:true,
            parent:"body",
		 	borderWidth:0,
		 	handles:true,
			selectionColor: 'blue', 
            minHeight:60,
            minWidth:60,
            maxWidth: 400, 
            maxHeight: 300,
            onSelectChange:function (img, selection){ 
              if(selection.width>10)
              $('#UserSelectorWrap')
              .css('left',$('.imgareaselect-border2').offset().left + selection.width +'px')
              .css('top', $('.imgareaselect-border2').offset().top+'px').show();
              else
              $('#UserSelectorWrap').hide();
            }
	     });	     
         loadPhotoTags(0,-1,-1,-1,-1,-1);	   

         $("#photo-starttag").click( function(){
              $("#photo-tagcaption").show();
              imgAreaSelect.setOptions({parent:"body",enable:true, show:true});
             $("#photo-finishtag").click(function(){
                $("#photo-tagcaption").hide();		 
	            imgAreaSelect.setOptions({parent:"body",disable:true,hide:true});
	            $('#UserSelectorWrap').hide();		
                $('#showPhotoContainer > img').mousemove(photoMouseMove);
             });
             $("#photo-tagcaption").show();
         $('#showPhotoContainer > img').unbind("mousemove",photoMouseMove).unbind("click").removeAttr("style");
        });
     });
     	
     function selectionAdded(elem)
	 {	     	     
	 	var item=$("[name='userSelector']");
				if(item&&item.attr("value")){
				     var selection = imgAreaSelect.getSelection();	                  
	                 loadPhotoTags(-1,selection.x1,selection.y1,selection.width,selection.height,item.val().substring(0,item.val().length-1));						 
                }
        imgAreaSelect.setOptions({parent:"body",disable:true,hide:true});
		$('#UserSelectorWrap').find("a.as-close").click().end().hide();	
		return false;
	 }	

	 function loadPhotoTags(id,x1,y1,w,h,uid)
	 {	 
	    $.get('<%=SPBUrlHelper.Action("PhotoTags", "Photo", new RouteValueDictionary { { "userDomainName", currentDomainUserName } })%>',{"ID":id,"ThreadID":<%=currentPhoto.ThreadID  %>,"AreaX":x1,"AreaY":y1,"AreaWidth":w,"AreaHeight":h,"UserID":uid},function(data){
	  	$('#photo-tlist').html(data);
	  	$('.tag-del').each(function(){
	  	   $(this).bind("click",deletePhotoTagClick);
	  	});
	  	if($("#photoNoteList span").length>0)
	  	   $("#photoNoteList").show();
	  	else 
	  	   $("#photoNoteList").hide();
		loadNotes();		
	   });
	 }
	 function deletePhotoTagClick()  
	 {     
	   	var id=$(this).attr("value"); 		       
	    if(confirm("<%=GetResourceString("Message_ConfirmDeleteTag",ApplicationIDs.Instance().Photo())%>"))
	      loadPhotoTags(id,-1,-1,-1,-1,-1);
	 }
	 
    </script>
    
    <div id="UserSelectorWrap" style="display:none" class="spb-photo-note tn-widget-content tn-border-gray">  
    <%Html.RenderAction("Control_FriendSelector", "Channel", new RouteValueDictionary { { "controlName", "userSelector" }, { "selectionLimit", "1" }, { "selectionAdded", "selectionAdded" } });%>                        
    </div>
    <%} %>
    <%}
                } %>
                <% }%>
</asp:content>
