﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-ShowPhotoExif"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% ViewData["PhotoSubMenu"] = null;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server">
</asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
  <% PhotoThread currentPhoto = ViewData.Get<PhotoThread>("currentPhoto");
     List<TunyNet.ImageMetadata.Tag> exifTags = (List<TunyNet.ImageMetadata.Tag>)ViewData.Model;

     PhotoImageType imageType = ViewData.Get<PhotoImageType>("PhotoImageType");
     if (currentPhoto != null)
     {  %>
          <div id="ShowPhotoExif" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photo-exif">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"> <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",currentPhoto.ThreadID}}) %>"> <%=GetResourceString("Action_GoBackPhotoBrowse",ApplicationIDs.Instance().Photo())%></a></span>
            <h3 class="tn-helper-reset"> &quot;<%=string.Format(GetResourceString("Title_ParticularProperty",ApplicationIDs.Instance().Photo()), currentPhoto.Subject)%>&quot;</h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="tn-helper-clearfix">
              <div class="spb-photo-container tn-helper-left"><%=SPBHtmlHelper.Instance().ShowPicture(currentPhoto, PhotoImageType.SecondaryThumbnail,SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",currentPhoto.ThreadID}}))%>
                <p><strong>
                <a href="<%=SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary {{"userDomainName",userDomainName},{"threadID",currentPhoto.ThreadID}}) %>">
                    <%=currentPhoto.Subject%></a>
                </strong></p>
                <p class="tn-text-note"> <%=GetResourceString("Action_UpLoad",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(currentPhoto.PostDate)%></p>
              </div>
              <div class="tn-info-part">
                <h4 class="tn-text-heading tn-border-gray tn-border-bottom"><%=GetResourceString("Title_CameraInformations",ApplicationIDs.Instance().Photo())%></h4>
                    <% if (exifTags != null && exifTags.Count > 0)
                       {
                           foreach (TunyNet.ImageMetadata.Tag metaTag in exifTags)
                           {
                               if (metaTag != null)
                               {%>

            <% if (metaTag.GetTagName() == "Make")
               {%>
            <dl>
            <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
            <dd> <%=metaTag.GetDescription()%> </dd>
            </dl>
            <%}%>
            <% if (metaTag.GetTagName() == "Model")
               {%>
               <dl>
            <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
            <dd>   <%=metaTag.GetDescription()%></dd>
            </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "X Resolution")
               {%>
               <dl>
            <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
            <dd>  <%=metaTag.GetDescription()%></dd>
            </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Y Resolution")
               {%>
               <dl>
            <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
            <dd>   <%=metaTag.GetDescription()%></dd>
            </dl>

            <%}%>
            <% if (metaTag.GetTagName() == "Resolution Unit")
               {%>
               <dl>
            <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
            <dd> <%=metaTag.GetDescription()%> </dd>
            </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Software")
               {%>
               
               <dl>
            <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
            <dd> <%=metaTag.GetDescription()%> </dd>
            </dl>
           
            <%}%>
            <% if (metaTag.GetTagName() == "Exif Offset")
               {%>
               <dl>
            <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
            <dd>  <%=metaTag.GetDescription()%> </dd>
            </dl>
            
            <%}%>
            <%}

                   }
               } %>

              </div>
              <div class="tn-info-part">
                <h4 class="tn-text-heading tn-border-gray tn-border-bottom"><%=GetResourceString("Title_PhotoInformation",ApplicationIDs.Instance().Photo())%></h4>
                 <% if (exifTags != null && exifTags.Count > 0)
                    {
                        foreach (TunyNet.ImageMetadata.Tag metaTag in exifTags)
                        {
                            if (metaTag != null)
                            {%>
            <% if (metaTag.GetTagName() == "Exposure Time")
               {%>
               <dl>
               <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
               <dd>   <%=metaTag.GetDescription()%></dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "F-Number")
               {%>
               <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
               <dd> <%=metaTag.GetDescription()%>  </dd>
               </dl>
        
            <%}%>
            <% if (metaTag.GetTagName() == "ISO Speed Ratings")
               {%>
               
               <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd>  <%=metaTag.GetDescription()%> </dd>
               </dl>
           
            <%}%>
            <% if (metaTag.GetTagName() == "Date/Time Original")
               {%>
                <dl>
               <dt>  <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd> <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Date/Time Digitized")
               {%>
                <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd> <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Exposure Bias Value")
               {%>
                <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
               <dd>  <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Max Aperture Value")
               {%>
                <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd>  <%=metaTag.GetDescription()%> </dd>
               </dl>
           
            <%}%>
            <% if (metaTag.GetTagName() == "Metering Mode")
               {%>
                <dl>
               <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
               <dd> <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            
            <%}%>
            <% if (metaTag.GetTagName() == "Light Source")
               {%>
                <dl>
               <dt>  <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd> <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Focal Length")
               {%>
                <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd>   <%=metaTag.GetDescription()%></dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Exif Image Width")
               {%>
                <dl>
               <dt> <%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%></dt>
               <dd> <%=metaTag.GetDescription()%> </dd>
               </dl>
            
            <%}%>
            <% if (metaTag.GetTagName() == "Exif Image Height")
               {%>
                <dl>
               <dt><%= ResourceManager.GetString("Metadata:" + metaTag.GetTagName())%> </dt>
               <dd>  <%=metaTag.GetDescription()%> </dd>
               </dl>
          
            <%}%>
            <%}

                   }
               } %>
                
               
              </div>
            </div>
          </div>
        </div>
  <%} %>
</asp:content>
<asp:content runat="server" id="sidebarContent" contentplaceholderid="sidebarContent">
</asp:content>
