﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-SlideShowPhotosByCategory"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
    <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
       Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>
<asp:content id="WideContentRegion" contentplaceholderid="WideContentRegion" runat="server">
</asp:content>
<asp:content id="mainContent" runat="server" contentplaceholderid="mainContent">
       <%
           int applicationID = ApplicationIDs.Instance().Photo();
           UserCategory currentCategory = ViewData.Get<UserCategory>("currentCategory");
           User currentDomainUser = ViewData.Get<User>("currentDomainUser", null);
           string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
           bool isManager = ViewData.GetBool("isManger", false);
           int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
           bool passwordRight = ViewData.GetBool("passwordRight", false);
           bool isMyFriend = ViewData.GetBool("isMyFriend", false);
           bool isShowPhotos = false;
  %>
  <%if (currentCategory != null)
    {
        switch (currentCategory.PrivacyStatus)
        {
            case PrivacyStatuses.NeedPassword:
                if (isManager || passwordRight)
                    isShowPhotos = true;
                else
                {%>
                <%
                    if (TempData["StatusMessageType"] != null)
                    {
                        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                        if (messageType == StatusMessageType.Success)
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
                        }
                        else
                        {
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 5000));
                        }
                        TempData["StatusMessageType"] = null;%>
                    <%} %>
                <div class="tn-widget">
                  <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-key"></span></span>
                    <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowPhtotoNeedPassword",applicationID) %>。
                    <a href="<%=SPBUrlHelper.Action("Control_PrivacyPassword", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID }}) %>" id="havepwd"><%=GetResourceString("Common_HavePassword") %></a>                
                  </div>
                 </div>
                </div>
                <script type="text/javascript">
                    $(document).ready(function() {
                        $('#havepwd').dialog();
                    });
                </script>
                <%} break;
            case PrivacyStatuses.OnlyFriend:
                if (isManager || isMyFriend)
                    isShowPhotos = true;
                else
                {
            %>
            <div class="tn-widget">
              <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-limit"></span></span>
                <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowPhtotoForFriend",applicationID) %>
                <%if (CurrentUser == null)
                  { %>
                <a href="<%=SiteUrls.Instance().Login(true) %>"><%=GetResourceString("Action_LoginFirst",ApplicationIDs.Instance().User()) %></a>
                <%}
                  else
                  { %>
                <a id="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,currentDomainUser.UserID)%>"> <%= GetResourceString("Action_AddFriend")%></a>
                <%} %>
                </div>
              </div>
            </div>
            <script type="text/javascript">
                $(document).ready(function() {
                    $('#addFriendModal').nyroModal({
                        resizeable: true
                    });
                }); 
    </script>
            <%   } break;
            case PrivacyStatuses.Privacy:
                if (isManager)
                    isShowPhotos = true;
                else
                {%>
            <div class="tn-widget">
              <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(userDomainName,applicationID) %>"><%=GetResourceString("Action_GoBackAllGalerllery",applicationID) %></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-lock"></span></span>
                <div class="tn-helper-flowfix"><%=GetResourceString("Message_ShowAlbumForSelf",applicationID) %></div>
              </div>
            </div>
                <%
                } break;
            case PrivacyStatuses.Public:
                isShowPhotos = true;
                break;
        }
    } %>
  
  <%if (isShowPhotos)
    { %>
  <div id="SlideShowPhotosByCategory" class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-photos">
              <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"><%=GetResourceString("Title_Gallery",applicationID) %><%=GetResourceString("Common_Colon") %><%=currentCategory.CategoryName %></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <div class="tn-list-header">
          <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            
            <%=GetResourceString("Label_BrowseModel",applicationID)%><%=GetResourceString("Common_Colon") %>
             <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-browse-detail"></span>
              <a class="tn-action-text" href="<%=SiteUrls.Instance().ShowPhotoCategory(userDomainName,categoryID) %>"><%=GetResourceString("Action_Thumbnail", applicationID)%></a>
             </span>
             <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-browse-small"></span>
              <a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListWallPhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",categoryID}}) %>"><%=GetResourceString("Action_Particular", applicationID)%></a>
             </span>
              <span class="tn-action tn-action-text-icon tn-text-note tn-selected"><span class="tn-icon tn-icon-browse-slide"></span>
              <a class="tn-action-text" href="<%=SPBUrlHelper.Action("SlideShowPhotosByCategory", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID",categoryID } })%>"><%=GetResourceString("Action_SlideShow",applicationID)%></a></li>
              </span>
              </div>
          
        </div>
        <div class="spb-photos-slide-container"><iframe height="480" width="530" style="border:0" src="<%=SPBUrlHelper.Action("Control_SlideShowPhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",Html.GetParameterFromRouteDateOrQueryString("categoryID",0)},{"tagName",Html.GetParameterFromRouteDateOrQueryString("tagName")}}) %>">
              </iframe></div>
          </div>
            </div>
   <%} %>
</asp:content>
<asp:content id="sidebarContent" runat="server" contentplaceholderid="sidebarContent">
<% UserCategory currentCategory = ViewData.Get<UserCategory>("currentCategory");
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
    Html.RenderAction<PhotoController>(n => n.Control_ShowUserCategory(userDomainName, categoryID));
    
   if (currentCategory != null && currentCategory.PrivacyStatus == PrivacyStatuses.Public)
        Html.RenderAction<PhotoController>(n => n.Control_ListPhotoCategories(userDomainName, categoryID, 2));
%>
</asp:content>
