﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-UploadPhotos"
</asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["PhotoUserDomainSubMenu"] = PhotoUserDomainSubMenus.myPhotoCategory;
     Html.RenderPartial("Controls/Photos/SubMenu.ascx"); %>
</asp:content>

<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="WideContent" runat="server" contentplaceholderid="WideContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      User currentDomainUser = (User)ViewData.Model;
      string uploadPhotoTypes = ViewData.GetString("uploadPhotoTypes");
      string flashUrl = Globals.GetFullUrlInFileHandlerSite(PhotoAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
      int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
      PhotoAttachmentSettings photoAttachmentSettings = ViewData.Get<PhotoAttachmentSettings>("photoAttachmentSettings");
      User curerntUser = Globals.GetCurrentUser();
      int applicationID = ApplicationIDs.Instance().Photo();
     %>

<div id="UploadPhotos" class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-photos">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("Home","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Action_GoBackAllGalerllery", applicationID)%></a></span>
            <h3 class="tn-helper-reset"><%=GetResourceString("Title_SetManyImage",applicationID)%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="tn-form">
              <div class="tn-form-row">
                <label class=""><%=GetResourceString("Label_BelongToPhoto", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <% Html.RenderAction<PhotoController>(n => n.Control_PhotoUserCategoryDropdownList(userDomainName, categoryID, "photoUserCategoryDDL", "tn-dropdownlist")); %>
              </div>
              <div class="tn-widget">
                <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                  <div class="tn-helper-flowfix"> <strong><%=GetResourceString("Message_Tips",applicationID) %><%=GetResourceString("Common_Colon") %></strong><%=string.Format(GetResourceString("Message_OneTimeAllSelect",applicationID),photoAttachmentSettings.MaxPhotoCountATime ,photoAttachmentSettings.MaxAttachmentSize ,photoAttachmentSettings.Extensions) %></div>
                </div>
              </div>
              <div class="spb-upload-control-area tn-helper-clearfix">
                <div class="spb-upload-control"><% Html.RenderAction<ChannelController>(n => n.Control_UploadAttachment(SiteUrls.Instance().PhotoUpload(), flashUrl, currentDomainUser.UserID, uploadPhotoTypes, "photoUserCategoryDDL", photoAttachmentSettings.MaxPhotoCountATime, photoAttachmentSettings.MaxAttachmentSize.ToString())); %></div>
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-left">
          <div class="tn-bubble-box-arrow"><b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b6 tn-widget-content tn-bg-light"></b><b class="tn-arrow-b7 tn-widget-content tn-bg-light"></b></div>
          <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
            <ul>
              <li><%=GetResourceString("Message_UseMouse",applicationID) %></li>
              <li><%=GetResourceString("Message_UseCtrl",applicationID) %></li>
              <li><%=GetResourceString("Message_UseCtrlAddA",applicationID) %></li>
              <li class="tn-border-light"><img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/upload-tip.png") %>"></li>
            </ul>
          </div>
        </div>
              </div>
              <div id="uploadrOk" style="display: none" class="tn-form-row tn-form-row-button"> 
              <%=GetResourceString("Label_UploadYouCan",applicationID)%>
              <%=SPBHtmlHelper.Instance().LinkButton("editUploadPhotos",GetResourceString("Label_EditDecription",applicationID),"javascript:;", ButtonSizes.Large, HighlightStyles.Primary) %>
              <%=SPBHtmlHelper.Instance().LinkButton("reUploadPhotos",GetResourceString("Action_GoOnUpload",applicationID),SPBUrlHelper.Action("UploadPhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}), ButtonSizes.Large, HighlightStyles.Secondary) %>
              </div>
              <div id="advanceSettingOutDiv" class="tn-form-row tn-form-row-button"> 
              <%=SPBHtmlHelper.Instance().Button("uploadPhotos", GetResourceString("Button_Upload"), ButtonSizes.Large, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "uploadPhotosClick();" } },null)%>
              <% if (Request.UrlReferrer != null) { Response.Write(SPBHtmlHelper.Instance().LinkButton("candlerUploadPhotos", GetResourceString("Button_Cancel"), Request.UrlReferrer.AbsoluteUri, ButtonSizes.Large, HighlightStyles.Secondary)); } %>
              </div>
            </div>
          </div>
        </div>
        
  <script type="text/javascript">
      function allUploadHandler(numFilesUploaded) {
          $("#SWFUpload_0").hide();
          $("#btnCancel").attr('style', 'display:none');
          $("#uploadrOk").attr('style', 'display:block');
          $("#editUploadPhotos").attr('href', '<%=SPBUrlHelper.Action("EditPhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' + "?photoCount=" + numFilesUploaded.toString());
          $("#advanceSettingOutDiv").attr('style', 'display:none');
      }

      var uploadPhotosClick = function() {
          if ($('.progressWrapper:visible').length < 1) {
              alert('<%=GetResourceString("Message_SelectUploadPhoto",applicationID) %>')
          } else {
              $('#advanceSettingOutDiv').attr('style', 'display:none');
              uploadAttachmentsStart();
          }
      }
      </script>
</asp:content>
