﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<int, AccountBinding>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <% ViewData["PersonProfileMenu"] = PersonProfileMenu.AccountBinding;
     ViewData["CompanyProfileMenu"] = CompanyProfileMenu.AccountBinding;
     Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData);%>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-binding">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
           }
           TempData["StatusMessageType"] = null;
           bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
           bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
        <table>
            <tbody>
            <%if (enableSina)
              { %>
                <tr>
                    <td>
                        <p>
                            <span class="tn-img-sprite spb-third-id-btn spb-third-id-sina">新浪微博账号</span></p>
                        <p>
                            <% if (Model.ContainsKey(AccountTypes.Instance().SinaWeibo()))
                               { %>
                            <em>已绑定新浪微博</em>
                            <a name="deleteButton" href="<%=SPBUrlHelper.Action("DeleteBinding","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"accountType",AccountTypes.Instance().SinaWeibo()}}) %>">
                                取消</a>
                            <%}
                               else
                               { %>
                            <a href="javascript:;" onclick="openSina();return false;">绑定新浪微博</a>
                            <%} %>
                        </p>
                    </td>
                    <td>
                        <p class="tn-text-note">
                            可用新浪微博帐号登录，发布微博时同步到新浪微博</p>
                    </td>
                </tr>
                <%}
              if (enableQQ)
              { %>
                <tr>
                    <td>
                        <p>
                            <span class="tn-img-sprite spb-third-id-btn spb-third-id-qq">QQ号</span></p>
                        <p>
                            <% if (Model.ContainsKey(AccountTypes.Instance().QQ()))
                               {  %>
                            <em>已绑定QQ号</em>
                            <a name="deleteButton" href="<%=SPBUrlHelper.Action("DeleteBinding","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"accountType",AccountTypes.Instance().QQ()}}) %>">
                                取消</a>
                            <%}
                               else
                               { %>
                            <a href="javascript:;" onclick="openQQ();return false;">绑定QQ号</a>
                            <%} %>
                        </p>
                    </td>
                    <td>
                        <p class="tn-text-note">
                            可用QQ帐号登录</p>
                    </td>
                </tr>
                <%} %>
            </tbody>
        </table>
    </div>
</div>
<% string confirmText = string.Format("你确定要解除绑定么？解除绑定后，你依然可以用{0}登录本站", userDomainName);
   if (Model.Count == 1)
       confirmText = string.Format("危险！你正在试图解除所有绑定，如果想继续使用{0}网站账号，只能通过找回密码或者立即绑定其他账号，仍然要继续解除绑定吗？", userDomainName);%>
  <script type="text/javascript">
      $(document).ready(function() {
          $("a[name='deleteButton']").click(function() {
              if (!confirm('<%=confirmText%>'))
                  return false;
          });
      });
      function openQQ() {
          var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
      }
      function openSina() {
          var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
      }

    </script>
</asp:content>
