﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<UserActivitySettings>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Notice;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>

  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
     <div class="tn-box-content tn-widget-content tn-corner-all">
       <ul class="tn-side-menu">
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("NoticeSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_NoticeSettings", applicationID)%></a></li>
         <% if (!ViewData.GetBool("isCompanyUser", false))
            { %>
         <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ActivitySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ActivitySettings", applicationID)%></a></li>
         <%} %>
       </ul>
     </div>
   </div>


</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">

<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>

   <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-notice-settings">
     <div class="tn-box-content tn-widget-content tn-corner-all">
       <form action="<%=SPBUrlHelper.Action("UpdateActivitySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
             method="post">
         <% if (TempData["StatusMessageData"] != null)
            {
                StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
                if (messageData.MessageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData.MessageType, messageData.MessageContent, 3000));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
                TempData["StatusMessageData"] = null;
            }
            UserActivitySettings userActivitySettings = ViewData.Model;
            Dictionary<string, ActivityItem> items = ViewData.Get<Dictionary<string, ActivityItem>>("Items", new Dictionary<string, ActivityItem>());%>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
          <h4 class="tn-helper-reset"><a href="JavaScript:;"><%=GetResourceString("Label_SentUserActivitiesSetting", applicationID)%></a></h4>
          <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span>
        </div>
        <div class="tn-collapsible-content">
           <p class="tn-text-note"><%=GetResourceString("Description_SendUserActivitySettings", applicationID)%></p>
           <p class="tn-check-all">
            <input type="checkbox" id="topCheckBox1" class="tn-checkbox" />
            <strong><%=GetResourceString("Label_SelectAllOrNo") %></strong>
           </p>
           <ul class="tn-helper-reset tn-helper-clearfix tn-list-quarter spb-set-list">
           <% foreach (var item in items)
              {
                  bool isAllow = userActivitySettings.IsAllowedInActivityItemsOfSending(item.Key);%>
            <li>
              <input type="checkbox" id="Send<%=item.Key %>" name="Send<%=item.Key %>" <%  if (isAllow) Response.Write("checked=\"checked\""); %> class="tn-checkbox"  value="true" />
              <%=item.Value.GetMultilingualItemName(CurrentUserLanguage)%></li>
          <%} %>
          </ul>
        </div>
     </div>
      <div class="tn-blank10"></div>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
          <h4 class="tn-helper-reset"><a href="JavaScript:;"><%=GetResourceString("Label_ReceiveUserActivitiesSetting", applicationID)%></a></h4>
          <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span>
        </div>
        <div class="tn-collapsible-content">
           <p class="tn-text-note"><%=GetResourceString("Description_ReceiveUserActivitySettings",applicationID)%></p>
           <p class="tn-check-all">
            <input type="checkbox" id="topCheckBox2" class="tn-checkbox" />
            <strong><%=GetResourceString("Label_SelectAllOrNo") %></strong>
           </p>
           <ul class="tn-helper-reset tn-helper-clearfix tn-list-quarter spb-set-list">
           <% foreach (var item in items)
              {
                  bool isAllow = userActivitySettings.IsAllowedInActivityItemsOfReceiving(item.Key);%>
            <li>
              <input type="checkbox" id="Receive<%=item.Key %>" name="Receive<%=item.Key %>" <%  if (isAllow) Response.Write("checked=\"checked\""); %> class="tn-checkbox"  value="true" />
              <%=item.Value.GetMultilingualItemName(CurrentUserLanguage)%></li>
          <%} %>
          </ul>
        </div>
     </div>
      <div class="tn-blank10"></div>
      <div class="tn-collapsible tn-collapsible-closed">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
          <h4 class="tn-helper-reset"><a href="JavaScript:;"><%=GetResourceString("Label_SetIgnoreFriends",applicationID)%></a></h4>
          <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span>
        </div>
        <div class="tn-collapsible-content">
          <p class="tn-text-note"><%=GetResourceString("Description_SetIgnoreFriends",applicationID)%></p>
           <div class="tn-helper-clearfix spb-blacklist">
                      <div class="tn-border-gray spb-friends">
              <p class="tn-border-gray tn-border-bottom"><strong><%=GetResourceString("Label_myFriends",applicationID)%><%=GetResourceString("Common_Colon") %></strong> <%=GetResourceString("Description_HowSetIgnoreFriends",applicationID)%></p>
               <ul id="myFirends">
                 <% Dictionary<int, string> myOddFriends = ViewData.Get<Dictionary<int, string>>("myOddFriends", new Dictionary<int, string>());
                    foreach (KeyValuePair<int, string> pair in myOddFriends)
                    {%>
                    <li>
                 <a href="javascript:;" title="<%=GetResourceString("Description_ClickSetIgnoreFriend",applicationID)%>" value="<%=pair.Key %>" class="friendBucketUnit"> <%=pair.Value%></a>
                </li> <%  } %>
                 </ul>
               </div>
           
               <div class="tn-border-gray spb-friends">
              <p class="tn-border-gray tn-border-bottom"><strong><%=GetResourceString("Label_ListIgnoreFirends",applicationID)%></strong> <%=GetResourceString("Description_HowSetIgnoreFriendOut",applicationID)%></p>
                <ul id="myIgnoreFriends">
                 <%foreach (KeyValuePair<int, string> pair in userActivitySettings.IgnoredFriendUsersForReceiveActivities)
                   {%>
                 <li>
                   <span> <%=pair.Value %></span>
                   <a href="javascript:;" class="friendBucketCancel" title="<%=GetResourceString("Button_Remove")%><%=pair.Value %>"
                                   value="<%=pair.Key %>"><%=GetResourceString("Button_Remove")%></a>
                   <input type="hidden" id="ignoreFriendUser" name="ignoreFriendUser" value="<%=pair.Key %>&<%=pair.Value %>" />
                </li>
                 <%}%>
                 </ul>
               </div>
             </div>
           </div>
         </div>
      <div class="tn-blank10"></div>
      <div class="tn-form">
         <div class="tn-form-row tn-form-row-button tn-helper-align-center">
          <%=SPBHtmlHelper.Instance().SubmitButton("updateButton", GetResourceString("Action_UpdateUserActivitySettings", applicationID), ButtonSizes.Default, null, null)%>
          <% if (Request.UrlReferrer != null)
             { %>
          <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "window.location.href='" + Request.UrlReferrer.AbsoluteUri + "'" } }, null)%>
          <%} %> 
         </div>
      </div>
      </form>
    </div>
  </div>
  
  <script type="text/javascript">
        $(document).ready(function() {
            $("#myFirends a").click(addFriend);
            $("#myIgnoreFriends a").click(addIgnoreFriend);

            $("#topCheckBox1").click(function() {
                if (this.checked)
                    $("input[name^='Send']").attr('checked', 'checked');
                else
                    $("input[name^='Send']").removeAttr('checked');
            });
            $("#topCheckBox2").click(function() {
                if (this.checked)
                    $("input[name^='Receive']").attr('checked', 'checked');
                else
                    $("input[name^='Receive']").removeAttr('checked');
            });
            $(".tn-collapsible").collapsibleBox();
        });
        function addFriend() {
            var value = $(this).attr("value");
            var text = $(this).text().replace(/\r/g, "").replace(/\n/g, "").replace(/ /g, "");
            $("#myFirends a[value='" + value + "']").parent().remove();
            $("#myIgnoreFriends").append("<li><span>" + text + "</span>"
                  + "&nbsp;<a href=\"javascript:;\" class=\"friendBucketCancel\" title=\"<%=GetResourceString("Button_Remove")%>" + text + "\" value=\"" + value + "\"><%=GetResourceString("Button_Remove")%></a>"
                  + "<input type=\"hidden\" id=\"ignoreFriendUser\" name=\"ignoreFriendUser\" value=\"" + value + "&" + text + "\" /> "
                  + "</li>");
            $("#myIgnoreFriends a").unbind("click").click(addIgnoreFriend);
        }
        function addIgnoreFriend() {
            var value = $(this).attr("value");
            var text = $(this).siblings("span").text().replace(/\r/g, "").replace(/\n/g, "").replace(/ /g, "");
            $("#myIgnoreFriends a[value='" + value + "']").parent().remove();
            $("#myFirends").append("<li><a href=\"javascript:;\" title=\"<%=GetResourceString("Description_ClickSetIgnoreFriend",applicationID)%>\" value=\"" + value + "\" class=\"friendBucketUnit\">" +
                text + "</li></a>");          
            $("#myFirends a").unbind("click").click(addFriend);
        }
        
        
    </script>

</asp:content>
