﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <% ViewData["PersonProfileMenu"] = PersonProfileMenu.ChangePassword;
     ViewData["CompanyProfileMenu"] = CompanyProfileMenu.ChangePassword;
     Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-change-password">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             if (messageType == StatusMessageType.Success)
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
             else
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
         } TempData["StatusMessageType"] = null;%><form class="tn-helper-reset" id="ChangePasswordForm" action="<%=SPBUrlHelper.Action("UpdatePassword","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" method="post">
        <div class="tn-form tn-label-right">
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ShowUserName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <%=userDomainName %></div>
          <%
              if (ViewData.GetBool("isShowOldPassword", true))
              {%><div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_OldPassword",applicationID)%><%=GetResourceString("Common_Colon") %></label><input type="password" id="oldPassword" name="oldPassword" class="tn-textbox tn-input-long tn-border-gray" />
          </div><%} %>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_NewPassword",applicationID)%><%=GetResourceString("Common_Colon") %></label><input type="password" id="newPassword1" name="newPassword1" class="tn-textbox tn-input-long tn-border-gray" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ConfirmPassword", applicationID)%><%=GetResourceString("Common_Colon") %></label><input type="password" id="newPassword2" name="newPassword2" class="tn-textbox tn-input-long tn-border-gray" />
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label><%=SPBHtmlHelper.Instance().SubmitButton("changePasswordButton", GetResourceString("Action_ChanagePassword", applicationID),ButtonSizes.Default,null,null)%> </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function () {
          $("#ChangePasswordForm").validate({
              rules: {
                  oldPassword: { required: true },
                  newPassword1: { required: true },
                  newPassword2: { required: true, equalTo: "#newPassword1" }
              },
              messages: {
                  oldPassword: { required: '<%=GetResourceString("Validate_OldPassword_Required",applicationID) %>' },
                  newPassword1: { required: '<%=GetResourceString("Validate_NewPassword1_Required",applicationID) %>' },
                  newPassword2: { required: '<%=GetResourceString("Validate_NewPassword2_Required",applicationID) %>', equalTo: '<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID) %>' }
              }
          });
          $("#changePasswordButton").click(function () {
              if (!$("#ChangePasswordForm").valid()) {
                  return false;
              }
          });
      });
    </script>
</asp:content>
