﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Advertising>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Advertising;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-side-menu">
        <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditAdvertising","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Title_NewAdvertising",applicationID)%></a></li>
        <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageAdvertisings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ManageAdvertisings",applicationID)%></a></li>
      </ul>
    </div>
  </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%   
                if (TempData["StatusMessageType"] != null)
                {
                    StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                    if (messageType == StatusMessageType.Success)
                    {
                        Response.Write(string.Format("<script type=\"text/javascript\">window.location.href='{0}'</script>", SPBUrlHelper.Action("ManageAdvertisings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })));
                    }
                    else
                    {
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                    }
                }
                TempData["StatusMessageType"]=null;
                %>
      <%Advertising advertising = ViewData.Model; %>
      <form id="editor" method="post" action="<%=SPBUrlHelper.Action("CreateUpdateAdvertising","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"advertisingID",advertising.AdvertisingID}}) %>">
        <div class="tn-form tn-label-right ">
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_AdvertisingName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" id="tbadname" class="tn-textbox tn-input-medium tn-border-gray" name="advertisingName" value="<%=advertising.AdvertisingName %>" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_AdvertisingStartTime",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateFrom", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateFrom, false, "tn-textbox tn-input-medium tn-border-gray")); %>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_AdvertisingEndTime",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateTo", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateTo, false, "tn-textbox tn-input-medium tn-border-gray")); %>
          </div>
          <div class="tn-form-row tn-textarea-wrap">
            <label class="tn-form-label"><%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %> </label>
            <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isEnabled", advertising.IsEnabled, new RouteValueDictionary { { "Class", "radiobutton" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_AdvertisingScript",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <textarea id="script" class="tn-textarea tn-input-long tn-border-gray" style="width:300px; height:140px" name="script"><%=advertising.Script %></textarea>
            <span style="display:none"></span>
          </div>
        </div>
        <div id="apforjueryload">
          <%Html.RenderAction<UserDomainSettingsController>(n => n.Control_ListAdvertisingPositions(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), advertising.AdvertisingID, null)); %>
        </div>
        <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%> <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Action_Return"), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "cancle()" } }, null)%> </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function() {
          $("#editor").validate({ rules: { advertisingName: { required: true },
              script: { required: true }
          }, messages: { advertisingName: { required: '<%=GetResourceString("Validate_PrivateAdvertisingNameRequired",applicationID)%>' },
              script: { required: '<%=GetResourceString("Validate_PrivateAdvertisingScriptRequired",applicationID)%>' }
          }
          }); $("#submitButton").click(function() {
              if (!$("#editor").valid()) {
                  return
                  false;
              }
          });
      });
      function cancle() {
          window.location.href =
     '<%=SPBUrlHelper.Action("ManageAdvertisings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>';
      }      
   </script>
</asp:content>
