﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<ForumUserData>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% ViewData["PersonProfileMenu"] = PersonProfileMenu.ForumSignature;
     ViewData["PersonProfileMenu"] = PersonProfileMenu.ForumSignature;
   Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%      int applicationID = ApplicationIDs.Instance().User(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-forum-signature">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
          <h3 class="tn-helper-reset"> <%=GetResourceString("Title_ForumInfor", ApplicationIDs.Instance().User())%> </h3>
        </div>
      </div>
      <div class="tn-blank10"></div>
      <% if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
            }
            TempData["StatusMessageType"]=null;%>
      <form id="signatureForForum" action="<%=SPBUrlHelper.Action("UpdateForumSignature","UserDomainSettings", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") } })%>" method="post">
        <div class="tn-form">
          <div class="tn-form-row">
            <%string forumBody = string.Empty;
             if (Model != null)
             {
                 forumBody = Model.Signature;                
             %>
            <%= SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "forumBody", forumBody, new RouteValueDictionary { { "id", "forumBody" }, { "style", "width:100%;height:270px" } }, null, null)%>
            <%}
             else
             {         
         
               %>
            <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "forumBody", string.Empty, new RouteValueDictionary { { "id", "forumBody" }, { "style", "width:100%;height:270px" } }, null, null)%>
            <%} %>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <%=SPBHtmlHelper.Instance().SubmitButton("saveForumButton", GetResourceString("Button_OK"), ButtonSizes.Large,null, null)%> </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
         $(document).ready(function() {
                $("#signatureForForum").validate({
                      rules: {                    
                          forumBody: { htmlEditorRequired: true,htmlEditorRange:[0,1000]},            
                      },
                      messages: {                   
                          forumBody: { htmlEditorRequired: "<%=GetResourceString("Message_UpdateProfileError", applicationID)%>", htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength", applicationID), 10000)%>" }                 
                     }
                 });     
            
              });
        </script>
</asp:content>
