﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<IList<Application>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.ManageApplications;
     Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData);%>
</asp:content>

<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();
    User currentDomainUser = Users.GetUser(userDomainName, false);
      %>
<div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ManageApplications", "UserDomainSettings", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">返回应用管理</a></span>
        <h3 class="tn-helper-reset">添加应用</h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, "添加应用程序失败！"));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 5000, false));
            TempData["StatusMessageData"] = null;
        } %>
      <table class="tn-table-grid">
        <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplicationName",applicationID) %> </th>
            <td class="tn-border-gray tn-border-bottom tn-text-note"></td>
          </tr>
          
          <%if (Model != null)
            {
                foreach (Application app in Model)
                {
                    if (currentDomainUser.UserType == UserTypes.PersonUser && Applications.IsInstalled(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID, app.ApplicationID))
                        continue ;
                    if (currentDomainUser.UserType == UserTypes.CompanyUser && Applications.IsInstalled(PresentAreaIDs.Instance().CompanyUserDomain(), currentDomainUser.UserID, app.ApplicationID))
                        continue;
                    %>
          <tr class="tn-table-grid-row">
            <th class="tn-border-gray tn-border-bottom tn-width-auto"><%=app.ApplicationName%></th>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">

            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_InstallApplication", applicationID), SPBUrlHelper.Action("InstallApplication", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", app.ApplicationID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
            </td>
          </tr>
          <%
                }
            }%>
        </tbody>
      </table>
    </div>
  </div>
</div>
</asp:content>
