﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<Advertising>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Advertising;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">         
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <ul class="tn-side-menu">
                     <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditAdvertising","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Title_NewAdvertising",applicationID)%></a></li>
                     <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageAdvertisings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ManageAdvertisings",applicationID)%></a></li>     
                </ul>
            </div>
        </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
 <div id="ManageAdvertisingsDiv">

      <div class="tn-box tn-widget tn-widget-content tn-corner-all">
           <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <form method="post" name="manageAdvertisingsForm" id="manageAdvertisingsForm"  >
                    <div class="tn-list-header">                    
                        <div class="tn-toolbar tn-helper-clearfix">
                            <div class="tn-tool-form">                         
                                 <%=SPBHtmlHelper.Instance().LinkButton("deleteButton", GetResourceString("Button_BatchDelete"), "", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "deleteAdvertisings()" } },null)%>                        
                            </div>
                        </div>                    
                    </div>
                    <div class=" tn-loading" style="display: none;" id="loading">
                    </div>
                    <table class="tn-table-grid">
                       <tr class="tn-table-grid-header">                        
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                           <input type="checkbox" onclick="checkAll(this,'advertisingCheckBoxGroup')" />
                        </td>                        
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                          <%=GetResourceString("Label_AdvertisingName",applicationID)%> 
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                         <%=GetResourceString("Label_AdvertisingStartTime", applicationID)%>                        
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                         <%=GetResourceString("Label_AdvertisingEndTime",applicationID)%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                          <%=GetResourceString("Label_IsEnabled")%>
                        </td>                       
                        <td class="tn-border-gray tn-border-bottom tn-text-note">
                          <%=GetResourceString("Label_Actions")%>
                        </td>                       
                    </tr>       
                        
                    <%foreach (var advertising in ViewData.Model.Records)
                      {%>
                      <tr class="tn-table-grid-row">
                      <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="advertisingCheckBoxGroup" value="<%=advertising.AdvertisingID %>" /> </td>                     
                      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=StringUtils.Trim(advertising.AdvertisingName,20) %> </td>
                      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateFrom) %> </td>
                      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(advertising.EffectiveDateTo) %> </td>
                      <td class="tn-border-gray tn-border-bottom tn-width-icon1"><%if (advertising.IsEnabled)
                                                                                   { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                                                                   else
                                                                                   { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                      </td>
                      <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap"><span class="tn-action"><a class="tn-action-text smallCommonButton" href="<%=SPBUrlHelper.Action("EditAdvertising","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"advertisingID",advertising.AdvertisingID}}) %>"> <%=GetResourceString("Action_Edit")%></a> </td>
                  </tr>
                    <%}%>            
                    
                   </table>
                     <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
                       {%>
                    <div class="tn-pagination tn-helper-align-center"> 
                       <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11,SPBUrlHelper.Action("ManageAdvertisings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex","{0}"}}))%> 
                       <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                    </div>
                  <%}%>
                </form>
           </div>
      </div>

      <script type="text/javascript">
          function deleteAdvertisings() {
              if (confirm('<%=GetResourceString("Message_UserAdvertisingDeleteConfirm",applicationID)%>'))
                  $('#manageAdvertisingsForm').ajaxSubmit({ target: '#ManageAdvertisingsDiv', url: '<%=SPBUrlHelper.Action("DeleteAdvertisings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})%>' });
          };              
      </script>
</div>  
</asp:content>
