﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<IList<Application>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.ManageApplications;
     Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    User domainUser = Users.GetUser(userDomainName, false);
    int applicationID = ApplicationIDs.Instance().User();%>
<div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset"><%=GetResourceString("Label_ManageApplications",applicationID) %></h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-toolbar-area tn-helper-clearfix">
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_AddApplication",applicationID), SPBUrlHelper.Action("ListApplications", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
      </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">

       <%if (TempData["StatusMessageData"] != null)
         {
             StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, "删除应用程序失败！"));
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 3000, false));
             TempData["StatusMessageData"] = null;
         } %>
      <table class="tn-table-grid">
        <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplicationName",applicationID) %> </th>
            <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplicationItemCount", applicationID)%></td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_UnInstallApplication", applicationID)%> </td>
          </tr>
          <%if (Model != null)
            {
                bool isInstalled = false;
                foreach (Application app in Model)
                {%>
          <tr class="tn-table-grid-row">
            <th class="tn-border-gray tn-border-bottom tn-width-auto"><%=app.ApplicationName%></th>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=app.GetItemCountValue(PresentAreaIDs.Instance().UserDomain(), domainUser.UserID)%></td>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
            
            <%if (domainUser != null && domainUser.UserType == UserTypes.PersonUser)
                  isInstalled = (!Applications.IsBuiltIn(PresentAreaIDs.Instance().UserDomain(), app.ApplicationID) && Applications.IsInstalled(PresentAreaIDs.Instance().UserDomain(), UserID2UserNameDictionary.GetUserID(userDomainName), app.ApplicationID));
              else
                  isInstalled = (!Applications.IsBuiltIn(PresentAreaIDs.Instance().CompanyUserDomain(), app.ApplicationID) && Applications.IsInstalled(PresentAreaIDs.Instance().CompanyUserDomain(), UserID2UserNameDictionary.GetUserID(userDomainName), app.ApplicationID));
              if (isInstalled)
              { %>
              <a class="tn-icon tn-icon-cross" href="<%=SPBUrlHelper.Action("UnInstallApplication","UserDomainSettings",new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", app.ApplicationID } })%>" title="删除"></a>
<%--            <%=SPBHtmlHelper.Instance().LinkButton("", SPBUrlHelper.Action("UnInstallApplication", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", app.ApplicationID } }), HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { {"onclick","if(!confirm(\"确认卸载当前应用？删除应用会清除用户在该应用下的所有数据！\")) return false;"}},null)%>
--%>            <%} %>
            </td>
          </tr>
          <%}
            }%>
        </tbody>
      </table>
      </div>
    </div>
  </div>
</div>
</asp:content>
