﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.UserLink;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">         
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <ul class="tn-side-menu">         
                     <li ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageUserLinks","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" target="_self"><span><%=GetResourceString("Title_ManageUserLinks",applicationID)%></span></a></li>
                     <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageUserLinkCategories","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" target="_self"><span><%=GetResourceString("Title_ManageUserLinkCategories",applicationID)%></span></a></li>
                </ul>
           </div>
        </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>

        <div class="tn-box tn-widget tn-widget-content tn-corner-all">
         <div class="tn-box-content tn-widget-content tn-corner-bottom">                
              <form action="<%=SPBUrlHelper.Action("DeleteLinkCategoryAction","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                method="post" id="categroyform">
                  <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">                  
                    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_AddUserLinkCategory", applicationID), SPBUrlHelper.Action("Control_AddLinkCategory", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "name", "LinkCategory" }, { "title", GetResourceString("Description_AddUserLinkCategory", applicationID) } }, null)%>
                    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_DeleteUserLinkCategorys", applicationID), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "if (confirm('" + GetResourceString("Message_UserLinkCategoriesDeleteConfirm", applicationID) + "')) { $('#categroyform').submit(); } else { return false; } ;" }, { "title", GetResourceString("Description_DeleteUserLinkCategories", applicationID) } }, null)%>
                   
                    <div class="tn-blank10">
                    </div>
                  </div>                
                  <table class="tn-table-grid">
                       <tr class="tn-table-grid-header" >
                          <td class="tn-border-gray tn-border-bottom tn-text-note"> <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'CategroyGroup')" /></td>
                             <td class="tn-border-gray tn-border-bottom tn-text-note">  <%=GetResourceString("Label_UserLinkCategoryName",applicationID)%> </td>
                          <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Description")%> </td>
                          <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_UserLinkDisplayOrder",applicationID)%> </td>
                          <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </td>
                        </tr>
                          <%
                              if (ViewData["LinkCategories"] != null)
                              {
                                  List<LinkCategory> LinkCategories = ViewData["LinkCategories"] as List<LinkCategory>;
                                  foreach (var item in LinkCategories)
                                  {                        
                         %>
                        <tr class="tn-table-grid-row">
                          <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" class="tn-checkbox" name="CategroyGroup" value="<%=item.CategoryID %>" /> </td>   
                          <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%=StringUtils.Trim(item.CategoryName,25) %></td>                  
                          <td class="tn-border-gray tn-border-bottom tn-width-auto"><%=StringUtils.Trim(item.Description,35) %> </td>
                          <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><%=item.DisplayOrder %> </td>
                          <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">                          
                              <%=SPBHtmlHelper.Instance().LinkButton("", string.Empty, SPBUrlHelper.Action("Control_EditLinkCategory", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "CateID", item.CategoryID } }), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Write, TextIconLayout.IconOnly, new RouteValueDictionary { { "name", "LinkCategory" }, { "title", GetResourceString("Action_EidtUserLink", applicationID) } }, null)%> 
                          </td>
                        </tr>
                         <%
                             }
                        }
                       %>
              </table>
             </form>                
           </div>
      </div>
  
  <script type="text/javascript">
      $(document).ready(function() {
          $('a[name="LinkCategory"]').nyroModal({
              resizeable: true,
              width: 450,
              height: 300
          });
      });
    </script>
</asp:content>
