﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.UserLink;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
   <div class="tn-box tn-widget tn-widget-content tn-corner-all">
           <div class="tn-box-content tn-widget-content tn-corner-bottom">
               <ul class="tn-side-menu">
                   <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text"
                       href="<%=SPBUrlHelper.Action("ManageUserLinks","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" target="_self">
                       <%=GetResourceString("Title_ManageUserLinks", applicationID)%></a></li>
                   <li><a class="tn-menu-text"
                       href="<%=SPBUrlHelper.Action("ManageUserLinkCategories","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" target="_self">
                       <%=GetResourceString("Title_ManageUserLinkCategories",applicationID)%></a></li>
               </ul>
           </div>
      </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>

        <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <form id="ManageUserLinkForm" method="post" action="<%=SPBUrlHelper.Action("DeleteLinkAction","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" >
                <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_AddUserLink", applicationID), SPBUrlHelper.Action("Control_AddLink", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" }, { "name", "UserLinkAdd" }, { "title", GetResourceString("Action_AddUserLink", applicationID) } }, null)%>
             <%=SPBHtmlHelper.Instance().LinkButton("Delete", "删除友情链接", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if (confirm('确认要删除这些链接吗？')) { $('#ManageUserLinkForm').submit(); return false; } else { return false; } ;" }, { "title", "批量删除友情链接" } }, null)%>                                                           

                   <div class="tn-blank10">
                    </div>
                </div>
                <div class="tn-grid">
                    <table class="tn-table-grid">
                        <tr class="tn-table-grid-header">
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <input type="checkbox" class="tn-checkbox" id="TopCheckBox" onclick="checkAll(this,'LinkGroup')" />
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                 <%=GetResourceString("Label_Subject")%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_UserLinkCategoryName",applicationID)%> 
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_UserLinkTitle",applicationID)%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_UserLinkDisplayOrder",applicationID)%> 
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                              <%=GetResourceString("Label_Status") %>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                               <%=GetResourceString("Label_Actions")%> 
                            </th>
                        </tr>
                <%
                    if (ViewData["UserLinks"] != null)
                    {
                        List<Link> UserLinks = ViewData["UserLinks"] as List<Link>;
                        foreach (var item in UserLinks)
                        {
                    %>
                        <tr class="tn-table-grid-row">
                            <td class="tn-border-gray tn-border-bottom tn-width-check">
                                <input class="tn-checkbox" type="checkbox" name="LinkGroup" value="<%=item.LinkID %>" />
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                <%=StringUtils.Trim(item.Title,25) %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                                <%=StringUtils.Trim(item.CategoryName,25) %> 
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-nowrap">
                               <%if (item.LinkType == LinkTypes.Text) Response.Write(GetResourceString("Label_TextUserLink", applicationID)); else Response.Write(GetResourceString("Label_PictureUserLink", applicationID)); %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                                <%=item.DisplayOrder %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                                <%if (item.IsEnabled)
                                  {
                                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept));
                                  }
                                  else
                                  {
                                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross));
                                  } %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                            <%=SPBHtmlHelper.Instance().LinkButton("", string.Empty, SPBUrlHelper.Action("Control_EditLink", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "linkID", item.LinkID } }), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Write, TextIconLayout.IconOnly, new RouteValueDictionary { { "name", "UserLinkAdd" }, { "title", GetResourceString("Action_EidtUserLink", applicationID) } }, null)%>
                            </td>
                        </tr>
                        <%}
                    } %>
                    </table>
                </div>               
                </form>

            </div>
        </div>
 
  <script type="text/javascript">

      $(document).ready(function () {


          $('a[name="UserLinkAdd"]').nyroModal({
              resizeable: true,
              width: 450,
              height: 450
          });
      });
    </script>
</asp:content>
