﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<IList<OwnerNavigation>>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.ManageUserNavigations;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
  <spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
        SetExpireDays="30" />
  <spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js" SetExpireDays="30" />
  <spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js" SetExpireDays="30" />
  <div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-nav-manage">
      <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-widget">
          <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
            <div class="tn-helper-flowfix">
              <ul>
                <li><%=GetResourceString("Description_ManageUserNavigation1",applicationID) %></li>
                <li><%=GetResourceString("Description_ManageUserNavigation2",applicationID) %></li>
                <li><%=GetResourceString("Description_ManageUserNavigation3",applicationID) %></li>
              </ul>
            </div>
          </div>
        </div>
        <div class="spb-drag-adjust">
          <%if (TempData["StatusMessageType"] != null)
          {
              StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
              if (messageType == StatusMessageType.Success)
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Success, GetResourceString("Message_SetUserNavigationSucceed", applicationID), 3000));
              }
              else
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Error, GetResourceString("Message_SetUserNavigationFailed", applicationID)));
              }
              TempData["StatusMessageType"] = null;
          } %>
          <form id="menuForm" name="menuForm" method="post" action="<%=SPBUrlHelper.Action("UpdateUserNavigations","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
            <div class="tn-form">
              <%
                User currentDomainUser = Users.GetUser(Html.GetParameterFromRouteDateOrQueryString("UserDomainName"), false);
                
                    %>
              <table id="sortable">
                <tr>
                  <td><table>
                      <tr>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("Label_UserNavigationName",applicationID)%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_NavigationLink", applicationID)%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("Label_NavigationTargetSelf", applicationID)%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("Label_NavigationType", applicationID)%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("Label_NavigationApplication", applicationID)%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("Label_IsEnabled")%></td>
                        <td class="tn-border-gray tn-border-bottom tn-text-note spb-drag-td-width"><%=GetResourceString("operate", applicationID)%></td>
                      </tr>
                    </table></td>
                </tr>
                <% 
                  int i = 0;
                  foreach (OwnerNavigation navigation in Model)
                  {   
                        %>
                <tr name="sortableTr" value="<%=i %>">
                  <td><div class="spb-drag-row tn-bg-gray tn-border-gray">
                      <table>
                        <tr>
                          <td class="spb-drag-td-width"><input type="text" maxlength="12" id="navigationText_<%=i %>" name="navigationText_<%=i %>" class="tn-textbox tn-input-short tn-border-gray" value="<%=navigation.GetMultilingualNavigationName(CurrentUserLanguage) %>"/></td>
                          <td><%if (navigation.NavigationType == NavigationTypes.HyperLink)
                            {%>
                            <input type="text" id="navigationLink_<%=i %>" name="navigationLink_<%=i %>" class="tn-textbox tn-input-medium tn-border-gray" title="" value="<%=navigation.ResolvedNavigationUrl %>"/>
                            <%} %>&nbsp;</td>
                          <td class="spb-drag-td-width"><input type="checkbox" value="true" class="tn-checkbox" name="navigationTarget_<%=i %>" <%if(navigation.NavigationTarget == "_blank"){Response.Write("checked=\"checked\"");} %> id="navigationTarget_<%=i %>"/></td>
                          <td class="spb-drag-td-width"><%=navigation.NavigationType == NavigationTypes.HyperLink ? GetResourceString("Label_NavigationExternalLink", applicationID) : GetResourceString("Label_NavigationApplication", applicationID)%></td>
                          <td class="spb-drag-td-width"><%Application application = Applications.GetApplication(navigation.ApplicationID); if (application != null) { Response.Write(application.ApplicationName); } %></td>
                          <td class="spb-drag-td-width"><input type="checkbox" value="true" class="tn-checkbox" <%if (navigation.IsLocked) { Response.Write("disabled=\"disabled\""); } %> name="isEnabled_<%=i %>" <%if(navigation.IsEnabled){Response.Write("checked=\"checked\"");} %> id="isEnabled_<%=i %>"/>
                            <input type="hidden" id="displayOrder_<%=i %>" name="displayOrder_<%=i %>" value="<%=i %>" />
                            <input type="hidden" id="navID_<%=i %>" name="navID_<%=i %>" value="<%=navigation.OwnerNavigationID%>" />
                            <input type="hidden" id="DefaultNavID_<%=i %>" name="DefaultNavID_<%=i %>" value="<%=navigation.DefaultNavigationID %>" /></td>
                          <td class="spb-drag-td-width"><% if (navigation.NavigationType == NavigationTypes.HyperLink)
                                                       { %>
                            <%=SPBHtmlHelper.Instance().LinkButton("deleteLink_" + i, GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "deleteLinkForjs" },{"value",navigation.OwnerNavigationID} }, null)%>
                            <%} %></td>
                        </tr>
                      </table>
                    </div></td>
                </tr>
                <%
                  i++;
                  }%>
              </table>
              <div class="tn-form-row-button"> <%=SPBHtmlHelper.Instance().LinkButton("addUserNavigation",GetResourceString("Action_AddUserNavigation",applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().SubmitButton("updateButton", GetResourceString("Button_Update"), ButtonSizes.Default, null, null)%> </div>
              <input type="hidden" id="totalOptionCount" name="totalOptionCount" />
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <% int count = UserDomainConfiguration.Instance().MaxApplicationMenuCount;
     if (count < 1) count = 1;
     if (count > Model.Count) count = Model.Count;  %>
  <script type="text/javascript">
      function resetColor() {
          $("tr[name='sortableTr'] div.spb-drag-row")
            .filter(':lt(<%=count %>)')
            .removeClass("tn-bg-gray")
            .removeClass("tn-border-gray")
            .addClass("tn-bg-light")
            .addClass("tn-border-light")
            .end()
            .filter(':gt(<%=count-1 %>)')
            .removeClass("tn-bg-light")
            .removeClass("tn-border-light")
            .addClass("tn-bg-gray")
            .addClass("tn-border-gray");
          $("tr[name='sortableTr']").each(function(i) {
              $(this).find("input[id^='displayOrder']").attr("value", i);
          });
      }

      $(document).ready(function() {
          $("#sortable").sortable({
              placeholder: 'spb-drag-block',
              items: 'tr[name="sortableTr"]',
              stop: function() {
                  resetColor();
              }
          });
          resetColor();

          $("#menuForm").validate();
          $("#updateButton").click(function() {
              if ($("#menuForm").valid()) {
                  $("#totalOptionCount").attr("value", $("tr[name='sortableTr']").length);
                  $("#updateButton").hide();
                  $("#updateButton_ForHide").show();
              }
          });
          $("#addUserNavigation").click(function() {
              var value = eval($("tr[name='sortableTr']").length);
              $('<tr name="sortableTr" value="' + value + '">'
                + '<td><div class="spb-drag-row tn-bg-gray tn-border-gray">'
                  + '<table>'
                    + '<tr>'
                      + '<td class="spb-drag-td-width"><input type="text" maxlength="12" id="navigationText_' + value + '" name="navigationText_' + value + '" class="tn-textbox tn-input-short tn-border-gray {required:true,maxBlength:6}"></td>'
                      + '<td><input type="text" id="navigationLink_' + value + '" name="navigationLink_' + value + '" class="tn-textbox tn-input-medium tn-border-gray {url:true}"></td>'
                      + '<td class="spb-drag-td-width"><input type="checkbox" value="true" class="tn-checkbox" name="navigationTarget_' + value + '" id="navigationTarget_' + value + '" checked="checked"></td>'
                      + '<td class="spb-drag-td-width"><%=GetResourceString("Label_NavigationExternalLink", applicationID)%></td><td class="spb-drag-td-width"> </td>'
                      + '<td class="spb-drag-td-width"><input type="checkbox" value="true" class="tn-checkbox" name="isEnabled_' + value + '" id="isEnabled_' + value + '" checked="checked"><input type="hidden" id="displayOrder_' + value + '" name="displayOrder_' + value + '" value="' + value + '" /></td>'
                      + '<td class="spb-drag-td-width"><span class="tn-button tn-button-default"><span class="tn-first-child"><a id="deleteLink_' + value + '" href="javascript:;" class="tn-button-text" value="0"><%=GetResourceString("Action_Delete") %></a></span></span></td>'
                      + '</tr>'
                      + '</table>'
                  + '</div></td>'
                + '</tr>'
                      ).insertAfter("tr[name='sortableTr']:last");
          });
          $("a[id^='deleteLink_']").live('click', function() {
              var ownerNavID = eval($(this).attr("value"));
              if (ownerNavID > 0)
                  $.get('<%=SPBUrlHelper.Action("DeleteUserNavigation","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>', { ownerNavigationID: ownerNavID });
              var currentIndex = eval($(this).parents("tr[name=\"sortableTr\"]").attr("value"));
              $("#sortable").find("tr[name=\"sortableTr\"]").filter(function() {
                  return eval($(this).attr("value")) > currentIndex;
              })
                    .each(function() {
                        var oldValue = $(this).attr("value");
                        var value = eval(oldValue - 1);
                        $(this).attr("value", value);
                        $(this).find("#navigationText_" + oldValue).attr("name", "navigationText_" + value).attr("id", "navigationText_" + value);
                        $(this).find("#deleteLink_" + oldValue).attr("name", "deleteLink_" + value).attr("id", "deleteLink_" + value);
                        $(this).find("#displayOrder_" + oldValue).attr("name", "displayOrder_" + value).attr("id", "displayOrder_" + value).attr("value", value);
                        $(this).find("#navigationLink_" + oldValue).attr("name", "navigationLink_" + value).attr("id", "navigationLink_" + value);
                        $(this).find("#navigationTarget_" + oldValue).attr("name", "navigationTarget_" + value).attr("id", "navigationTarget_" + value);
                        $(this).find("#isEnabled_" + oldValue).attr("name", "isEnabled_" + value).attr("id", "isEnabled_" + value);
                        $(this).find("#navID_" + oldValue).attr("name", "navID_" + value).attr("id", "navID_" + value);
                        $(this).find("#DefaultNavID_" + oldValue).attr("name", "DefaultNavID_" + value).attr("id", "DefaultNavID_" + value);
                    });
              $(this).parents("tr[name=\"sortableTr\"]").remove();
          });
      });
</script>
</asp:content>
