﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <% ViewData["PersonProfileMenu"] = PersonProfileMenu.PersonUserTags;  %>
  <% Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
  <spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
        SetExpireDays="30" />
  <spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js" SetExpireDays="30" />
  <spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
        SetExpireDays="30" />
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<%string userTagItemKey = UserTagItemKeys.Instance().Person();
  List<string> selectedUserTags = ViewData.Get<List<string>>("SelectedUserTags");
  ICollection<UserTag> myTags = UserTagManager.Instance(userTagItemKey).GetUserTags(CurrentUser.UserID, true);

  string getTagsJosnUrl = SPBUrlHelper.Action("GetSuggestTagsJosn", "Channel", new RouteValueDictionary { { "userTagItemKey", userTagItemKey } });

  string selectedUserTagValue = "{}";
  string myTagsValue = "{}";
  System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
  if (selectedUserTags != null && selectedUserTags.Count > 0)
  {
      selectedUserTagValue = serializer.Serialize(selectedUserTags.Select(n => new { value = n }));
  }
  if (myTags != null && myTags.Count > 0)
  {
      myTagsValue = serializer.Serialize(myTags.Select(n => new { value = n.TagName }));
  }
  int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1);%>
<div class="tn-widget">
    <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
        <div class="tn-helper-flowfix">
            添加你自己感兴趣的标签，找到与你有共同爱好的人。</div>
    </div>
</div>
<div class="spb-set-tags tn-border-gray tn-helper-clearfix">
    <div class="spb-set-my-tags tn-border-gray tn-border-right">
        <div class="tn-text-heading">
            <strong>我的标签</strong></div>
        <div id="MTagsDiv">
            <% Html.RenderAction("Control_ListMyUserSiteTags", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }); %>
        </div>
        <div class="tn-expand-control">
            <div class="tn-form tn-form-single">
                <form id="CreateUserTagForm" action="<%=SPBUrlHelper.Action("CreateUserTag", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>"
                method="post">
                <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userTags"
                    name="userTags" />
                <span class="tn-button tn-button-primary">
                    <span class="tn-first-child">
                        <button type="submit" href="javascript:;" class="tn-button-text">添加</button>
                    </span>
                </span>
                </form>
            </div>
        </div>
    </div>
    <div>
        <% Html.RenderAction("Control_UserSiteTags", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", Request.QueryString.GetInt("pageIndex", 1) } }); %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $.ajaxSetup({ cache: false });    
        $("#userTags").autoSuggest("<%=getTagsJosnUrl %>", 
        {
        asHtmlID:"userTags",
        minChars: 1,
        keyDelay: 600,
        selectionLimit:5,
        preFill: <%=selectedUserTagValue %>,
        enableManualAdd: true
        });
        
//        $("#CreateUserTagForm a").click(function()
//        {
//            $('#CreateUserTagForm').ajaxSubmit({ target: '#MTagsDiv', url: '<%=SPBUrlHelper.Action("CreateUserTag", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>' });
//            $('#userTags').val('');
//        });
        
        $('#CreateUserTagForm').ajaxForm({ target: '#MTagsDiv',success:function(){
                $('#as-selections-userTags li.as-selection-item').remove();
                $('#userTags').val('');        
            }
        });        
        
    });
   
</script>
</asp:content>
