﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<string, Dictionary<int, NoticeItem>>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Notice;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
         <div class="tn-box-content tn-widget-content tn-corner-all">
           <ul class="tn-side-menu">
             <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("NoticeSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_NoticeSettings", applicationID)%></a></li>
             <% if (!ViewData.GetBool("isCompanyUser", false))
                { %>
             <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ActivitySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ActivitySettings", applicationID)%></a></li>
             <%} %>
           </ul>
         </div>
       </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
       <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-notice-settings">
         <div class="tn-box-content tn-widget-content tn-corner-all">
         <form action="<%=SPBUrlHelper.Action("UpdateNoticeSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                        method="post">
             <% if (TempData["StatusMessageType"] != null)
                {
                    StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                    if (messageType == StatusMessageType.Success)
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                    else
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                    TempData["StatusMessageType"] = null;
                }%>
             <%if (!ViewData.GetBool("isEmailVerified", false))
               {
                   string privateEmail = ViewData.GetString("privateEmail", string.Empty);
                   string emailAddress = EmailAddressConfiguration.GetEmailAddress(privateEmail);%>
              <div class="tn-widget">
               <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                 <div class="tn-helper-flowfix"><%=string.Format(GetResourceString("Description_Pattern_EmailIsNotVerified", applicationID), privateEmail)%> 
                 <% if (!string.IsNullOrEmpty(emailAddress))
                    { %>

                     <a href="<%=emailAddress %>" target="_blank" title="<%=GetResourceString("Description_ActivatyNowTitle",applicationID)%>"><%=GetResourceString("Action_ActivatyNow",applicationID)%></a>
                 <%} %>
                     <br /><a href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.AccountInfo } }) %>" title="<%=GetResourceString("Description_EditMyRegisterEmail",applicationID)%>"><%=GetResourceString("Action_EditUserProfile",applicationID)%></a> &nbsp;&nbsp; <a href="<%=SiteUrls.Instance().ResendVerificationCode(userDomainName) %>"><%=GetResourceString("Action_ResendVerifyCode",applicationID)%></a>
                 </div>
               </div>
             </div>
             <div class="tn-blank10"></div>
           <%} %>
           <%  Dictionary<string, Dictionary<int, NoticeItem>> userNoticeSettings = new Dictionary<string, Dictionary<int, NoticeItem>>();
               if (ViewData.Model != null)
                   userNoticeSettings = ViewData.Model;
               Dictionary<string, NoticeItem> NoticeItems = ViewData.Get<Dictionary<string, NoticeItem>>("Items", new Dictionary<string, NoticeItem>());

               foreach (var code in NoticeProcessorFactory.Instance().NoticeProcessorsNames.Keys)
               {
                   string name = NoticeProcessorFactory.Instance().GetMultilingualNoticeProcessorName(code, CurrentUserLanguage);%>
           <div class="tn-collapsible tn-collapsible-opened">
             <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
               <h4 class="tn-helper-reset"><a href="JavaScript:;"><%=string.Format(GetResourceString("Title_Pattern_SelectNeedSetItems", applicationID), name)%></a></h4>
               <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span>
             </div>
             <div class="tn-collapsible-content">
                <p class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_SelectNeedSetItems", applicationID), name)%></p>
                <p class="tn-check-all">
                 <input type="checkbox" id="topCheckBox_<%=code %>" name="" value="<%=code %>" class="tn-checkbox">
                 <strong><%=GetResourceString("Label_SelectAllOrNo") %></strong>
                </p>
                <ul class="tn-helper-reset tn-helper-clearfix tn-list-quarter spb-set-list">
                <% foreach (var item in NoticeItems)
                   {%>
                 <li>
                   <input type="checkbox" name="<%=code + "_" + item.Value.ItemKey %>" value="<%=item.Value.ItemID %>" id="<%=code + "_" + item.Value.ItemKey %>" class="tn-checkbox" <%if(userNoticeSettings[code].Keys.Contains(item.Value.ItemID)) Response.Write("checked=\"checked\""); %>>
                   <%=item.Value.GetMultilingualItemName(CurrentUserLanguage) %></li>
               <%} %>
               </ul>
             </div>
           </div>
         <%} %>
         <div class="tn-blank10"></div>
          <div class="tn-form">
             <div class="tn-form-row tn-form-row-button tn-helper-align-center">
              <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdateNoticeSettings", applicationID),ButtonSizes.Default,null,null)%>
              <% if (Request.UrlReferrer != null)
                 { %>
              <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "window.location.href='" + Request.UrlReferrer.AbsoluteUri + "'" } }, null)%>
              <%} %> 
             </div>
          </div>
          </form>
        </div>
      </div>

<script type="text/javascript">
    $(document).ready(function() {
        $("input[id^='topCheckBox']").click(function() {
            var noticeManagerName = $(this).attr("value");
            if (this.checked)
                $("input[name^='" + noticeManagerName + "_']").attr('checked', 'checked');
            else
                $("input[name^='" + noticeManagerName + "_']").removeAttr('checked');
        });
        $(".tn-collapsible").collapsibleBox();
    });
</script>

</asp:content>
