﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PersonUser>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>

   <% ViewData["PersonProfileMenu"] = PersonProfileMenu.BasicInfo;  %>
  <% Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>


</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent"> 
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% PersonUser user = ViewData.Model; %>
  <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>   

       <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-basic-info">
         <div class="tn-box-content tn-widget-content tn-corner-all">
            <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
               }
               TempData["StatusMessageType"] = null;
               SiteSettings setting = null;
               if (ViewData["SiteSetting"] != null)
                   setting = ViewData["SiteSetting"] as SiteSettings;
               %>          
           <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
             <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.BasicInfo %>" />
             <div class="tn-form tn-label-right">
                <div class="tn-widget">
                  <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
                    <div class="tn-helper-flowfix">
                    <%=string.Format(GetResourceString("Description_Pattern_SetUserKindsOfPirvcyStatuses", applicationID), SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { {"class","tn-icon tn-icon-lock tn-icon-inline"}}), string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("PrivacySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageStopedUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>")%>
                    </div>
                  </div>
                </div>
                <div class="tn-blank10"></div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %> </label>
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="commonName" name="commonName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.CommonName) %>" maxlength="30"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
                </div>
                <% if (SiteSettingsManager.GetSiteSettings().EnableNickName)
                   { %>
                <div class="tn-form-row">
                 <label class="tn-form-label"><%=GetResourceString("Label_ShowUserNickName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                 <div class="tn-input-multiple">
                  <input type="text" class="tn-textbox tn-input-medium tn-border-gray"  id="nickName" name="nickName"  value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.NickName) %>" maxlength="30"/>
                 </div>            
                </div>
                <%} %>
                  <div class="tn-form-row">
                 <label class="tn-form-label"><%=GetResourceString("Lable_DisplayName",applicationID) %><%=GetResourceString("Common_Colon") %></label>
                 <%=user.DisplayName %>       <em class="tn-text-note">  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;   <%=GetResourceString("Message_Tips")%><%=GetResourceString("Common_Colon")%>
                    <%
                        switch (setting.DisplayNameType)
                        {
                            case DisplayNameTypes.NickNameFirst: Response.Write(GetResourceString("Message_NickNameFirst", applicationID)); break;
                            case DisplayNameTypes.CommonNameFirst: Response.Write(GetResourceString("Message_CommonNameFirst", applicationID)); break;
                            case DisplayNameTypes.NickName: Response.Write(GetResourceString("Message_NickName", applicationID)); break;
                            case DisplayNameTypes.CommonName: Response.Write(GetResourceString("Message_CommonName", applicationID)); break;
                        }       
                        
                        %> </em>
                </div>
                <div class="tn-form-row">
                <% int gender = (int)user.Gender; %>
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserGender",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <div class="tn-input-multiple">
                    <input type="radio" class="tn-radiobutton"id="maleItem" name="gender" <%if(gender!=2) Response.Write("checked=\"checked\"");  %>
                                value="1" />
                    <label for="maleItem"> <%=GetResourceString("Enum_Genders_Male")%></label>
                    <input type="radio" class="tn-radiobutton" id="femaleItem" name="gender" <%if(gender==2) Response.Write("checked=\"checked\"");  %>
                                value="2" />
                    <label for="femaleItem"> <%=GetResourceString("Enum_Genders_Female") %></label>
                  </div>
                  <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserBirthday", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <% DateTime? defaultdate = null;
                     if (user.Birthday > DateTime.MinValue)
                         defaultdate = user.Birthday;
                     Html.RenderAction<ChannelController>(n => n.Control_Datepicker("birthday", 1919, DateTime.Now.Year, defaultdate, false, "tn-textbox tn-input-medium tn-border-gray")); %>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("nowAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.NowAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                  <span class="tn-text-note"><%=GetResourceString("Description_UserAreaCode",applicationID)%></span>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_UserHomeAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("homeAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.HomeAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                  <span class="tn-text-note"><%=GetResourceString("Description_UserHomeAreaCode",applicationID)%></span>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserDegrees",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <% Dictionary<int, CodeItem> Degrees = CodeItems.GetCodeItems(CodeSetCodes.Instance().Degree()); %>
                  <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("degree", Degrees.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Degree)%> 
                  <span class="tn-text-note"><%=GetResourceString("Description_PersonUserDegrees",applicationID)%></span>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserSchool",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" maxlength="100" id="school" name="school" value="<%=user.School %>" />
                  <%=SPBHtmlHelper.Instance().Button("selectSchool","选择学校",ButtonSizes.Default,HighlightStyles.Secondary,null,null)%>
                   <div class="tn-text-note"><%=GetResourceString("Description_PersonUserSchool",applicationID)%></div>
                   <input type="hidden" id="schoolID" name="schoolID" value="<%=user.SchoolID %>" />
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserSelfAppraisal",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <textarea class="tn-textarea tn-input-long tn-border-gray" rows="2" cols="100" name="selfAppraisal" id="selfAppraisal" ><%=Formatter.FormatMultiLinePlainTextForEdit(user.SelfAppraisal,true)%></textarea>
                  <div class="tn-text-note"> <%=GetResourceString("Description_PersonUserSelfAppraisal",applicationID)%></div>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserInterest",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                  <textarea class="tn-textarea tn-input-long tn-border-gray" rows="2" cols="100" name="interest" id="interest" ><%= Formatter.FormatMultiLinePlainTextForEdit( user.Interest ,true)%></textarea>
                  <div class="tn-text-note"><%=GetResourceString("Description_PersonUserInterest",applicationID)%></div>
                </div>
                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserExpertise",applicationID) %><%=GetResourceString("Common_Colon") %></label>
                  <textarea class="tn-textarea tn-input-long tn-border-gray" rows="2" cols="100" name="expertise" id="expertise" ><%=Formatter.FormatMultiLinePlainTextForEdit(user.Expertise,true) %></textarea>
                  <div class="tn-text-note"><%=GetResourceString("Description_PersonUserExpertise",applicationID)%></div>
                </div>

                <div class="tn-form-row">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonalWebAdress")%><%=GetResourceString("Common_Colon") %></label>
                  <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="personalHomepage" name="personalHomepage" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.PersonalHomepage) %>" maxlength="100" />
                </div>
                <div class="tn-form-row tn-form-row-button">
                  <label class="tn-form-label"> </label>
                  <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_UpdateUserBaseInfo", applicationID), ButtonSizes.Default, null, null)%>
              </div>
              </div>
          </form>
        </div>
      </div>
   
  <script type="text/javascript">
      $(document).ready(function () {
          $("#EditProfileForm").validate({
              rules: {
                  commonName: { maxBlength: 30 },
                  nickName: { maxBlength: 30 },
                  birthday: { dateISO: true },
                  selfAppraisal: { maxBlength: 200 },
                  interest: { maxBlength: 200 },
                  expertise: { maxBlength: 200 },
                  personalHomepage: { url: true }
              },
              messages: {
                  commonName: { maxBlength: '<%=GetResourceString("Validate_CommonNameMaxlength", applicationID) %>' },
                  nickName: { maxBlength: '<%=GetResourceString("Validate_NickNameMaxLength", applicationID)%>' },
                  birthday: { dateISO: '<%=GetResourceString("Validate_BirthdayDateISO", applicationID)%>' },
                  selfAppraisal: { maxBlength: "最多输入200个字！" },
                  interest: { maxBlength: "最多输入200个字！" },
                  expertise: { maxBlength: "最多输入200个字！" },
                  personalHomepage: { url: "请输入正确的URL地址" }
              }
          });
          $('#selectSchool').click(function (e) {
              e.preventDefault();
              $.nyroModalManual({
                  modal: false,
                  width: 700,
                  height: 400,
                  url: '<%=SPBUrlHelper.Action("Control_SchoolSelector","Channel",new RouteValueDictionary{{"textBoxID","school"},{"hiddenID","schoolID"}}) %>'
              });
              return false;
          });
          $("#postButton").click(function () {
              if (!$("#EditProfileForm").valid()) {
                  return false;
              }
          });
      });
  </script>


</asp:content>
