﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PersonUser>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
   <% ViewData["PersonProfileMenu"] = PersonProfileMenu.BusinessContact;  %>
  <% Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% PersonUser user = ViewData.Model; %>
  <% PersonProfileType type = (PersonProfileType)Enum.Parse(typeof(PersonProfileType), Request.QueryString.GetString("type", PersonProfileType.AccountInfo.ToString())); %>
  <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>   

   <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-business-contact">
     <div class="tn-box-content tn-widget-content tn-corner-all">
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
           }
           TempData["StatusMessageType"] = null;%>
       <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
         <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.BusinessContact%>" />
         <div class="tn-form tn-label-right">
            <div class="tn-widget">
              <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
                <div class="tn-helper-flowfix">
                <%=string.Format(GetResourceString("Description_Pattern_SetUserKindsOfPirvcyStatuses", applicationID), SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } }), string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("PrivacySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageStopedUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>")%>
                </div>
              </div>
            </div>
            <div class="tn-blank10"></div>
            <div class="tn-form-row">
              <label class="tn-form-label"><%=GetResourceString("Label_PersonUserJob",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="title" name="title" value="<%=user.Title %>" maxlength="50"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } }) %>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserJobLevel",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <% Dictionary<int, CodeItem> titleLevels = CodeItems.GetCodeItems(CodeSetCodes.Instance().TitleLevel()); %>
             <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("titleLevel", titleLevels.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.TitleLevel, -1, "--" + GetResourceString("Common_PleaseChoose") + "--")%>
             &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserJobSort",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <%=SPBHtmlHelper.Instance().ShowJobSortsDropDownList("jobSort", new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.JobSort)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserCompanyName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyName" name="companyName" value="<%=user.CompanyName %>"
                        maxlength="100" />&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserTrade",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Trades = CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade()); %>    
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("companyTrade", Trades.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.CompanyTrade)%>        
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserLinkTel", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="workTel" name="workTel" value="<%=user.WorkTel %>" maxlength="50"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserFax",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyFax" name="companyFax" value="<%= user.CompanyFax %>"
                        maxlength="50"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("companyAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.CompanyAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>           
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserCompanyAddress",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyAddress" name="companyAddress" value="<%=user.CompanyAddress %>"
                        maxlength="100"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserPostcodel",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <div class="tn-input-multiple">
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyPostcode" name="companyPostcode" value="<%=user.CompanyPostcode %>"
                        maxlength="10"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
             </div>            
            </div>
            <div class="tn-form-row">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserCompanyWebAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <div class="tn-input-multiple">
              <input type="text" class="tn-textbox tn-input-long tn-border-gray"  id="companyWebAddress" name="companyWebAddress" value="<%=user.CompanyWebAddress %>"
                        maxlength="100"/>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%>
             </div>            
            </div>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"></label>
              <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdatePersonUserBusinessInfo", applicationID), ButtonSizes.Default, null, null)%>
          </div>
         </div>
      </form>
    </div>
  </div>

   
  <script type="text/javascript">
      $(document).ready(function () {
          $("#EditProfileForm").validate({
              rules: {
                  companyWebAddress: { url: true }

              },
              messages: {
                  companyWebAddress: { url: "请输入正确的URL地址" }

              }

          });
      });
  </script>


</asp:content>
