﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<string, PrivacyItemSettings>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Privacy;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int applicationID = ApplicationIDs.Instance().User(); %>

   <div class="tn-box tn-widget tn-widget-content tn-corner-all">
     <div class="tn-box-content tn-widget-content tn-corner-all">
       <ul class="tn-side-menu">
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("PrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_BasicPrivacySettings", applicationID)%></a></li>
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageSpecialPrivacyUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ManageSpecialPrivacyUsers", applicationID)%></span></a></li>
         <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("DomainVisitPermission","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_UserDomainPrivacy",applicationID)%></span></a></li>
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageStopedUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ManageStopedUsers", applicationID)%></a></li>
       </ul>
     </div>
   </div>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">

<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js" SetExpireDays="30" />
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int applicationID = ApplicationIDs.Instance().User(); %>


   <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-visit-set">
    <div class="tn-box-content tn-widget-content tn-corner-all">
     <% 
         if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             if (messageType == StatusMessageType.Success)
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
             else
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
         }
         TempData["StatusMessageType"]=null;
         PrivacyItemSettings privacyItemSettings = ViewData["PrivacyItemSettings"] as PrivacyItemSettings;%>
        <form class="tn-helper-reset"  id="Privacyfrom" action="<%=SPBUrlHelper.Action("UpdatePrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" method="post">
          <div class="tn-form tn-label-right">
            <div class="tn-form-row">
              <label class="tn-form-label"></label>
              <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton"id="AllowAllUser" name="<%=privacyItemSettings.ItemKey %>" <%if (privacyItemSettings.PrivacyDegree == PrivacyDegree.Public) Response.Write("checked=\"checked\"");%> value="<%=(int)PrivacyDegree.Public %>" />
                <label for="AllowAllUser"> 对所有人开放</label>
              </div>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"></label>
              <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton" id="AllowFriends" name="<%=privacyItemSettings.ItemKey %>" <%if (privacyItemSettings.PrivacyDegree == PrivacyDegree.Friend) Response.Write("checked=\"checked\"");%> value="<%=(int)PrivacyDegree.Friend %>" />
                <label for="AllowFriends"> 对好友开放</label>
              </div>
            </div>
            <%--            <div class="tn-form-row">
                          <label class="tn-form-label"></label>
                          <div class="tn-input-multiple">
                            <input type="radio" class="tn-radiobutton" id="AllowUsers" name="<%=privacyItemSettings.ItemKey %>" <%if (privacyItemSettings.PrivacyDegree == PrivacyDegree.Friend) Response.Write("checked=\"checked\"");%> value="<%=(int)PrivacyDegree.Friend %>" />
                            <label for="AllowUsers"> 对指定好友开放</label>
                          </div>
                        </div>
                        <div class="tn-form-row" id="selectedUserIDsInput" name="selectedUserIDsInput">
                          <label class="tn-form-label"></label>
                          <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="selectedUserIDsInput" name="selectedUserIDsInput" />
                           <% string selectedUsersValue = "{}";
                              string getUsersUrl = SPBUrlHelper.Action("SearchUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }); %>
                          <script type="text/javascript">
                            $(document).ready(function() {
                            $("input[name=<%=privacyItemSettings.ItemKey %>]").click(function(){
                                 if($("#AllowUsers").attr("checked"))
                                 {
                                      $("#SelectUsers").removeAttr("style");
                                      $("#Privacyfrom").attr("action",'<%=SPBUrlHelper.Action("UpdateSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { {"userDomainName" ,userDomainName} })%>');
                                 }
                                 else
                                 {
                                      $('#SelectUsers').attr("style","display:none");
                                      $("#Privacyfrom").attr("action",'<%=SPBUrlHelper.Action("UpdatePrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>');
                                  }    
                                });
                                if($("#AllowUsers").attr("checked"))
                                {
                                     $("#SelectUsers").removeAttr("style");
                                     $("#Privacyfrom").attr("action",'<%=SPBUrlHelper.Action("UpdateSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { {"userDomainName" ,userDomainName} })%>');
                                }
                                $("#selectedUserIDsInput").autoSuggest("<%=getUsersUrl %>", 
                                {
                                      asHtmlID: "selectedUserIDs",
                                      selectionLimit:5,
                                      preFill: <%=selectedUsersValue %>,
                                      allSelectData:{d:1}            
                                });
                            });
                          </script>
                        </div>
            --%>            
            <div class="tn-form-row">
              <label class="tn-form-label"></label>
              <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton" id="PreventAllUser" name="<%=privacyItemSettings.ItemKey %>" <%if (privacyItemSettings.PrivacyDegree == PrivacyDegree.Private) Response.Write("checked=\"checked\"");%> value="<%=(int)PrivacyDegree.Private %>"/>
                <label for="PreventAllUser"> 拒绝任何人访问</label>
              </div>
            </div>
            <input type="hidden" value="<%=Request.RawUrl %>" id="reUrl" name="reUrl" />
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"> </label>
              <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Submit"),ButtonSizes.Default,null,null)%>
              <% if (Request.UrlReferrer != null)
                 {%>
              <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick","window.location.href='"+Request.UrlReferrer.AbsoluteUri+"'"} }, null)%>
              <%} %>
            </div>
          </div>
        </form>
    </div>
  </div>

</asp:content>
