﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PersonUser>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
   <% ViewData["PersonProfileMenu"] = PersonProfileMenu.PersonContact;  %>
  <% Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% PersonUser user = ViewData.Model; %>
  <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-person-contact">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
               }
               TempData["StatusMessageType"]=null;%>
      <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
        <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.PersonContact%>" />
        <div class="tn-form tn-label-right">
          <div class="tn-widget">
            <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
              <div class="tn-helper-flowfix"> <%=string.Format(GetResourceString("Description_Pattern_SetUserKindsOfPirvcyStatuses", applicationID), SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } }), string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("PrivacySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageStopedUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>")%> </div>
            </div>
          </div>
          <div class="tn-blank10"></div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserPublicEmail",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray"  id="publicEmail" name="publicEmail" value="<%=user.PublicEmail %>" maxlength="100"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> <span class="tn-text-note"><%=GetResourceString("Description_PersonUserPublicEmail",applicationID)%></span> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserMobile",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="mobile" name="mobile" value="<%=user.Mobile %>" maxlength="15"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserTel",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="homeTel" name="homeTel" value="<%=user.HomeTel %>" maxlength="50"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserFax",applicationID) %><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="homeFax" name="homeFax" value="<%=user.HomeFax %>" maxlength="50"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserAddress",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="personAddress" name="personAddress" value="<%=user.PersonAddress %>"
                            maxlength="100" />
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserPostcodel",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="personPostcode" name="personPostcode" value="<%=user.PersonPostcode %>"
                            maxlength="10"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserMSN",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="msnIM" name="msnIM" value="<%=user.MsnIM %>" maxlength="100"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserQQ",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="qqIM" name="qqIM" value="<%=user.QQIM %>" maxlength="100"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserSkype",applicationID) %><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="skypeIM" name="skypeIM" value="<%=user.SkypeIM %>" maxlength="100"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserYahooIM",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="yahooIM" name="yahooIM" value="<%=user.YahooIM %>" maxlength="100"/>
            &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label>
            <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_UpdatePersonUserLinkInfo", applicationID), ButtonSizes.Default, null, null)%> </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function() {

          $("#EditProfileForm").validate({
              rules: {

                  publicEmail: { email: true },
                  homeFax: { digits: true, minlength: 4, maxlength: 15 },
                  homeTel: { minlength: 4, maxlength: 20 },
                  mobile: { digits: true, minlength: 11, maxlength: 20}
              },
              messages: {
                  publicEmail: { email: '<%=GetResourceString("Validate_PublicEmailStyle", applicationID)%>' },
                  homeFax: { digits: '<%=GetResourceString("Validate_DigitsRequired", applicationID)%>', minlength: '<%=GetResourceString("Validate_HomeFaxMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_HomeFaxMaxlength", applicationID)%>' },
                  homeTel: { digits: '<%=GetResourceString("Validate_DigitsRequired", applicationID)%>', minlength: '<%=GetResourceString("Validate_LinkTelMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_LinkTelMaxlength", applicationID)%>' },
                  mobile: { digits: '<%=GetResourceString("Validate_DigitsRequired", applicationID)%>', minlength: '<%=GetResourceString("Validate_MobileMinlength", applicationID)%>', maxlength: '<%=GetResourceString("Validate_MobileMaxlength", applicationID)%>'}
              }
          });
          $("#postButton").click(function() {
              if (!$("#EditProfileForm").valid()) {
                  return false;
              }
          });
      });
  </script>
</asp:content>
