﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PersonUser>" %>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>

<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
  <% ViewData["PersonProfileMenu"] = PersonProfileMenu.PrivacyInfo;  %>
  <% Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% PersonUser user = ViewData.Model; %>
  <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-edit-privacy-info">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
           }
           TempData["StatusMessageType"]=null;%>
      <div class="tn-widget">
        <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
          <div class="tn-helper-flowfix"> <%=string.Format(GetResourceString("Description_Pattern_SetUserKindsOfPirvcyStatuses", applicationID), SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } }), string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("PrivacySettings", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageSpecialPrivacyUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>", string.Format("<a href=\"{0}\">", SPBUrlHelper.Action("ManageStopedUsers", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } })), "</a>")%> </div>
        </div>
      </div>
      <div class="tn-blank10"></div>
      <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"prevAccountStatus",user.AccountStatus}}) %>">
        <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.PrivacyInfo%>" />
        <div class="tn-form tn-label-right">
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserStature",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="stature" name="stature" value="<%=user.Stature > 0 ? user.Stature.ToString() : string.Empty %>" maxlength="3"/>
            <%=GetResourceString("Label_Centimeter",applicationID)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserWeight",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="weight" name="weight" value="<%=user.Weight > 0 ? user.Weight.ToString() : string.Empty %>"
                            maxlength="3"/>
            <%=GetResourceString("Label_Kilogram", applicationID)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserShape",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Shapes = CodeItems.GetCodeItems(CodeSetCodes.Instance().Shape()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("shape", Shapes.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Shape)%> &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserBlood",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Bloods = CodeItems.GetCodeItems(CodeSetCodes.Instance().Blood()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("blood", Bloods.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Blood)%> &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserSmoke",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Smokes = CodeItems.GetCodeItems(CodeSetCodes.Instance().Smoke()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("smoke", Smokes.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Smoke)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserDrink",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Drinks = CodeItems.GetCodeItems(CodeSetCodes.Instance().Drink()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("drink", Drinks.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Drink)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserMarriage",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Marriages = CodeItems.GetCodeItems(CodeSetCodes.Instance().Marriage()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("marriage", Marriages.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Marriage)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserHealth",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Healths = CodeItems.GetCodeItems(CodeSetCodes.Instance().Health()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("health", Healths.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.Health)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_PersonUserSalary",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Salarys = CodeItems.GetCodeItems(CodeSetCodes.Instance().Salary()); %>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("nowSalary", Salarys.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.NowSalary)%><%=GetResourceString("Label_ChinaMoney",applicationID)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "", new RouteValueDictionary { { "class", "tn-icon tn-icon-lock tn-icon-inline" } })%> </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label>
            <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdatePersonUserPrivateInfo", applicationID), ButtonSizes.Default, null, null)%> </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function () {
          $("#EditProfileForm").validate({
              rules: {
                  stature: { digits: true },
                  weight:{digits: true }

              },
              messages: {
                  stature: { digits: "请输入数字" },
                  weight:{digits:"请输入数字"}
              }

          });
              
      });
  </script>
</asp:content>
