﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<string, PrivacyItemSettings>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Privacy;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>  

        <div class="tn-box tn-widget tn-widget-content tn-corner-all">           
           <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-side-menu">                   
              <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("PrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_BasicPrivacySettings", applicationID)%></span></a></li>
              <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageSpecialPrivacyUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ManageSpecialPrivacyUsers", applicationID)%></span></a></li>
              <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("DomainVisitPermission","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_UserDomainPrivacy",applicationID)%></span></a></li>              
              <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageStopedUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ManageStopedUsers", applicationID)%></span></a></li>
            </ul>
        </div>
        </div>
     
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>  

    
         <div class="tn-box tn-widget tn-widget-content tn-corner-all">
           <div class="tn-box-content tn-widget-content tn-corner-bottom">       
             <div class="tn-form tn-label-right">              
            <% 
                if (TempData["StatusMessageType"] != null)
                {
                    StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                    if (messageType == StatusMessageType.Success)
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                    else
                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                }
                TempData["StatusMessageType"]=null;
                Dictionary<string, PrivacyItemSettings> userPrivacyItemSettingss = ViewData.Model;
                List<PrivacyItem> userProfileItems = ViewData.Get<List<PrivacyItem>>("UserProfileItems", new List<PrivacyItem>());
                List<PrivacyItem> actionItems = ViewData.Get<List<PrivacyItem>>("ActionItems", new List<PrivacyItem>()); %>
                 <form action="<%=SPBUrlHelper.Action("UpdatePrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                   method="post">           
                  <div class="tn-collapsible tn-collapsible-opened">
                   <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
                        <h4 class="tn-helper-reset">
                            <a href="javascript:;;"><%=GetResourceString("Title_ArchivesPrivacySetting", applicationID)%></a>
                        </h4>
                   </div>
                   <div class="tn-blank10"></div>                  
                   <div class="tn-collapsible-content" style="display: block;">            
                        <div class="form PrivacySet">                  
                            <% foreach (var item in userProfileItems)
                               {                               
                                %>                        
                             <div class="tn-form-row">
                                    <label class="tn-form-label"><%=item.GetMultilingualItemName(CurrentUserLanguage) %><%=GetResourceString("Common_Colon") %></label>
                                    <div class="tn-input-multiple">
                                      <% PrivacyItemSettings settings = userPrivacyItemSettingss[item.ItemKey]; %>
                                      <%=SPBHtmlHelper.Instance().PrivacyTypeRadioButtonList(item.ItemKey, settings.PrivacyDegree, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%> <em class="tn-text-note"> <%=item.GetMultilingualDescription(CurrentUserLanguage) %> </em>
                                    </div>
                            </div>
                            <%} %>
                              <div class="tn-form-row tn-form-row-button">
                               <label class="tn-form-label"> </label>            
                               <%=SPBHtmlHelper.Instance().SubmitButton("submit", GetResourceString("Button_UpdateArchivesPrivacySettings",applicationID), ButtonSizes.Default, null, null)%>
                               <% if (Request.UrlReferrer != null)
                                  {%>                          
                               <%=SPBHtmlHelper.Instance().Button("cancel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default,new RouteValueDictionary { { "onclick", "window.location.href='" +Request.UrlReferrer.AbsoluteUri+"'"} }, null)%>
                               <%} %>
                        </div>    
                      </div>            
                  </div>                 
                 </div>                         
                  <div class="tn-collapsible tn-collapsible-opened">
                   <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
                        <h4 class="tn-helper-reset">
                            <a href="javascript:;;">接收信息设置</a>
                        </h4>
                   </div>
                   <div class="tn-blank10"></div>
                   <div class="tn-collapsible-content" style="display: block;">
                        <% foreach (var item in actionItems)
                           {
                                %>
                        <div class="tn-form-row">
                          <label class="tn-form-label"><%=item.GetMultilingualItemName(CurrentUserLanguage)%><%=GetResourceString("Common_Colon") %></label>
                          <div class="tn-input-multiple">
                            <% PrivacyItemSettings settings = userPrivacyItemSettingss[item.ItemKey]; %>
                            <%
                                if (item.ItemKey != PrivacyItemKeys.Instance().Action_ReceiveFriendInvitation())
                                    Response.Write(SPBHtmlHelper.Instance().PrivacyActionRadioButtonList(item.ItemKey, settings.PrivacyDegree, new RouteValueDictionary { { "Class", "tn-radiobutton" } }));
                                else
                                    Response.Write(SPBHtmlHelper.Instance().SpecialPrivacyActionRadioButtonList(item.ItemKey, settings.PrivacyDegree == PrivacyDegree.Public ? true : false, new RouteValueDictionary { { "Class", "tn-radiobutton" } }));%>
                            <em class="tn-text-note"> <%=item.GetMultilingualDescription(CurrentUserLanguage) %> </em>
                            </div>
                        </div>
                        <%} %>                        
                        <div class="tn-form-row tn-form-row-button">
                               <label class="tn-form-label"> </label>            
                               <%=SPBHtmlHelper.Instance().SubmitButton("submitButton", GetResourceString("Button_UpdateActiveSettings", applicationID), ButtonSizes.Default, null, null)%>
                               <% if (Request.UrlReferrer != null)
                                  {%>                          
                               <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "window.location.href='"+Request.UrlReferrer.AbsoluteUri+"'" } }, null)%>
                               <%} %>
                        </div>               
                   </div>                 
                 </div>                  
                </form>
              </div>  
           </div>          
         </div>
 
   <script type="text/javascript">
       $(document).ready(function() {
           $(".tn-collapsible").collapsibleBox();
       });     
   </script>
</asp:content>
