﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<Dictionary<string, SpecialPrivacyItemSettings>>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Privacy;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>

   <div class="tn-box tn-widget tn-widget-content tn-corner-all">
     <div class="tn-box-content tn-widget-content tn-corner-all">
       <ul class="tn-side-menu">
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("PrivacySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_BasicPrivacySettings", applicationID)%></a></li>
         <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageSpecialPrivacyUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span><%=GetResourceString("Title_ManageSpecialPrivacyUsers", applicationID)%></span></a></li>
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("DomainVisitPermission","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <span>空间访问权限</span></a></li>
         <li><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageStopedUsers","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"><%=GetResourceString("Title_ManageStopedUsers", applicationID)%></a></li>
       </ul>
     </div>
   </div>


</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>

  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <div class="tn-form tn-label-right">
    <% if (TempData["StatusMessageType"] != null)
       {
           StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
           TempData["StatusMessageType"] = null;
       }
       Dictionary<string, SpecialPrivacyItemSettings> dictionary = ViewData.Model;
       User toUser = ViewData.Get<User>("ToUser", null);
       List<PrivacyItem> userProfileItems = ViewData.Get<List<PrivacyItem>>("UserProfileItems", new List<PrivacyItem>());
       List<PrivacyItem> actionItems = ViewData.Get<List<PrivacyItem>>("ActionItems", new List<PrivacyItem>()); %>
      <form action="<%=SPBUrlHelper.Action("UpdatePrivacySpecialSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName},{"toUserID",toUser.UserID}}) %>"
              method="post">           
             <div class="tn-collapsible tn-collapsible-opened">
              <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                   <h4 class="tn-helper-reset">
                       <a href="javascript:;;">档案隐私设置</a>
                   </h4>
              </div>
              <div class="tn-blank10"></div>                  
              <div class="tn-collapsible-content" style="display: block;">            
                   <div class="form PrivacySet">                  
                      <% foreach (var item in userProfileItems)
                         {%>                       
                        <div class="tn-form-row">
                           <label class="tn-form-label"><%=item.GetMultilingualItemName(CurrentUserLanguage) %><%=GetResourceString("Common_Colon") %></label>
                           <div class="tn-input-multiple">
                             <% SpecialPrivacyItemSettings settings = dictionary[item.ItemKey]; %>
                             <%=SPBHtmlHelper.Instance().SpecialPrivacyActionRadioButtonList(item.ItemKey, settings.IsAllowed, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%>
                             <% if (item.ItemKey == PrivacyItemKeys.Instance().UserProfile_PersonalContactInfo())
                                { %>
                               <em class="tn-text-note"><%=GetResourceString("Description_UserProfilePersonalContactInfo", applicationID)%></em>
                               <%}%>
                           </div>
                       </div>
                       <%} %>
                         <div class="tn-form-row tn-form-row-button">
                          <label class="tn-form-label"> </label>            
                          <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdateArchivesPrivacySettings", applicationID), ButtonSizes.Default, null, null)%>
                          <% if (Request.UrlReferrer != null)
                             {%>                          
                          <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default,new RouteValueDictionary { { "onclick", "window.location.href='"+Request.UrlReferrer.AbsoluteUri+"'" } }, null)%>
                          <%} %>
                       </div>    
                 </div>            
             </div>                 
            </div>                         
             <div class="tn-collapsible tn-collapsible-opened">
              <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                   <h4 class="tn-helper-reset">
                       <a href="javascript:;;">行为设置</a>
                   </h4>
              </div>
              <div class="tn-blank10"></div>                   
              <div class="tn-collapsible-content" style="display: block;">
                <div class="form PrivacySet"> 
               <% foreach (var item in actionItems)
                  { %>
                   <div class="tn-form-row">
                     <label class="tn-form-label"><%=item.GetMultilingualItemName(CurrentUserLanguage)%><%=GetResourceString("Common_Colon") %></label>
                     <div class="tn-input-multiple">
                   <% SpecialPrivacyItemSettings settings = dictionary[item.ItemKey]; %>
                   <%=SPBHtmlHelper.Instance().SpecialPrivacyActionRadioButtonList(item.ItemKey, settings.IsAllowed, new RouteValueDictionary { { "Class", "tn-radiobutton" } })%></div>
                       <em class="tn-text-note"> <%=item.GetMultilingualDescription(CurrentUserLanguage) %> </em>
                       </div>

                   <%} %>                        
                   <div class="tn-form-row tn-form-row-button">
                     <label class="tn-form-label"> </label>            
                     <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdateActiveSettings", applicationID), ButtonSizes.Default, null, null)%>
                     <% if (Request.UrlReferrer != null)
                        {%>                          
                     <%=SPBHtmlHelper.Instance().Button("", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "window.location.href='" + Request.UrlReferrer.AbsoluteUri + "'" } }, null)%>
                     <%} %>
                   </div>
                 </div> 
               </div>           
              </div> 
          </form>
         </div>
       </div>                  
    </div>


  <script type="text/javascript">
      $(document).ready(function() {
          $(".tn-collapsible").collapsibleBox();
      });
  </script>
</asp:content>
