﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<User>" %>

<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["UserDomainSettingsMenuType"] = UserDomainSettingsMenuType.Account;  %>
  <% Html.RenderPartial("Controls/Settings/SettingMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageMenusContent" runat="server" contentplaceholderid="manageMenusContent">

  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();%>
   <% ViewData["PersonProfileMenu"] = PersonProfileMenu.UploadAvatar;
      ViewData["CompanyProfileMenu"] = CompanyProfileMenu.UploadAvatar;
      Html.RenderPartial("Controls/Settings/ProfileMenu.ascx", ViewData); %>

</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User(); %>
  <% if (TempData["StatusMessageData"] != null)
     {

         StatusMessageData mesageData = TempData["StatusMessageData"] as StatusMessageData;
         if (mesageData.MessageType == StatusMessageType.Success)
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(mesageData, 3000, false));
         else
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(mesageData));
         TempData["StatusMessageData"] = null;
     }%>
       <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-avatar">
         <div class="tn-box-content tn-widget-content tn-corner-all">
             <div class="tn-helper-clearfix">
                 <div class="spb-avatar-box">
                     <%= SPBHtmlHelper.Instance().ShowUserAvatar(Html.GetParameterFromRouteDateOrQueryString("userDomainName"),false, HyperLinkTarget._blank, AvatarSizeTypes.Normal,false,null)  %>
                 </div>
                 <div class="spb-upload-main">
                     <div class="spb-upload-files">
                         <div class="spb-upload-tips tn-border-gray tn-border-bottom tn-text-note">
                             <%=String.Format(GetResourceString("Description_Pattern_UploadAvatar", applicationID),SiteSettingsManager.GetSiteSettings().SmallAvatarWidth + "x" + SiteSettingsManager.GetSiteSettings().SmallAvatarWidth)%></div>
                         <div class="spb-upload-wrapper tn-border-gray tn-border-rbl">
                             <div class="spb-upload-fieldset tn-border-gray tn-border-top" id="fsUploadProgress">
                                 <span class="spb-upload-legend">上传新头像</span></div>
                             <div style="display: none;" id="divStatus">
                             </div>
                             <div class="spb-upload-actions tn-border-gray tn-border-top">
                                 <% string handdlerUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Services/UserUploadAvatar.ashx"));
                                    string flashUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
                                    string uploadFileTypes = "*.gif;*.jpg;*.jpeg;*.png;*.bmp;";
                                    int maxFileSize = 5 * 1024;
                                     %>
                                 <% Html.RenderAction<ChannelController>(n => n.Control_UploadAvatarAttachment(userDomainName, handdlerUrl, flashUrl, Model.UserID, uploadFileTypes, maxFileSize.ToString(), true, SPBUrlHelper.Action("CropAvatar", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }))); %>  
                                 
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
           </div>
        </div>
  
</asp:content>
