﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<UserShareThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Share-EditUserShareThread" </asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <%
      Html.RenderPartial("Controls/Shares/SubMenu.ascx"); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
SetExpireDays="30" />
  <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
     if (TempData["StatusMessageData"] != null)
     {
         StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 2000, false));
         TempData["StatusMessageData"] = null;
     }

     int maxLengthForBody = ShareConfiguration.Instance().MaxLengthForBody;
     int maxLengthPerReply = ShareConfiguration.Instance().MaxLengthPerReply;
     ShareThread shareThread = null;
     if (Model.ThreadID > 0 && Model.SiteShareThread != null)
         shareThread = Model.SiteShareThread;
     else
         shareThread = TempData.Get<ShareThread>("shareThread", new ShareThread());
     int applicationID = ApplicationIDs.Instance().Share();
 %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all" id="eidtUserShareThread">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=Model.UserThreadID>0? GetResourceString("Title_EditShare", applicationID): GetResourceString("Title_AddShare", applicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <form id="UpdateUserShareThreadForm" method="post" action="<%=SPBUrlHelper.Action("CreateUpdateUserShareThread", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName },{"threadID",shareThread.ThreadID},{"userThreadID",Model.UserThreadID }})%>">
        <div class="tn-form tn-label-right">
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_NoteAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" value="<%=shareThread.URL %>" disabled="disabled" class="tn-textbox tn-input-long tn-border-gray" name="text">
            <input type="hidden" name="url" value="<%=shareThread.URL %>" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <span class="tn-form-required"></span><%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-long tn-border-gray"  id="subject" name="subject"  value="<%=Formatter.FormatSingleLinePlainTextForEdit(shareThread.Subject) %>" >
          </div>
          <%if (!string.IsNullOrEmpty(shareThread.PlayerUrl))
        {
            if (shareThread.MediaType == MediaTypes.Video)
            { %>
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <embed height="172" width="230" wmode="opaque" allowfullscreen="true" access="always" script="" allow="" 
                     type="application/x-shockwave-flash" src="<%=shareThread.PlayerUrl %>"/>
          </div>
          <%}
            if (shareThread.MediaType == MediaTypes.Music)
            { %>
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">
              <param name="bgcolor" value="#ffffff" />
              <param name="flashvars" value="playerMode=embedded" />
              <param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=shareThread.PlayerUrl %>&autoPlay=true" />
              <param name="wmode" value="window" />
              <param name="quality" value="best" />
              <embed type="application/x-shockwave-flash" width="400" height="27" src="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=shareThread.PlayerUrl %>&autoPlay=true" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed>
            </object>
          </div>
          <%}
        }%>
          <div class="tn-form-row tn-textarea-wrap">
            <label class="tn-form-label"><%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
            <textarea id="body" name="body" class="tn-textarea tn-input-long tn-border-gray" rows="" cols=""><%=Formatter.FormatMultiLinePlainTextForEdit(shareThread.Body,true)%></textarea><span style="display:none"></span>
            <div class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_WordLimit", applicationID), maxLengthForBody)%></div>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></label>
            <%ViewData["TagInputName"] = "userTags";
            ViewData["userTagItemKey"] = UserTagItemKeys.Instance().UserShareThread();
            List<string> selectedUserTags = Model.Tags;
            ViewData["SelectedUserTags"] = selectedUserTags;
            Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_BrowsePopedom", applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("privacyStatus", "dropDownList", Model.PrivacyStatus, Model.Password)%> </div>
          <div class="tn-collapsible tn-collapsible-closed">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
              <h4 class="tn-helper-reset"><a href="javascript:;;"><%=GetResourceString("Title_MoreSettings",ApplicationIDs.Instance().Share())%></a></h4>
            </div>
            <div class="tn-collapsible-content" style="display:block;">
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_MiniatureAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="thumbnailUrl" name="thumbnailUrl" value="<%=Formatter.FormatSingleLinePlainTextForEdit(shareThread.ThumbnailUrl) %>" />
              </div>
              <% if (shareThread.ApplicationID <= 0)
              { %>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_PlayAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" id="playerUrl" name="playerUrl" class="tn-textbox tn-input-long tn-border-gray"  value="<%=Formatter.FormatSingleLinePlainTextForEdit(shareThread.PlayerUrl) %>" />
              </div>
              <%} %>
              <%if (ShareConfiguration.Instance().EableUserEntrySiteCategory)
             { %>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_SiteShareType", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Share(), ShareConfiguration.Instance().SiteCategoryLevel - 1, "ShareSiteCategoryDDL", shareThread.SiteCategoryID, "dropDownList")); %>
              </div>
              <%} %>
              <%if (shareThread.ApplicationID <= 0 && shareThread.MediaType == MediaTypes.Website)
             { %>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_MultimediaType", applicationID)%><%=GetResourceString("Common_Colon")%></label>
                <select id="mediaType" name="mediaType" class="tn-dropdownlist">
                  <option <%if (shareThread.MediaType == MediaTypes.Website) Response.Write("select=\"select\""); %> value="<%=(int)MediaTypes.Website %>"><%=GetResourceString("Config_MediaTypeName_Website")%></option>
                  <option <%if(shareThread.MediaType==MediaTypes.Video) Response.Write("select=\"select\""); %> value="<%=(int)MediaTypes.Video %>"><%=GetResourceString("Config_MediaTypeName_Video")%></option>
                  <option <%if(shareThread.MediaType==MediaTypes.Music) Response.Write("select=\"select\""); %> value="<%=(int)MediaTypes.Music %>"><%=GetResourceString("Config_MediaTypeName_Radio")%></option>
                </select>
              </div>
              <%}
             else
             { %>
              <input type="hidden" value="<%=(int)shareThread.MediaType %>" name="mediaType" />
              <%} %>
            </div>
          </div>
          <div class="tn-blank10"></div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("saveShareEditButton", GetResourceString("Common_Share"),ButtonSizes.Default, new RouteValueDictionary { { "onclick", "saveShareEditButtonClick();" } },null)%>
            <% if (Request.UrlReferrer != null)
            {%>
            <%=SPBHtmlHelper.Instance().LinkButton("",GetResourceString("Button_Cancel"),Request.UrlReferrer.AbsoluteUri ,ButtonSizes.Default,HighlightStyles.Default)%>
            <%} %>
          </div>
        </div>
      </form>
    </div>
    <script type="text/javascript">
     $(document).ready(function() {
         $("#UpdateUserShareThreadForm").validate({
             rules: {
                 subject: { required: true, maxBlength: 80 },
                 privacyStatus_Password:{ required: true,},
                 body: { maxBlength:<%=maxLengthForBody %>  },
                 commentBody: { maxBlength:<%=maxLengthPerReply %>  },
                 shareCategoryID: { min:1}
                 <%if (ShareConfiguration.Instance().EableUserEntrySiteCategory)
                 { %>,
                    ShareSiteCategoryDDL:{required:<%=ShareConfiguration.Instance().SiteCategoryRequired.ToString().ToLower() %>}
                 <%} %>
             },
             messages: {
                 subject: { required: "<%=GetResourceString("Validate_MustImport", applicationID)%>", maxBlength: "<%=GetResourceString("Validate_MostChar", applicationID)%>" },
                 privacyStatus_Password:{ required: "<%=GetResourceString("Validate_MustImport", applicationID)%>",},
                 body: { maxBlength: "<%=string.Format( GetResourceString("Validate_Pattern_MostImportChar", applicationID), maxLengthForBody)%>" },
                 commentBody: { maxBlength: "<%=string.Format( GetResourceString("Validate_Pattern_MostImportChar", applicationID), maxLengthForBody)%>" },
                 mediaType: { min:"<%=GetResourceString("Validate_MustChoose", applicationID)%> " }
               <%if (ShareConfiguration.Instance().EableUserEntrySiteCategory)
                { %>,
                   ShareSiteCategoryDDL:{required:"<%=GetResourceString("Description_Required")%>"}
               <%} %>
             }
         });
        $(".tn-collapsible").collapsibleBox();
     });
    var saveShareEditButtonClick = function() {
     if ($("#UpdateUserShareThreadForm").valid()) {
         $("#saveShareEditButton").hide();
         $("#saveShareEditButton_ForHide").show();
     }
    return false;
 }
 </script>
  </div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Common_Help")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-helper-reset tn-list">
        <li><%=GetResourceString("Description_HowToShare", ApplicationIDs.Instance().Share())%></li>
        <li> <%=GetResourceString("Description_ImportLinkInTextBox", ApplicationIDs.Instance().Share())%></li>
        <li><%=GetResourceString("Description_HowToShareMedia", ApplicationIDs.Instance().Share())%></li>
        <li><%=GetResourceString("Description_ImportShareLinkInTextbox", ApplicationIDs.Instance().Share())%></li>
        <li><%=GetResourceString("Description_HowToShareMusic", ApplicationIDs.Instance().Share())%> </li>
        <li> <%=GetResourceString("Description_ImportMusicLink", ApplicationIDs.Instance().Share())%></li>
      </ul>
    </div>
  </div>
</asp:content>
