﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Share-ListFriendUserShareThreads"
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server"> 
<%ViewData["ShareUserDomainSubMenu"] = ShareUserDomainSubMenus.myFriend;
  Html.RenderPartial("Controls/Shares/SubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />

<%  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().Share();%>
 <div class="spb-share-list ui-tabs ui-widget ui-widget-content ui-corner-all" id="listFriendUserShareThreads"> 
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <li class="ui-state-default ui-corner-top">
            <a href="#userShareThreads">
                <span><%=GetResourceString("Action_All", applicationID)%></span></a></li>
        <% 
            Dictionary<int, string> mediaTypes = UrlParserFactory.Instance().UrlMediaTypes.ToDictionary(n => n.Key, n => UrlParserFactory.Instance().GetMultilingualMediaTypeName(n.Key, CurrentUserLanguage));
            foreach (KeyValuePair<int, string> mediaType in mediaTypes)
            {%>
        <li class="ui-state-default ui-corner-top">
            <a href="<%=SPBUrlHelper.Action("Control_ListUserShareThreads", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "mediaType", mediaType.Key }, {"isFriended",true} })%>">
                <span>
                    <%=mediaType.Value%></span></a></li>
        <%} %>
        <% foreach (int appID in ShareConfiguration.Instance().EnabledSharedApplicationIDs)
           {
               Application application = Applications.GetApplication(appID);
               if (application == null)
                   continue;
            %>
        <li class="ui-state-default ui-corner-top">
            <a href="<%=SPBUrlHelper.Action("Control_ListUserShareThreads", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", appID }, {"isFriended",true} })%>">
                <span>
                    <%=application.GetMultilingualApplicationName(CurrentUserLanguage) %></span></a></li>
        <%} %>
    </ul>
    <div id="userShareThreads" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
    <% Html.RenderAction<UserDomainShareController>(n => n.Control_ListUserShareThreads(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), null, null, string.Empty, true, Request.QueryString.GetInt("pageIndex", 1))); %>
    </div>
</div>
    <script type="text/javascript">
        $(document).ready(function() {
            $(".ui-tabs").tabs();
        });
    </script>

</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
 <% Html.RenderAction<MessageCenterController>(n => n.Control_ListApplicationFriendActivitiesBlock(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), ApplicationIDs.Instance().Share(), 10)); %>
</asp:content>
