﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<ShareComment>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Share-ManageComments"
</asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
  <% Html.RenderPartial("Controls/Shares/SubMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="templateContentRegion" runat="server" contentplaceholderid="templateContentRegion"></asp:content>
<asp:content runat="server" contentplaceholderid="manageMenusContent">
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
  %>
    <div id="ManageShareMenu">
        <div class="tn-box tn-widget tn-widget-content tn-corner-all">

            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <ul class="tn-side-menu">
                    <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a  class="tn-menu-text"
                        href="<%=SPBUrlHelper.Action("ManageComments","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_CommentManage")%></a></li>
                    <li ><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageShareUserTags","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                        <%=GetResourceString("Action_TagManage")%></a></li>
                </ul>
            </div>
        </div>
    </div>
</asp:content>
<asp:content runat="server" contentplaceholderid="manageContent">
  
  <%
      int applicationID = ApplicationIDs.Instance().Share();
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
  %>
  

    <div id="ManageComments">
          <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-content tn-widget-content tn-corner-all">
                <% if (TempData["StatusMessageType"] != null)
                   {
                       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                       if (messageType == StatusMessageType.Success)
                           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                       else
                           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
                           TempData["StatusMessageType"] = null;
                   }%>
                <div class="tn-list-header">
                <div class="tn-toolbar-area tn-helper-clearfix">
                    <label class="tn-check-all">
                      </label>
                      <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Delete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(confirm('" + GetResourceString("Valedate_AskDeleteVote", ApplicationIDs.Instance().Vote()) + "')) { $('#ManageShareCommentsForm').submit(); }" } }, null)%>
                    </div>
                </div>
                <form id="ManageShareCommentsForm" method="post" action="<%=SPBUrlHelper.Action("DeleteComments", "UserDomainShare", new RouteValueDictionary { { "userDomainName",userDomainName },{"returnUrl",Request.RawUrl} })%>">
                  <table class="tn-table-grid">
                    <tbody>
                       <tr class="tn-table-grid-header">
                         <td class="tn-border-gray tn-border-bottom tn-text-note"><input type="checkbox" name="checkbox" id="checkbox" class="tn-checkbox" onclick="checkAll(this,'ManageCommentsCheckBoxGroup')"></td>
                         <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_CommentUser")%>  </th>
                         <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Body")%> </td>
                         <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Title_CommnetObject",ApplicationIDs.Instance().Share())%> </td>
                         <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_CommentDate") %> </td>
                         <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </td>
                        </tr>
                <% foreach (ShareComment comment in Model.Records)
                   {%>
                        <tr class="tn-table-grid-row">
                           <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="ManageCommentsCheckBoxGroup" value="<%=comment.CommentID %>" class="tn-checkbox"></td>
                           <th class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"> <a href="<%=SiteUrls.Instance().UserDomainHome(comment.UserID) %>"><%=comment.Author%> </a> </th>
                           <td class="tn-border-gray tn-border-bottom tn-width-auto"><em class="tn-location"><a href="<%=SiteUrls.Instance().ShowShareThread(comment.ThreadID) %>" title="<%=HtmlUtils.StripForPreview(comment.Body) %>"><%=HtmlUtils.TrimHtml(comment.Body,20) %></a></em></td>
                           <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=SiteUrls.Instance().ShowShareThread(comment.ThreadID) %>"><%ShareThread thread = ShareThreads.GetThread(comment.ThreadID, false); if (thread != null) Response.Write(StringUtils.Trim(thread.Body, 10)); %></a></td>
                           <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=Formatter.FormatDate(comment.DateCreated) %></td>
                           <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap"><span class="tn-action"><a href="<%=SPBUrlHelper.Action("DeleteCommentInManage", "UserDomainShare", new RouteValueDictionary { { "commentID", comment.CommentID }, { "returnUrl",Request.RawUrl } })%>" 
                           onclick="if(!confirm('<%=GetResourceString("Valedate_AskDeleteVote", ApplicationIDs.Instance().Vote())%>')) return false;" class="tn-action-text"><%=GetResourceString("Action_Delete")%></a></span></td>
                      </tr>
                      <%} %>
                    </tbody>                      
                  </table>
                  </form>
                  <div class="tn-pagination tn-helper-align-center">
                    <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize, ViewData.Model.PageIndex)%>
                  </div>
             </div>
        </div>
  </div>
</asp:content>
