﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<UserShareThread>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    
</spb:Header>
<body>
    <% IList<Navigation> list = Navigations.GetDefaultNavgitions(PresentAreaIDs.Instance().Channel(), false);

       int applicationID = ApplicationIDs.Instance().Share();
       string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    %>
    <div class="spb-share-top-menu tn-helper-clearfix tn-bg-gray tn-border-gray tn-border-bottom"
        id="ShowShareLink">
        <div class="spb-top-logo">
            <div class="spb-home-link">
                <span class="tn-icon tn-icon-home"></span><a class="spb-top-logo-link" href="<%=SiteUrls.Instance().Home() %>">
                    <%=Globals.SiteName %></a>
            </div>
        </div>
        <div class="spb-share-url-panel">
            <div class="tn-avatar">
                <a href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,ApplicationIDs.Instance().Share()) %>">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID,true, HyperLinkTarget._blank, AvatarSizeTypes.Small) %></a>
            </div>
            <div class="spb-share-url-info">
                <strong><a href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID, applicationID)%>"
                    class="tn-user-name">
                    <%=Model.Author %></a></strong> <em class="tn-date">
                        <%=Formatter.FormatDate(Model.DateCreated)%></em><%=GetResourceString("Message_ShareTheLink",ApplicationIDs.Instance().Share())%>
                <%if (CurrentUser != null)
                      Response.Write(SPBHtmlHelper.Instance().LinkButton("sharelink", GetResourceString("Action_Share", applicationID), SiteUrls.Instance().ShareInModal(Model.ThreadID), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, null, null));
                  else
                      Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Share", ApplicationIDs.Instance().Share()), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, null, null));%>
                <%=SPBHtmlHelper.Instance().LinkButton("switchButton", GetResourceString("Common_Comment") + "(" + Model.CommentCount + ")", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Bubble, TextIconLayout.IconText)%>
                <div style="display: none" class="tn-simple-comments spb-share-comment" id="commentForLoad_0__<%=Model.UserThreadID %>"
                    name="commentForLoad">
                    <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                        <div class="tn-bubble-box-arrow">
                            <b class="tn-arrow-b1 tn-widget-content"></b><b class="tn-arrow-b2 tn-widget-content">
                            </b><b class="tn-arrow-b3 tn-widget-content"></b><b class="tn-arrow-b4 tn-widget-content">
                            </b><b class="tn-arrow-b5 tn-widget-content"></b>
                        </div>
                        <div class="tn-bubble-box-content tn-widget-content tn-corner-all">
                            <%Html.RenderAction<UserDomainShareController>(n => n.Control_ListUserShareComments(userDomainName, "ListUserShareCommentsInShareList", Model.UserThreadID, Request.QueryString.GetInt("pageIndex", 1))); %>
                        </div>
                    </div>
                </div>
            </div>
            <div class="spb-share-url-info">
                <%=GetResourceString("Title_NoceSite", applicationID)%><%=GetResourceString("Common_Colon") %><a
                    target="_blank" href="<%=Model.SiteShareThread.URL %>"><%=StringUtils.Trim(Model.SiteShareThread.URL, 30)%></a>
                <a class="tn-icon tn-icon-jump tn-icon-inline" title="<%=GetResourceString("Description_JumpToSite", applicationID)%>"
                    href="<%=Model.SiteShareThread.URL %>"></a>
            </div>
        </div>
        <span class="tn-helper-right">
            <% if (CurrentUser != null)
               {
                   bool hasManagePermission = CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator || CurrentUser.UserID == Model.UserID;
                   if (hasManagePermission)
                   { %>
            <a href="<%=SPBUrlHelper.Action("EditUserShareThread","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName},{"userThreadID",Model.UserThreadID}}) %>">
                <span>
                    <%=GetResourceString("Action_Edit")%></span></a> <a onclick="if(!confirm('<%=GetResourceString("Message_ConfirmDeleteShare", applicationID)%>')) return false;"
                        href="<%=SPBUrlHelper.Action("DeleteUserShareThreadForShow", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userThreadID", Model.UserThreadID }})%>">
                        <span>
                            <%=GetResourceString("Action_Delete")%></span></a>
            <%} %>
            <%} %>
        </span>
    </div>
    <div class="ifameBody">
        <iframe id="ifres" name="ifres" scrolling="auto" frameborder="0" src="<%=Model.SiteShareThread.URL %>"
            style="width: 100%; height: 100%;" onload="Javascript:resize();"></iframe>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('ul.sf-menu').superfish({ autoArrows: false });
            $("#switchButton").toggle(
            function() {
                $(this).find("a").text("<%=GetResourceString("Action_HideComments")%>");
                $("#commentForLoad_0__<%=Model.UserThreadID %>").toggle();
            },
            function() {
                $(this).find("a").text("<%=GetResourceString("Common_Comment") %>（<%=Model.CommentCount %>）");
                $("#commentForLoad_0__<%=Model.UserThreadID %>").toggle();

            });
            $('#sharelink').nyroModal({
              resizeable: true,
              width: 500
            });
        });
        function resize() {
            $("#ifres").height($(window).height() - ($(".shareHeader clearfix").height()));
        }
    </script>

</body>
</html>
