﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<UserShareThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Share-ShowUserShareThread"
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <% Html.RenderPartial("Controls/Shares/SubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int applicationID = ApplicationIDs.Instance().Share();

  //  bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
  bool hasManagePermission = CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator || CurrentUser.UserID == Model.UserID);

  bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
  PrivacyStatuses? errorPrivacyStatus = null;
  if (ViewData["errorPrivacyStatus"] != null)
      errorPrivacyStatus = (PrivacyStatuses)ViewData["errorPrivacyStatus"];

  if ((errorPrivacyStatus != null || errorAuditingStatus) && (CurrentUser == null || CurrentUser.UserID != Model.UserID))
  {
      string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
<div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right">
    <%if (Request.UrlReferrer != null)
      {%>
    <a href="<%=Request.UrlReferrer.AbsoluteUri %>"><%=GetResourceString("Action_ReturnList",ApplicationIDs.Instance().Share())%></a>
    <%} %>
    </span><span class="tn-helper-left">
    <%if (hasManagePermission)
          Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation, "", null));
      else if (errorPrivacyStatus != null)
      {
          switch (errorPrivacyStatus)
          {
              case PrivacyStatuses.OnlyFriend:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.User));
                  break;
              case PrivacyStatuses.NeedPassword:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), null));
                  break;
              case PrivacyStatuses.Privacy:
                  Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), null));
                  break;
              default:
                  break;
          }
      } %>
      </span>
      <div class="tn-helper-flowfix">
        <% if (errorAuditingStatus)
           {
               Response.Write(errorMessage);
               if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
               {
                   int threadid = Model.ThreadID;
                   int userThreadID = Model.UserThreadID;
          %>
      <%=GetResourceString("Description_ManagerUseShare",applicationID)%><a title="<%=GetResourceString("Description_AuditingShare",applicationID)%>" id="SetIsPassButton" href="<%=SPBUrlHelper.Action("updateUserShareThread","UserDomainShare",new RouteValueDictionary{{"threadid",threadid},{"userDomainName",userDomainName},{"userThreadID",userThreadID}})%>"><%=GetResourceString("Action_PastAuditing",applicationID)%></a>
      <%}
           }
           if (!hasManagePermission)
           {
               if (errorPrivacyStatus == PrivacyStatuses.OnlyFriend)
               {%>
                <%=GetResourceString("Description_ShareAllowFriend", applicationID)%>
                <%=string.Format(GetResourceString("Description_Pattern_BecomeFriendAfterView", applicationID), Model.Author)%>
                <%if (CurrentUser != null)
                  { %>
                <a class="nyroModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser!=null ?CurrentUser.UserName:string.Empty, Model.UserID) %>"> <%=GetResourceString("Action_IntercourseFriend")%></a>
                <%}
                  else
                  {%>
                <a href="<%=SiteUrls.Instance().Login(true) %>"> <%=GetResourceString("Action_IntercourseFriend")%></a>
                  <%} %>
               <%}
               else if (errorPrivacyStatus == PrivacyStatuses.NeedPassword)
               {%>
               <%=GetResourceString("Description_ShareThreadHavePassword",applicationID)%>
               <a href="javascript:;" onclick="$('#passwordSpan_<%=Model.ThreadID %>').toggle();">
                <%=GetResourceString("Common_HavePassword")%></a>
                <span id="passwordSpan_<%=Model.ThreadID %>" style="display:none">
                    <form method="get" action="<%=SiteUrls.Instance().ShowUserShareThread(userDomainName,Model.UserThreadID) %>">
                      <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="password" name="password" />
                      <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%>
                      <% if (Request.UrlReferrer != null)
                         {
                             Response.Write(SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, Request.UrlReferrer.AbsoluteUri));
                         } %>
                    </form>
                </span>
        <%}
               else if (errorPrivacyStatus == PrivacyStatuses.Privacy)
               {%> 
             <%=GetResourceString("Description_ShareThreadPrivate",applicationID)%>
        <%}
           }%>
      </div>
    </div>
</div>
<% }
  if (hasManagePermission || (!errorAuditingStatus && errorPrivacyStatus == null))
  { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all tn-detail spb-share-video-detail" id="ShowUserShareThread">
   <div class="tn-box-content tn-widget-content tn-corner-all">
     <div class="tn-text-heading">
       <h2 class="tn-title"><%=Model.SiteShareThread.Subject%></h2>
     </div>
     <% if (hasManagePermission)
        { %>
     <div class="tn-actions tn-helper-align-right">
     <span class="tn-action"><a href="<%=SPBUrlHelper.Action("EditUserShareThread","UserDomainShare",new RouteValueDictionary{{"userDomainName",userDomainName},{"userThreadID",Model.UserThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a></span>
     <span class="tn-action"><a onclick="if(!confirm('<%=GetResourceString("Message_ConfirmDeleteShare",applicationID)%>')) return false;" href="<%=SPBUrlHelper.Action("DeleteUserShareThreadForShow", "UserDomainShare", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userThreadID", Model.UserThreadID }})%>"><%=GetResourceString("Action_Delete")%></a></span></div>
     <%} %>
     <div class="tn-info-part tn-text-note tn-border-gray tn-border-top tn-detail-info">
        <dl>
          <dt><%=GetResourceString("Action_Source", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
          <dd><a href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,ApplicationIDs.Instance().Share()) %>"><b><%=Model.Author%></b></a></dd>
        </dl>
         <dl>
           <dd><%=Formatter.FormatFriendlyDate(Model.DateCreated) %></dd>
         </dl>
         <dl>
           <dt><%=GetResourceString("Label_ShareTotal", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
           <dd><%=Model.SiteShareThread.UserCount%></dd>
         </dl>
         <dl>
           <dt><%=GetResourceString("Label_BrowseTotal", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
           <dd><%=Model.SiteShareThread.HitTimes%></dd>
         </dl>
         <dl>
           <dt><%=GetResourceString("Common_Comment") %><%=GetResourceString("Common_Colon") %></dt>
           <dd><%=Model.CommentCount%></dd>
         </dl>
     </div>
     <div class="spb-share-media">
        <%if (Model.SiteShareThread.MediaType == MediaTypes.Video)
          { %>
        <div style="text-align:center">
          <embed height="416" width="500" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" 
                          type="application/x-shockwave-flash" src="<%=Model.SiteShareThread.PlayerUrl %>"></embed>
        </div>
        <% }
          else if (Model.SiteShareThread.MediaType == MediaTypes.Music)
          {%>
        <div align="center">
            <MARQUEE scrollAmount=3 scrollDelay=30 direction="right" width=400 height=30 >
               <P><FONT size=3><%=Model.SiteShareThread.Subject%></FONT></P>
            </MARQUEE>             
            <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">
               <param name="bgcolor" value="#ffffff" />
               <param name="flashvars" value="playerMode=embedded" />
               <param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=Model.SiteShareThread.PlayerUrl %>&autoPlay=true" />
               <param name="wmode" value="window" />
               <param name="quality" value="best" />
               <embed type="application/x-shockwave-flash" width="400" height="27" src="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=Model.SiteShareThread.PlayerUrl %>&autoPlay=true" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed>
            </object>
        </div>
          <%}%>
     </div>
     <div class="tn-detail-text">
     <p><%=Model.SiteShareThread.Body %></p>
     </div> 
     <%if (!string.IsNullOrEmpty(Model.Body))
       {%>
     <div class="spb-i-said">&nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span><%=Model.Body%><span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>
     <%} %>
     <div class="tn-feedback tn-border-gray tn-border-top ">
       <div class="tn-helper-right">
        <%  if (CurrentUser != null)
                Response.Write(SPBHtmlHelper.Instance().LinkButton("sharelink", GetResourceString("Action_Share", ApplicationIDs.Instance().Share()), SiteUrls.Instance().ShareInModal(Model.ThreadID), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null));
            else
                Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_Share", ApplicationIDs.Instance().Share()), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, null, null));  %>
        <%=SPBHtmlHelper.Instance().LinkButton(string.Empty,GetResourceString("Common_Comment"),"#comments",ButtonSizes.Default,HighlightStyles.Default,IconTypes.Bubble,TextIconLayout.IconText,null,null) %>
        <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_Drink", ApplicationIDs.Instance().Share()), SiteUrls.Instance().NewImpeachReport(), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Alert, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
      </div>
    </div>
    <%if (Model.PrevUserThreadID > 0 || Model.NextUserThreadID > 0)
      {%>
    <div class="tn-info-part tn-border-gray tn-border-top tn-context">
      <% if (Model.PrevUserThreadID > 0)
         { %>
      <dl>
        <dt><%=GetResourceString("Action_PrevUserThread", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
        <dd><a href="<%=SiteUrls.Instance().ShowUserShareThread(userDomainName,Model.PrevUserThreadID) %>"><%=Model.PrevUserThreadSubject%></a></dd>
      </dl>
      <%}
         if (Model.NextUserThreadID > 0)
         { %>
      <dl>
        <dt><%=GetResourceString("Action_NextUserThread", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
        <dd><a href="<%=SiteUrls.Instance().ShowUserShareThread(userDomainName,Model.NextUserThreadID) %>"><%=Model.NextUserThreadSubject%></a></dd>
      </dl>
      <%}%>
     </div>
    <%} %>
   
     <%Html.RenderAction<UserDomainShareController>(n => n.Control_ListUserShareComments(userDomainName, "ListUserShareComments", Model.UserThreadID, Request.QueryString.GetInt("pageIndex", 1))); %>
   </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $('#sharelink').nyroModal({
            resizeable: true,
            width: 500
        });
    });
</script>
  <%}%>
  
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <%Html.RenderAction<UserDomainShareController>(n => n.Control_UserShareThreadsBlock(Html.GetParameterFromRouteDateOrQueryString<String>("userDomainName"), Model.SiteShareThread.MediaType, Model.SiteShareThread.ApplicationID, 5));%>
  <%Html.RenderAction<UserDomainShareController>(n => n.Control_Relations(Html.GetParameterFromRouteDateOrQueryString<String>("userDomainName"), Model.UserID, Model.ThreadID, 9)); %>
</asp:content>
