﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<VoteThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Vote-ListMyFriendThreads"
</asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server"> 
<%ViewData["VoteUserDomainSubMenu"] = VoteUserDomainSubMenus.myFriend;
  Html.RenderPartial("Controls/Votes/SubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<%string userDomainNanme = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  if (TempData["StatusMessageData"] != null)
  {
      StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
      TempData["StatusMessageData"] = null;
  }
  TempData.Remove("StatusMessageData");%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all" id="ListMyFriendsVoteThreads">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"><span class="tn-helper-right"></span>
    <h3 class="tn-helper-reset"><%= GetResourceString("Description_IsFriendVote",ApplicationIDs.Instance().Vote())%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom spb-vote-rank">
<%if (Model != null)
  {
      if (TempData["StatusMessageData"] != null)
      {
          StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
      }
      TempData["StatusMessageData"]=null;
     %> 
      <ul class="tn-list tn-helper-reset">
      <%foreach (VoteThread item in Model.Records)
        {%>
      <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <a href="<%=SiteUrls.Instance().UserChannelHome(item.UserID,ApplicationIDs.Instance().Vote()) %>"><%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID,true,HyperLinkTarget._blank,AvatarSizeTypes.Small)%><span class="tn-round-corner"></span></a></div>
        </div>
        <div class="tn-list-item-area-right">
          <div class="tn-list-figure tn-widget">
            <div class="tn-list-figure-count tn-widget-content tn-corner-top"> <%=item.VoterCount%></div>
            <a class="tn-list-figure-button tn-state-default tn-corner-bottom" href="<%=SiteUrls.Instance().ShowVoteThread(item.ThreadID) %>"><%=GetResourceString("Title_Vote",ApplicationIDs.Instance().Vote())%></a></div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ShowVoteThread(item.ThreadID) %>"><%=StringUtils.Trim(item.Subject, 22)%></a></h5>
          </div>
          <div class="tn-list-item-row"> <cite><a class="tn-author" href="<%=SiteUrls.Instance().UserChannelHome(item.UserID,ApplicationIDs.Instance().Vote()) %>"><%=item.Author %></a></cite> <em class="tn-date tn-text-note"> <%=Formatter.FormatFriendlyDate(item.DateCreated)%></em> <em class="tn-date tn-text-note"><%=item.EndDate%></em> </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <%if (item.VoteOptions.Count > 0)
              {
                  foreach (KeyValuePair<int, VoteOption> pair in item.VoteOptions.Take(2))
                  {
                      if (item.IsMultiple)
                      {%>
                        <p class="tn-helper-reset">
                          <input type="checkbox" disabled="disabled" value="" name="" class="tn-checkbox">
                          <%=StringUtils.Trim(pair.Value.OptionName, 7)%></p>
              <%}
                      else
                      { %>
                        <p class="tn-helper-reset">
                      <input type="radio" disabled="disabled" value="" name="" class="tn-radiobutton">
                      <%=StringUtils.Trim(pair.Value.OptionName, 7)%></p>    
              <%}
                  }
              } %>
          <div class="tn-list-item-row">
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Comment") + "&nbsp;" + item.CommentCount, SiteUrls.Instance().ShowVoteThread(item.ThreadID) + "#comments", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Browse") + "&nbsp;" + item.HitTimes, SiteUrls.Instance().ShowVoteThread(item.ThreadID), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
          </div>
        </div>
      </li>
      <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords, Model.PageSize, Model.PageIndex, 7,null)%>
    </div>
    <%} %>
  </div>
</div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
    <%Html.RenderAction<MessageCenterController>(n => n.Control_ListApplicationFriendActivitiesBlock(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), ApplicationIDs.Instance().Vote(), 10));%>
</asp:content>
