﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PagingDataSet<VoteComment>>" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Vote-ManageComments"
</asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <%
      Html.RenderPartial("Controls/Votes/SubMenu.ascx", ViewData); %>
</asp:content>
<asp:content contentplaceholderid="manageContent" runat="server">



  <div id="ManageVoteComments">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-content tn-widget-content tn-corner-all">
         <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
            int applicationID = ApplicationIDs.Instance().Vote();
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                if (messageType == StatusMessageType.Success)
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                else
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
            }
            TempData["StatusMessageType"] = null;%>
         <div class="tn-list-header">
           <div class="tn-toolbar-area tn-helper-clearfix">
                    <label class="tn-check-all">
                      <input type="checkbox" name="checkbox" id="checkbox" class="tn-checkbox" onclick="checkAll(this,'ManageCommentsCheckBoxGroup')">
                      <%=GetResourceString("Label_SelectAllOrNo") %></label>
                      <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Delete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(confirm('" + GetResourceString("Valedate_AskDeleteVote", ApplicationIDs.Instance().Vote()) + "')) { $('#ManageVoteCommentsForm').submit(); }" } }, null)%>
                    </div>
         </div>
         <form id="ManageVoteCommentsForm" method="post" action="<%=SPBUrlHelper.Action("DeleteComments", "UserDomainVote", new RouteValueDictionary { { "userDomainName", userDomainName }, { "returnUrl", Request.RawUrl } }) %>">
           <table class="tn-table-grid">
             <tbody>
                <tr class="tn-table-grid-header">
                  <td class="tn-border-gray tn-border-bottom tn-text-note">&nbsp;</td>
                  <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_CommentUser")%>  </th>
                  <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Body")%> </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Title_CommentObject",applicationID) %></td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_CommentDate") %> </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </td>
                 </tr>
                <% foreach (VoteComment comment in Model.Records)
                   {%>
                 <tr class="tn-table-grid-row">
                    <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" name="ManageCommentsCheckBoxGroup" value="<%=comment.CommentID %>" class="tn-checkbox"></td>
                    <th class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"> <a href="<%=SiteUrls.Instance().UserDomainHome(comment.UserID) %>"><%=comment.Author%> </a> </th>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=SiteUrls.Instance().ShowVoteThread(comment.ThreadID)+"#"+comment.CommentID %>" title="<%=HtmlUtils.StripForPreview(comment.Body) %>"><%=StringUtils.Trim(comment.Body,10) %></a></td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap"><a href="<%=SiteUrls.Instance().ShowVoteThread(comment.ThreadID) %>"><%VoteThread thread = VoteThreads.GetThread(comment.ThreadID, false); if (thread != null) Response.Write(StringUtils.Trim(thread.Body, 10)); %></a></td>
                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><%=Formatter.FormatDate(comment.DateCreated) %></td>
                    <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap"><span class="tn-action"><a href="<%=SPBUrlHelper.Action("DeleteComment", "UserDomainVote", new RouteValueDictionary { { "commentID", comment.CommentID }, { "returnUrl" ,Request.RawUrl} })%>" onclick="!confirm('<%=GetResourceString("Valedate_AskDeleteVote", ApplicationIDs.Instance().Vote())%>') return false;" class="tn-action-text"><%=GetResourceString("Action_Delete")%></a></span></td>
               </tr>
               <%} %>
             </tbody>
           </table>
            <div class="tn-pagination tn-helper-align-center">
           <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize, ViewData.Model.PageIndex)%>
         </div>
           </form>
        
      </div>
    </div>
  </div>

</asp:content>
<asp:content contentplaceholderid="manageMenusContent" runat="server">
  <div  id="ManageVoteMenu">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-side-menu">
           <li class="tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all"><a class="tn-menu-text" href="javascript:;"><%= GetResourceString("Title_MangerVoteReview",ApplicationIDs.Instance().Vote())%></a></li>
        </ul>
      </div>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="templateContentRegion" runat="server"> </asp:content>
