﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<VoteThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Vote-NewVote" </asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <% ViewData["VoteSubMenu"] = null;
     Html.RenderPartial("Controls/Votes/SubMenu.ascx"); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
        SetExpireDays="30" />
  <% 
      int maxOptinCount = ViewData.GetInt("MaxVoteOptionCount", 20);
      int defalutOptinCount = maxOptinCount > 5 ? 5 : maxOptinCount;
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

      if (Model.VoteOptions.Count >= 2)
      {
          defalutOptinCount = Model.VoteOptions.Count;
      }

      if (TempData["StatusMessageData"] != null)
      {
          StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
      }
      TempData["StatusMessageData"] = null;
      string reUrl = SPBUrlHelper.Action("ListMyVoteThreads", "UserDomainVote", new RouteValueDictionary { { "userDomainName", userDomainName } });
      if (Request.UrlReferrer != null)
          reUrl = Request.UrlReferrer.AbsoluteUri;
      %>
  <form id="EditVoteThreadForm" action="<%=SPBUrlHelper.Action("CreateUpdateVoteThread","UserDomainVote",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",Model.ThreadID }}) %>"
    method="post">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-vote-form" id="NewVoteThread">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
          <%if (Model.ThreadID > 0)
            {
                Response.Write(GetResourceString("Title_EditVote", ApplicationIDs.Instance().Vote()));
            }
            else { Response.Write(GetResourceString("Title_DoVote", ApplicationIDs.Instance().Vote())); }%>
        </h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-form tn-label-right">
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_VoteThemes",ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" name="subject" id="subject" class="tn-textbox tn-input-longest tn-border-gray" value="<%=Model.Subject %>" maxlength="80">
            <span id="subjectHint" class="tn-text-note">0 / 80</span> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <span class="tn-button tn-button-text-icon tn-button-secondary"><span class="tn-first-child"> <span class="tn-icon tn-icon-collapse-open" id="co"></span><a href="javascript:;" class="tn-button-text" id="addDescription"> <%=GetResourceString("Label_AddVoteDescription",ApplicationIDs.Instance().Vote())%></a></span></span> </div>
          <div class="tn-form-row" id="voteExplain" style="display:none">
            <label class="tn-form-label"><%=GetResourceString("Label_VoteDescription",ApplicationIDs.Instance().Vote()) %><%=GetResourceString("Common_Colon") %></label>
            <textarea name="body" id="body" cols="" rows="" class="tn-textarea tn-input-longest tn-border-gray"><%= Formatter.FormatMultiLinePlainTextForEdit(Model.Body,true) %></textarea>
            <span id="bodyHint" class="tn-text-note">0 / 160</span> </div>
          <%  List<VoteOption> options = new List<VoteOption>();
              if (Model.VoteOptions != null)
                  options = Model.VoteOptions.Values.ToList();
              for (int i = 1; i <= defalutOptinCount; i++)
              {
                  VoteOption option = new VoteOption();
                  if (options.Count >= i)
                      option = options[i - 1];
                        %>
          <div class="tn-form-row" name="option" value="<%=i %>">
            <label class="tn-form-label"> <%=GetResourceString("Label_Options", ApplicationIDs.Instance().Vote())%><%=i%><%=GetResourceString("Common_Colon")%></label>
            <input type="text" name="voteOption_<%=i %>" id="voteOption_<%=i %>" class="tn-textbox tn-input-longest tn-border-gray {maxBlength:80}" value="<%=option.OptionName%>" />
            <%if (Model.ThreadID <= 0)
              { %>
            <a href="javascript:;" class="tn-icon tn-icon-cross delete tn-icon-inline" value="<%=i %>"></a>
            <%}
              else
              {%>
            <input type="hidden" id="voteOptionID_<%=i %>" name="OptionID_<%=i %>" value="<%=option.OptionID %>" />
            <input type="hidden"  class="delete"/>
            <%} %>
          </div>
          <%}
              defalutOptinCount = Model.VoteOptions.Count > 1 ? Model.VoteOptions.Count : 5; %>
          <input type="hidden" id="totalOptionCount" name="totalOptionCount" value="<%=defalutOptinCount %>" />
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <span class="tn-button tn-button-text-icon tn-button-secondary"><span class="tn-first-child"> <span class="tn-icon tn-icon-add"></span><a href="javascript:;" class="tn-button-text" id="addVoteOption"><%=GetResourceString("Label_Add0ptions",ApplicationIDs.Instance().Vote())%></a> </span></span> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_VoteMode",ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon") %></label>
            <select class="tn-dropdownlist" name="maxChooseCount">
              <option  <%if (!Model.IsMultiple) Response.Write("selected=\"selected\""); %> value="1"><%=GetResourceString("Label_SingleSelect",ApplicationIDs.Instance().Vote())%></option>
              
              
              <%for (int i = 2; i <= defalutOptinCount; i++)
                {%>
              <option value="<%=i%>" <%if (Model.IsMultiple && i == Model.MaxChooseCount) Response.Write("selected=\"selected\""); %>><%=string.Format(GetResourceString("Label_TheMostSelectItemsis",ApplicationIDs.Instance().Vote()),i )%></option>
              <%} %>
            </select>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_PrivacySetting")%><%=GetResourceString("Common_Colon") %></label>
            <select class="tn-dropdownlist" name="privacyStatus">
              <option <%if (Model.PrivacyStatus == PrivacyStatuses.Public) { Response.Write("selected = \"selected\""); } %> value="<%=(int)PrivacyStatuses.Public %>"><%=GetResourceString("Label_PermitAllPersonLook",ApplicationIDs.Instance().Vote())%></option>
              <option <%if (Model.PrivacyStatus == PrivacyStatuses.OnlyFriend) { Response.Write("selected = \"selected\""); } %> value="<%=(int)PrivacyStatuses.OnlyFriend %>"><%=GetResourceString("Enum_PrivacyStatuses_OnlyFriend",ApplicationIDs.Instance().Vote())%></option>
              <option <%if (Model.PrivacyStatus == PrivacyStatuses.Privacy) { Response.Write("selected = \"selected\""); } %> value="<%=(int)PrivacyStatuses.Privacy %>"><%=GetResourceString("Enum_ImpermanentClose", ApplicationIDs.Instance().Vote())%></option>
            </select>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_IsTime",ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon") %></label>
            <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("expireTime", null, null, Model.EndDate > DateTime.Now ? Model.EndDate : DateTime.Now.AddMonths(1), true, "tn-textbox tn-input-short tn-border-gray")); %>
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_ReviewSet",ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon") %></label>
            <div class="tn-input-multiple">
              <input type="radio" id="enableCommentsT" name="enableComments" class="tn-radiobutton"  value="true" <%if (Model.EnableComments == true) { Response.Write("checked=\"checked\""); } %>>
              <label for="enableCommentsT"> <%=GetResourceString("Label_PermitReview",ApplicationIDs.Instance().Vote())%></label>
              <input type="radio" id="enableCommentsF" name="enableComments" class="tn-radiobutton"  value="false" <%if (Model.EnableComments == false) { Response.Write("checked=\"checked\""); } %> >
              <label for="enableCommentsF"> <%=GetResourceString("Label_IsNotReview",ApplicationIDs.Instance().Vote())%></label>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("saveVoteEditButton", Model.ThreadID > 0 ? GetResourceString("Action_InputEdit", ApplicationIDs.Instance().Vote()) : GetResourceString("Title_DoVote", ApplicationIDs.Instance().Vote()), ButtonSizes.Large, new RouteValueDictionary { { "onclick", "saveVoteEditButtonClick();" } }, new RouteValueDictionary { })%> <%=SPBHtmlHelper.Instance().Button("Cancel", GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary { { "onclick", "window.location.href='" + reUrl + "'" } },null)%> </div>
        </div>
      </div>
    </div>
  </form>
  <script type="text/javascript" language="javascript">
    $(document).ready(function() {
        $("#subject").keyup(function() {
            $("#subjectHint").html(this.value.length + '/' + 80);
        });
        $("#body").keyup(function() {
            $("#bodyHint").html(this.value.length + '/' + 160);
        });
        $("#EditVoteThreadForm").validate({
            rules: {
                subject: { required: true, maxBlength: 80 },
                body: { maxBlength: 160 }
            },
            messages: {
                subject: { required: "<%=GetResourceString("Validate_InputTitle")%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_WordMaxLengthCannot",ApplicationIDs.Instance().Vote()),80) %>" },
                body: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_WordMaxLengthCannot",ApplicationIDs.Instance().Vote()),160) %>" }
            },
            onsubmit:true,
            onfocusout:false
        });

        $("#addDescription").toggle(
        function() {
            $(this).text("<%=GetResourceString("Validate_GetVoteDescription",ApplicationIDs.Instance().Vote()) %>");
            $("#voteExplain").show();
            $("#co").removeClass("tn-icon-collapse-open").addClass("tn-icon-collapse-close");
        },
        function() {
            $(this).text("<%=GetResourceString("Validate_AddVoteDescription",ApplicationIDs.Instance().Vote()) %>");
            $("#voteExplain").hide();
            $("#co").removeClass("tn-icon-collapse-close").addClass("tn-icon-collapse-open");
        });
        $("#addVoteOption").click(function() {
        var value = eval($("div[name='option']").length + 1);
            if(<%=maxOptinCount %>==value-1)
            {
                 alert("<%=string.Format(GetResourceString("Validate_Pattern_WordMaxLengthCannot",ApplicationIDs.Instance().Vote()),maxOptinCount) %>");
                 return false;
            }
            $("<div class=\"tn-form-row\" name=\"option\" "+"value=\'"+value+"\'>"
              + "<label class=\"tn-form-label\"><%=GetResourceString("Validate_Options",ApplicationIDs.Instance().Vote()) %>" + value + "<%=GetResourceString("Common_Colon")%></label>"
              + "<input class=\"tn-textbox tn-input-longest tn-border-gray {maxBlength:80}\" type=\"text\" name=\"voteOption_"+value+"\" id=\"voteOption_"+value+"\" />" + 
              " <a href=\"javascript:;\" class=\"tn-icon tn-icon-cross delete tn-icon-inline\"></a></div>")
              .find("a.delete").click(deleteOption).end().insertAfter("div[name='option']:last");
                          $("select[name='maxChooseCount'] option:last-child:last").after(" <option value=\"" + value + "\">（最多可以选择"+value+"项）</option>");
        });
        $("a.delete").click(deleteOption);
        $("#subject").focus();                    

    });
        
    var saveVoteEditButtonClick = function() {
        if ($("#EditVoteThreadForm").valid()) {
            $("#totalOptionCount").attr("value",$("div[name='option']").length);
            $("#saveVoteEditButton").hide();
            $("#saveVoteEditButton_ForHide").show();
        }
            return false;
    }
    function deleteOption(){
        if ($(".delete").length > 2) {
            $(this).parents("div[name=\"option\"]").nextAll("div[name=\"option\"]")
            .each(function(){
            var value=eval($(this).attr("value")-1);
            $(this).attr("value",value);
            $(this).find("label:first").text("<%=GetResourceString("Label_Options",ApplicationIDs.Instance().Vote()) %>"+value+"：").end().find("input").attr("name","voteOption_"+value);
            }).end().remove();
            $("select[name='maxChooseCount'] option:last-child").remove();
        }
        else
            alert('<%=GetResourceString("Validate_LowestTwoOption",ApplicationIDs.Instance().Vote()) %>');    
    }
    
</script>
</asp:content>
