﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    int applicationID = ApplicationIDs.Instance().User();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);

    bool isUserDomainOwnerOrAdministrator = false;
    if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
        isUserDomainOwnerOrAdministrator = true;

    IList<OwnerNavigation> userNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID, isUserDomainOwnerOrAdministrator);
    User showUser = currentDomainUser;


    string theGender = GetResourceString("Label_His", ApplicationIDs.Instance().User());
    if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
        theGender = GetResourceString("Label_My", ApplicationIDs.Instance().User());
    else
    {
        if (currentDomainUser.UserType == UserTypes.PersonUser && ((PersonUser)currentDomainUser).Gender == Genders.Female)
            theGender = GetResourceString("Label_Her", ApplicationIDs.Instance().User());
    }
%>
<div class="tn-unit tn-first">
    <div class="spb-app-bar">
        <div class="spb-profile-card tn-helper-clearfix">
            <div class="spb-profile-avatar">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(currentDomainUser.UserID, false, HyperLinkTarget._self, AvatarSizeTypes.Small,null)%>
                </div>
            </div>
            <div class="spb-profile">
                <h1 class="tn-helper-reset tn-user-name">
                    <%=currentDomainUser.DisplayName %></h1>
            </div>
        </div>
        <ul>
            <% if (CurrentUser != null && CurrentUser.UserID != currentDomainUser.UserID)
               {
            %>
            <li><a href="<%=SiteUrls.Instance().UserDomainHome(currentDomainUser.UserName)%>"><span
                class="spb-app-label">
                <%=GetResourceString("Label_GoBack",applicationID) %><%=theGender%><%=GetResourceString("Action_GotoMainPage",applicationID)%></span></a></li>
            <%  
                }
               Dictionary<int, Application> applications = Applications.GetApplications();
               string applicationKey = "default";
               foreach (OwnerNavigation navigation in userNavigations)
               {
                   if (!navigation.IsEnabled)
                       continue;

                   if (applications.ContainsKey(navigation.ApplicationID))
                       applicationKey = applications[navigation.ApplicationID].ApplicationKey;

                   string filePath = WebUtils.ResolveUrl(string.Format("~/Themes/Shared/Styles/ApplicationIcons/{0}.png", applicationKey.ToLower()));
                
            %>
            <li <% if(navigation.ApplicationID==applicationID) Response.Write("class=\"tn-selected\""); %>>
                <img src="<%=filePath %>" />
                <a href="<%=navigation.GetUserNavigationUrl(showUser.UserName)%>" value="<%=navigation.ApplicationID %>">
                    <span class="spb-app-label">
                        <% if (navigation.NavigationType == NavigationTypes.Application) Response.Write(theGender); %><%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></span></a></li>
            <%
                } %>
        </ul>
        <% if (CurrentUser != null)
           { %>
        <div class="spb-app-set tn-border-gray tn-border-top">
            <span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-config"></span>
                <a class="tn-action-text" href="<%=SPBUrlHelper.Action("ManageUserNavigations", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                    <%=GetResourceString("Title_NavigationsSettings",ApplicationIDs.Instance().User())%>
                </a></span>
        </div>
        <%} %>
    </div>
</div>
