﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    int applicationID = ApplicationIDs.Instance().Club();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    bool isCreater = ViewData.GetBool("isCreater", true);
    User currentDomainUser = Users.GetUser(userDomainName, false);
    bool isOwner = false;
    if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)
        isOwner = true;
%>
<%if (isOwner)
  {%>
<div class="tn-pagename tn-helper-clearfix tn-border-gray tn-border-bottom">
    <div class="tn-shortcut tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("newBlogThreadLink", GetResourceString("Button_CreateNewClub", applicationID), SPBUrlHelper.Action("NewClub", "ChannelClub", new RouteValueDictionary { }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Write, TextIconLayout.IconText)%>
    </div>
    <h1 class="tn-helper-reset tn-text-heading">
        <img src="<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/ApplicationIcons/club.png")%>" />
        群组</h1>
</div>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix">
                <li <% if(isCreater) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", userDomainName },{"isCreater",true} })%>">
                    <span>
                        <%=GetResourceString("Title_MyCreatedClub", applicationID)%></span></a></li>
            <%
                if (currentDomainUser.UserType == UserTypes.PersonUser && isOwner)
                {%>
            <li <% if(!isCreater) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", userDomainName },{"isCreater",false} })%>">
                    <span>
                        <%=GetResourceString("Title_MyJoinedClub", applicationID)%></span></a></li>
            <%} %>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().ChannelClubHome() %>" target="_blank">
                <span>
                    <%=GetResourceString("Title_ElseUserClub", applicationID)%></span></a></li>
        </ul>
    </div>
</div>
<%}
  else
  {
      ViewData["applicationID"] = ApplicationIDs.Instance().Club();
      Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
  }%>
