﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% int EventApplicationID = ApplicationIDs.Instance().Event();
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   EventUserDomainSubMenus? subMenu = null;
   if (ViewData["EventUserDomainSubMenus"] != null)
       subMenu = (EventUserDomainSubMenus)ViewData["EventUserDomainSubMenus"];
   User currentDomainUser = Users.GetUser(userDomainName, false);
   
   string genderName = ViewData.GetString("GenderName", GetResourceString("Navigation_MyEvent", EventApplicationID));
   string genderattentionName = ViewData.GetString("GenderAttentionName", GetResourceString("Navigation_MyAttentionEvent", EventApplicationID));
   bool isOwner = false;
   if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)//|| CurrentUser.IsContentAdministrator)
        isOwner = true;

%>
<%if (isOwner)
  {%>
<div class="tn-pagename tn-helper-clearfix tn-border-gray tn-border-bottom">
    <div class="tn-shortcut tn-helper-right">
    <% if (CurrentUser != null && EventPermission.Validate(null, Globals.GetCurrentUser(), PermissionItemKeys.Instance().CreateEvent()))
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton("newEventThreadLink", GetResourceString("Button_ReleaseNewEvent", EventApplicationID), SPBUrlHelper.Action("NewEvent", "ChannelEvent", new RouteValueDictionary { }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
                </div>
    <h1 class="tn-helper-reset tn-text-heading">
        <img src="<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/ApplicationIcons/event.png")%>" />
        活动</h1>
</div>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix">
              <li <% if(subMenu!=null && subMenu== EventUserDomainSubMenus.myEvents) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyEvents", "UserDomainEvent", new RouteValueDictionary { { "UserDomainName", userDomainName } })%>">
                    <span><%=genderName %></span></a></li>
             <li <% if(subMenu!=null && subMenu== EventUserDomainSubMenus.friendEvents) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMyFriendEvents", "UserDomainEvent", new RouteValueDictionary { { "UserDomainName",userDomainName } })%>"><span>
                    <%=GetResourceString("Navigation_MyFriendsEvent",EventApplicationID)%></span></a></li>            
            <%--<li <% if(subMenu!=null && subMenu== EventUserDomainSubMenus.myFavoriteEvents) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFavoriteEvents", "UserDomainEvent", new RouteValueDictionary { { "UserDomainName",userDomainName } })%>">
                    <span><%=genderattentionName %></span></a></li>--%>
            <li <% if(subMenu!=null && subMenu== EventUserDomainSubMenus.siteEvents) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SiteUrls.Instance().ChannelEventHome() %>"><span>
                    <%=GetResourceString("Navigation_AllEvent", EventApplicationID)%></span></a></li>             
        </ul>
    </div>
</div>

<%}
  else
  {
      ViewData["applicationID"] = ApplicationIDs.Instance().Event();
      Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
  }%>
