﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   FileUserDomainSubMenus? subMenu = null;
   if (ViewData["FileUserDomainSubMenu"] != null)
       subMenu = (FileUserDomainSubMenus)ViewData["FileUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName, false);
   
   bool isOwner = false;
   int appid = ApplicationIDs.Instance().File();
   if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)// || CurrentUser.IsAdministrator)
       isOwner = true;
   string theMale = GetResourceString("Title_HisFile", appid);
   string theMaleA = GetResourceString("Action_HeFriendFile", appid);
   if (currentDomainUser.UserType == UserTypes.PersonUser && ((PersonUser)currentDomainUser).Gender == Genders.Female)
   {
       theMale = GetResourceString("Title_HerFile", appid);
       theMaleA = GetResourceString("Action_SheFriendFile", appid);
   }
   if (CurrentUser!=null && CurrentUser.UserID == currentDomainUser.UserID)
   {
       theMale = GetResourceString("Title_MyFile", appid);
       theMaleA = GetResourceString("Action_MyFriendFile", appid);
   }         
%>
<%if (isOwner)
  {%>
<div class="tn-pagename tn-helper-clearfix tn-border-gray tn-border-bottom">
    <div class="tn-shortcut tn-helper-right">
        <%=SPBHtmlHelper.Instance().LinkButton("fileManage", GetResourceString("Title_FilesManage", appid), SPBUrlHelper.Action("ManageFileThreads", "File", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
        <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-helper-reset tn-widget-content">
            <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileThreads", "File", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                <%=GetResourceString("Title_FilesManage", appid)%></a></li>
            <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileComments","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                <%=GetResourceString("Action_CommentManage")%></a></li>
            <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileUserTags", "File", new RouteValueDictionary { {"userDomainName",userDomainName}})%>">
                <%=GetResourceString("Action_TagManage")%></a></li>
            <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageFileCategories", "File", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                <%=GetResourceString("Action_ManageFolder", appid)%></a></li>
        </ul>
        <%=SPBHtmlHelper.Instance().LinkButton("newFileThreadLink", GetResourceString("Label_UploadFile", appid), SPBUrlHelper.Action("UploadFiles", "File", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Write, TextIconLayout.IconText)%>
    </div>
    <h1 class="tn-helper-reset tn-text-heading">
        <img src="<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/ApplicationIcons/file.png")%>" />
        文件</h1>
</div>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix">
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.myFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=theMale %>
                    </span></a></li>
                    
                           <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.downloadFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("DownloadFiles","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%if (CurrentUser.UserID == currentDomainUser.UserID) Response.Write(GetResourceString("Title_MyDownLoadFile",appid));
                          else
                          {
                              if (currentDomainUser.UserType == UserTypes.PersonUser)
                              {
                                  PersonUser currentPersonUser = currentDomainUser as PersonUser;
                                  if (currentPersonUser != null)
                                  {
                                      if (currentPersonUser.Gender == Genders.Female)
                                          Response.Write(GetResourceString("Title_HerDownLoadFile",appid));
                                      else
                                          Response.Write(GetResourceString("Title_HisDownLoadFile",appid));
                                  }

                              }
                          }; %>
                    </span></a></li>
                    
                    
                    
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.friendFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListFriendsFileThreads","File",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=theMaleA %></span></a></li>
            <li <% if(subMenu!=null && subMenu== FileUserDomainSubMenus.siteFile) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SiteUrls.Instance().ChannelFileHome()  %>"><span>
                    <%=GetResourceString("Action_AllFiles", appid)%></span></a></li>
        </ul>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("[menu]", $(".spb-nav2-area")).menuButton();
    });
</script>

<%}
  else
  {
      ViewData["applicationID"] = ApplicationIDs.Instance().File();
      Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
  }%>
