﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User currentDomainUser = Users.GetUser(userDomainName, false);

   FriendUserDomainSubMenus? subMenu = null;
   if (ViewData["FriendUserDomainSubMenus"] != null)
       subMenu = (FriendUserDomainSubMenus)ViewData["FriendUserDomainSubMenus"];
   bool isOwner = false;
   if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)// || CurrentUser.IsContentAdministrator)
       isOwner = true;
   int friendApplicationID = ApplicationIDs.Instance().Friend();
%>
<%if (isOwner)
  {%>
<div class="tn-pagename tn-helper-clearfix tn-border-gray tn-border-bottom">
    <div class="tn-shortcut tn-helper-right">
        <%= SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_InvitationFriend"), SiteUrls.Instance().NewFriendInvitationByEmail(CurrentUser.UserName), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
    </div>
    <h1 class="tn-helper-reset tn-text-heading">
        <img src="<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/ApplicationIcons/friend.png")%>" />
        朋友</h1>
</div>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix">
            <li <% if(subMenu== FriendUserDomainSubMenus.MyFriends) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\"");else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_MyFriends",friendApplicationID) %></span></a></li>
            <li <% if(subMenu== FriendUserDomainSubMenus.OnlineFriends) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\"");else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListOnlineFriends","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_OnlineFriends", friendApplicationID)%></span></a></li>
            <%--<li <% if(subMenu== FriendUserDomainSubMenus.FavoriteUsers) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\"");else  Response.Write("class=\"spb-nav-item\""); %>>
                        <a href="<%=SPBUrlHelper.Action("ListFavoriteUsers","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                           <span> <%=GetResourceString("Navigation_FavoriteUsers", friendApplicationID)%></span></a></li>--%>
            <li <% if(subMenu== FriendUserDomainSubMenus.MightKnows) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\"");else  Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListMightKnowUsers","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_MightKnows",friendApplicationID) %></span></a></li>
            <%--<li <% if(subMenu== FriendUserDomainSubMenus.ConnectPaths) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\"");else  Response.Write("class=\"spb-nav-item\""); %>>
                        <a href="<%=SPBUrlHelper.Action("ListConnectPaths", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                           <span> <%=GetResourceString("Navigation_ConnectPaths", friendApplicationID)%></span></a></li>--%>
            <li class="spb-nav-item"><a target="_blank" href="<%=SPBUrlHelper.Action("UserSearch","ChannelUser",new RouteValueDictionary{}) %>">
                <span>
                    <%=GetResourceString("Navigation_UserSearch", friendApplicationID)%></span></a></li>
        </ul>
    </div>
</div>
<%}
  else
  {
      ViewData["applicationID"] = ApplicationIDs.Instance().Friend();
      Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
  }%>
