﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);

   PhotoUserDomainSubMenus? subMenu = null;
   if (ViewData["PhotoUserDomainSubMenu"] != null)
       subMenu = (PhotoUserDomainSubMenus)ViewData["PhotoUserDomainSubMenu"];
   User currentDomainUser = Users.GetUser(userDomainName,false);
   
   bool isOwner = false;
   if (CurrentUser != null && CurrentUser.UserID == currentDomainUser.UserID)// || CurrentUser.IsContentAdministrator)
       isOwner = true;
   Genders gender = Genders.Male;
   if (currentDomainUser.UserType == UserTypes.PersonUser && ((PersonUser)currentDomainUser).Gender == Genders.Female)
       gender = Genders.Female;
   int applicationID = ApplicationIDs.Instance().Photo();
%>
<%if (isOwner)
  {%>
<div class="tn-pagename tn-helper-clearfix tn-border-gray tn-border-bottom">
    <div class="tn-shortcut tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("photoManage",GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo()),SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotos","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}})%>">
                    <%=GetResourceString("Action_ManagerPhotos",ApplicationIDs.Instance().Photo())%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoComments","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_CommentManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoUserTags","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_TagManage")%></a></li>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePhotoSectionSettings","Photo",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Action_SetGallery",applicationID)%></a></li>
            </ul>
            <%=SPBHtmlHelper.Instance().LinkButton("UploadPhotos", GetResourceString("Label_UpLoadImage", applicationID), SPBUrlHelper.Action("UploadPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>

    </div>
    <h1 class="tn-helper-reset tn-text-heading">
        <img src="<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/ApplicationIcons/photo.png")%>" />
        相册</h1>
</div>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix">
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.myPhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("Home", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%// string.Format(GetResourceString("Action_ICallery",applicationID),theMale) 
                            if (isOwner)
                                Response.Write(GetResourceString("Navigation_MyPhoto", applicationID));
                            else if (gender == Genders.Male)
                                Response.Write(GetResourceString("Navigation_HisPhoto", applicationID));
                            else
                                Response.Write(GetResourceString("Navigation_HerPhoto", applicationID));
                        %></span></a></li>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.latestPhoto) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListPhotos", "Photo", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"><span>
                    <%=GetResourceString("Navigation_LatestPhoto", applicationID)%></span></a>
            </li>
            <%
                if (CurrentUser != null && currentDomainUser.UserType == UserTypes.PersonUser && (isOwner || CurrentUser.IsContentAdministrator))
                {%>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.friendPhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SPBUrlHelper.Action("ListFriendsPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>">
                    <span>
                        <%//string.Format(GetResourceString("Action_FriendGallery",applicationID),theMale)
                            if (isOwner)
                                Response.Write(GetResourceString("Navigation_MyFriendPhoto", applicationID));
                            else if (gender == Genders.Male)
                                Response.Write(GetResourceString("Navigation_HisFriendPhoto", applicationID));
                            else
                                Response.Write(GetResourceString("Navigation_HerFriendPhoto", applicationID));
                        %></span></a></li>

            <%} %>
            <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.sitePhotoCategory) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else  Response.Write("class=\"spb-nav-item\"");  %>>
                <a href="<%=SiteUrls.Instance().ChannelPhotoHome()  %>" target="_blank"><span>
                    <%=GetResourceString("Action_OtherPeopleGallery",applicationID)%></span></a>
            </li>
        </ul>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("[menu]", $(".spb-nav2-area")).menuButton();
    });
</script>

<%}
  else
  {
      ViewData["applicationID"] = ApplicationIDs.Instance().Photo();
      Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
  }%>




<%--<div class="contentHeader">
  <div class="wrapper">
    <div class="fill">
      <%
                if (currentDomainUser.UserID != CurrentUser.UserID)
                    Html.RenderPartial("Controls/topCard.ascx", currentDomainUser);
            %>
      <div class="subMenus clearfix">
        <% if (isOwner)
                   {%>
        <div class="act"> <a class="inlineButton newAdd" href="<%=SPBUrlHelper.Action("UploadPhotos","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><span><%=GetResourceString("Label_UpLoadImage",ApplicationIDs.Instance().Vote())%></span></a> </div>
        <span class="act"><a href="<%=SPBUrlHelper.Action("ManagePhotoSectionSettings","Photo",new RouteValueDictionary {{"userDomainName",userDomainName}}) %>"><%= GetResourceString("Label_MangerCallerys",ApplicationIDs.Instance().Vote())%></a> </span>
        <%} %>
        <ul class="subMenuFix">
          <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.myPhoto) Response.Write("class=\"current\""); %>> <a href="<%=SPBUrlHelper.Action("Home", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>"> <%=string.Format(GetResourceString("Action_ICallery",ApplicationIDs.Instance().Vote()), theMale)%></a></li>
          <li class="pipe">|</li>
          <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.friendPhoto) Response.Write("class=\"current\""); %>> <a href="<%=SPBUrlHelper.Action("ListFriendsPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>"> <%=theMale %><%=GetResourceString("Label_FriendCallery",ApplicationIDs.Instance().Vote())%></a></li>
          <li class="pipe">|</li>
          <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.taggedPhoto) Response.Write("class=\"current\""); %>> <a href="<%=SPBUrlHelper.Action("ListTaggedPhotos", "Photo", new RouteValueDictionary { {"userDomainName",userDomainName} })%>"> <%=theMale %><%= GetResourceString("Label_MyImagess",ApplicationIDs.Instance().Vote())%></a></li>
          <li class="pipe">|</li>
          <li <% if(subMenu!=null && subMenu== PhotoUserDomainSubMenus.sitePhoto) Response.Write("class=\"current\""); %>> <a href="<%=SiteUrls.Instance().ChannelPhotoHome()  %>"><%= GetResourceString("Label_AllCallery",ApplicationIDs.Instance().Vote())%></a></li>
        </ul>
      </div>
    </div>
  </div>
</div>--%>
