﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User currentDomainUser = Users.GetUser(userDomainName, false);
   bool isUserDomainOwnerOrAdministrator = false;
   if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
       isUserDomainOwnerOrAdministrator = true;
   IList<OwnerNavigation> currentDomainUserNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID, isUserDomainOwnerOrAdministrator);
   int count = 5;// UserDomainConfiguration.Instance().MaxApplicationMenuCount;//一级导航最多显示几个菜单
   if (count < 1) count = 1;
   if (count > currentDomainUserNavigations.Count) count = currentDomainUserNavigations.Count;
   int applicationID = ViewData.GetInt("applicationID", -1);

%>
<div class="spb-profile-card tn-helper-clearfix">
    <div class="spb-profile-avatar">
        <div class="tn-avatar">
            <%
               
                Response.Write(SPBHtmlHelper.Instance().ShowUserAvatar(currentDomainUser, false, HyperLinkTarget._self, AvatarSizeTypes.Small, isUserDomainOwnerOrAdministrator, new RouteValueDictionary()));
            %>
        </div>
    </div>
    <div class="spb-profile">
        <h1 class="tn-user-name">
            <% Response.Write(currentDomainUser.DisplayName);%></h1>
        <span class="spb-user-type">
            <a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                <%=SPBHtmlHelper.Instance().ShowUserRankIcons(currentDomainUser)%></a></span><em
                    class="tn-text-note">（<%=string.Format(GetResourceString("Label_PeopleVisit"),currentDomainUser.HitTimes) %>）</em>
    </div>
    <div class="spb-status">
        <%MicroBlogUserData userData = null;
          if (CurrentUser != null && currentDomainUser.UserID == CurrentUser.UserID)
              userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, true);
          else
              userData = MicroBlogUserDatas.GetUserData(currentDomainUser.UserID, false);
          if (userData != null)
              Response.Write(userData.MostRecentThreadBody);
          else
              Response.Write(GetResourceString("Label_NoNews"));
        %>
        <em class="tn-text-note">
            <%=Formatter.FormatFriendlyDate(userData.MostRecentThreadDate) %></em><a href="<%=SiteUrls.Instance().MyMicroBlogs(currentDomainUser.UserID) %>"><%=GetResourceString("Action_More") %></a>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav1 tn-helper-reset tn-helper-clearfix sf-menu">
            <li id='home' <% if(applicationID== UserDomainSpecialAppIDs.Instance().Home()){ Response.Write("class=\"spb-nav-item tn-selected\""); }  else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=SPBUrlHelper.Action("Home","UserDomain",new RouteValueDictionary{{"userDomainName",currentDomainUser.UserName}}) %>">
                    <span>
                        <% if (isUserDomainOwnerOrAdministrator) Response.Write(GetResourceString("Navigation_UserDomain_Home")); else Response.Write(GetResourceString("Navigation_UserDomain_Home_ToOtherUser"));%>
                    </span>
                </a>
            </li>
            <li id='profile' <% if(applicationID== UserDomainSpecialAppIDs.Instance().Profile()){ Response.Write("class=\"spb-nav-item tn-selected\""); }  else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=SPBUrlHelper.Action("ShowProfile", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Title_Profile") %></span></a></li>
            <% 
                int i = 0;//遍历序号
                int j = 0;//已显示的导航个数
                foreach (OwnerNavigation navigation in currentDomainUserNavigations)
                {
                    i++;
                    if (!navigation.IsVisible(isUserDomainOwnerOrAdministrator))
                        continue;
                    j++;
                    if (j <= count)
                    {                    
            %>
            <li <% if(applicationID==navigation.ApplicationID){ Response.Write("class=\"spb-nav-item tn-selected\""); } else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>" target="<%=navigation.NavigationTarget %>"
                    value="<%=navigation.ApplicationID %>">
                    <span>
                        <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></span></a></li>
            <%
                if (i == currentDomainUserNavigations.Count)
                {
            %>
            <% 
                break;
                }
                    }
                    if (j == count)
                    {%>
            <%} if (j == count + 1)
                    { %>
            <li class="spb-nav-item">
                <a href="javascript:;">
                    <span>&nbsp;</span></a>
                <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="display: none;
                    visibility: hidden;">
                    <% }
                    if (j > count)
                    { %>
                    <li>
                        <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>">
                            <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></a></li>
                    <%}%>
                    <%} %>
                    <%if (i == currentDomainUserNavigations.Count && j > count) //全部查找完毕,关闭标签
                      { %>
                    <% if (isUserDomainOwnerOrAdministrator)
                       { %>
                    <li class="spb-separator"></li>
                    <li>
                        <a href="<%=SPBUrlHelper.Action("ManageUserNavigations", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName } })%>">
                            <%=GetResourceString("Title_NavigationsSettings",ApplicationIDs.Instance().User())%>
                        </a>
                    </li>
                    <%} %>
                </ul>
            </li>
        </ul>
        <%} %>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('ul.sf-menu').superfish();

    });  
</script>

