﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
    
</spb:Header>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  User currentDomainUser = Users.GetUser(userDomainName, false);
%>
<body class="tn-page-bg spb-personal-centre" id="myHome">
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper tn-helper-clearfix">
                <%  Html.RenderPartial("Controls/Header.ascx", ViewData);
                    int UserApplicationID = ApplicationIDs.Instance().User(); %>
            </div>
        </div>
        <div id="tn-content" class="tn-content-bg tn-doc2">
            <div class="tn-wrapper">
                <div class="tn-grid">
                    <div class="tn-unit tn-first">
                        <% Html.RenderPartial("Controls/ApplicationMenu.ascx"); %>
                    </div>
                    <div class="tn-grid">
                        <div class="spb-main tn-helper-clearfix">
                            <div class="spb-content-left">
                             <%
                                        if (Applications.IsEnabled(ApplicationIDs.Instance().MicroBlog()))
                                        {
                                            Html.RenderAction<UserDomainMicroBlogController>(n => n.Control_MicroBlogInput(userDomainName));
                                        }%>  <div class="tn-blank10">
                            </div>
                        <div class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-new-activities" id="activitiescontainer">
                                <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                                    <li><a href="<%=SPBUrlHelper.Action("Control_ListFriendActivitiesBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                                        title="<%=GetResourceString("Action_FriendActivity",UserApplicationID)%>"><span>
                                            <%=GetResourceString("Action_FriendActivity",UserApplicationID)%></span></a></li>
                                    <li><a href="<%=SPBUrlHelper.Action("Control_ListReceivedClubActivitiesBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
                                    
                                        title="<%=GetResourceString("Action_ClubActivity",UserApplicationID)%>"><span>
                                            <%=GetResourceString("Action_ClubActivity",UserApplicationID)%></span></a></li>
                                    <li><a href="<%=SPBUrlHelper.Action("Control_ListUserActivitiesForTab", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "isMyActivity", false } })%>"
                                        title="<%=GetResourceString("Action_SiteActivity",UserApplicationID)%>"><span>
                                            <%=GetResourceString("Action_SiteActivity",UserApplicationID)%></span></a></li>
                                    <li><a href="<%=SPBUrlHelper.Action("Control_ListUserActivitiesForTab","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"isMyActivity",true}}) %>"
                                        title="<%=GetResourceString("Action_MyActivity",UserApplicationID)%>"><span>
                                            <%=GetResourceString("Action_MyActivity",UserApplicationID)%></span></a>
                                        
                                        </li>
                                        <li id="setting" class="tn-helper-right"><span><a target="_blank" href="<%=SPBUrlHelper.Action("ActivitySettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                                            <%=GetResourceString("Title_ActivitySettings", UserApplicationID)%></a></span></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="spb-content-right">
                                <div class="ui-tabs ui-widget ui-widget-content ui-corner-all" id="visitListcontainer">
                                    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                                        <li><a href="<%=SPBUrlHelper.Action("Control_ListVisitBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"isVisitor",true}}) %>"
                                            title="ListVisitBlock"><span>
                                                <%=GetResourceString("Title_ListVisitor",UserApplicationID)%></span></a></li>
                                        <li><a href="<%=SPBUrlHelper.Action("Control_ListVisitBlock","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName},{"isVisitor",false}}) %>"
                                            title="ListVisitBlock"><span>
                                                <%=GetResourceString("Title_ListVisited",UserApplicationID) %></span></a></li>
                                    </ul>
                                </div>
                                <div class="tn-blank10">
                                </div>
                                <div id="spb-may-know" class="tn-box tn-widget tn-widget-content tn-corner-all">
                                    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                        <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListMightKnowUsers","Friend",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                                            <%=GetResourceString("Action_More")%></a> </span>
                                        <h3 class="tn-helper-reset">
                                            <%=GetResourceString("Title_IMayRecognizantUser",UserApplicationID)%></h3>
                                    </div>
                                    <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                        <% Html.RenderAction<FriendController>(n => n.Control_MayKnowUsersBlock(userDomainName, 9)); %>
                                    </div>
                                </div>                               
                                <% PersonUser pu = currentDomainUser as PersonUser; %>
                                <div id="spb-profile-statistics" class="tn-box tn-widget tn-widget-content tn-corner-all">
                                    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                        <h3 class="tn-helper-reset">
                                            <%=GetResourceString("Title_FileInfoIntegrality",UserApplicationID)%></h3>
                                    </div>
                                    <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                        <div class="tn-info-part">
                                            <div class="tn-progress-bar tn-widget tn-widget-content tn-corner-all">
                                                <div style="width: <%=pu.ProfileIntegrity %>%;" class="tn-progress-bar-value tn-widget-header tn-corner-left">
                                                </div>
                                            </div>
                                            <ul class="tn-helper-reset">
                                                <li class="tn-text-note">
                                                    <%=GetResourceString("Lable_ProfileCompletenes",UserApplicationID) %>
                                                    <%=pu.ProfileIntegrity %>% </li>
                                            </ul>
                                            <% IList<ProfileItems> unfinishedProfiles = pu.UnfinishedProfiles;
                   int[] IntegrityProportions = SiteSettingsManager.GetSiteSettings().IntegrityProportions;%>
                                            <ul class="tn-helper-reset">
                                                <% foreach (ProfileItems profileItem in unfinishedProfiles)
                                               { %>
                                                <li>
                                                    <% switch (profileItem)
                                                   {
                                                       case ProfileItems.Avatar:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>",
                                                               SPBUrlHelper.Action("UploadAvatar", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName } }), GetResourceString("Title_Pattern_Point_UploadAvatar", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.Avatar]
                                                               ));
                                                           break;
                                                       case ProfileItems.Birthday:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Action_InputBirthday", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.Birthday]
                                                               ));
                                                           break;
                                                       case ProfileItems.HomeArea:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Action_InputHome", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.HomeArea]
                                                               ));
                                                           break;
                                                       case ProfileItems.IM:
                                                           Response.Write(string.Format("<a href=\"{0}\" title=\"{1}\">{2}</a><span>+{3}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.PersonContact } }), GetResourceString("Description_InstantMessageTool", UserApplicationID), GetResourceString("Action_InputInstantMessage", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.IM]
                                                               ));
                                                           break;
                                                       case ProfileItems.JobInformation:
                                                           Response.Write(string.Format("<a href=\"{0}\" title=\"{1}\">{2}</a><span>+{3}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.BusinessContact } }), GetResourceString("Description_ProfessionalInfo", UserApplicationID), GetResourceString("Action_InputProfessionalInfo", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.JobInformation]
                                                               ));
                                                           break;
                                                       case ProfileItems.NowArea:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Action_InputLivingAddress", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.NowArea]
                                                               ));
                                                           break;
                                                       case ProfileItems.PublicEmail:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.PersonContact } }), GetResourceString("Action_InputOpenEmail", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.PublicEmail]
                                                               ));
                                                           break;
                                                       case ProfileItems.School:
                                                           Response.Write(string.Format("<a href=\"{0}\">{1}</a><span>+{2}％</span>", SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "type", PersonProfileType.BasicInfo } }), GetResourceString("Action_InputGraduateSchool", UserApplicationID),
                                                               IntegrityProportions[(int)ProfileItems.School]
                                                               ));
                                                           break;
                                                       default:
                                                           break;
                                                   } %>
                                                </li>
                                                <%} %>

                                                 <%if (pu.ProfileIntegrity<100){ %>
                                    <li><a href="<%=SPBUrlHelper.Action("UploadAvatar", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">进入完善资料向导</a></li>
                                    <%} %>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <%if (!CurrentUser.IsContentAdministrator)
                                  { %>
                                <div class="tn-blank10">
                                </div>
                                <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-space-capacity">
                                    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                        <h3 class="tn-helper-reset">
                                            <%=GetResourceString("Lable_SpatialCapacity", UserApplicationID)%></h3>
                                    </div>
                                    <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                        <div class="tn-info-part">
                                            <dl>
                                                <dt>
                                                    <%=GetResourceString("Lable_TotalCapacityOfSpace", UserApplicationID)%>：</dt>
                                                <dd>
                                                    <%=Formatter.FormatFriendlyFileSize(currentDomainUser.DatabaseQuota * 1024)%></dd>
                                            </dl>
                                            <dl>
                                                <dt>
                                                    <%=GetResourceString("Lable_AlreadyUse", UserApplicationID)%>：</dt>
                                                <dd>
                                                    <%=Formatter.FormatFriendlyFileSize(currentDomainUser.DatabaseQuotaUsed * 1024)%></dd>
                                            </dl>
                                        </div>
                                    </div>
                                </div>
                                <%} %>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            var totalLength = $("#progressbar-back").width();
            var barLength = eval("<%=currentDomainUser.ProfileIntegrity/100 %>") * totalLength;
            $("#progressbar-bar").width(barLength);
            $('#visitListcontainer').tabs();
            $('#activitiescontainer').tabs({
                select: function(event, ui) {
                    if ($(ui.tab).parents("li:first").is('li#setting')) {
                        window.open($.data(ui.tab, 'load.tabs'));
                        return false;
                    }
                }
            });
        });
    </script>

</body>
</html>
