﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<PersonUser>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
    
</spb:Header>
<body id="Profile" class="tn-page-bg">
    <% PersonUser currentDomainUser = ViewData.Model;
       User CurrentUser = ViewData.Get<User>("CurrentUser");
       int applicationID = ApplicationIDs.Instance().User();
       PersonUser currentPersonUser = currentDomainUser as PersonUser;
       string friendlyMessage = GetResourceString("Enum_PrivacyStatuses_OnlyFriend");
       bool isFriend = CurrentUser != null && Friends.IsFriend(CurrentUser.UserID, currentDomainUser.UserID);%>
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <div class="tn-wrapper tn-helper-clearfix">
                    <%  ViewData["ApplicationID"] = UserDomainSpecialAppIDs.Instance().Home();
                        Html.RenderPartial("Controls/Header.ascx", ViewData); %>
                </div>
            </div>
        </div>
        <div class="tn-content-bg tn-doc2" id="tn-content">
            <div class="tn-wrapper">
                <div class="tn-template-l-230 tn-helper-clearfix spb-guest-container">
                    <div class="tn-main">
                        <div class="tn-block">
                            <% ViewData["applicationID"] = UserDomainSpecialAppIDs.Instance().Profile();
                               Html.RenderPartial("Controls/SubMenu.ascx", ViewData); %>
                            <div id="myProfile" class="tn-box tn-widget tn-widget-content tn-corner-all spb-user-detail">
                                <div class="tn-box-content tn-widget-content tn-corner-all">
                                    <% if (currentPersonUser != null)
                                       {%>
                                    <div class="tn-info-part">
                                        <%if (CurrentUser != null && (currentPersonUser.UserName == CurrentUser.UserName || CurrentUser.IsContentAdministrator))
                                          {%>
                                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                                            <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "type", "BasicInfo" } })%>">
                                                <%=GetResourceString("Action_Edit")%></a></span>
                                            <h4>
                                                <%=GetResourceString("Title_BasicInfo", applicationID)%></h4>
                                        </div>
                                        <%} %>
                                        <%if (!string.IsNullOrEmpty(currentPersonUser.CommonName))
                                          { %>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_UserID",applicationID) %><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.UserID%></dd>
                                        </dl>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CommonName%></dd>
                                        </dl>
                                        <%} if (SiteSettingsManager.GetSiteSettings().EnableNickName && !string.IsNullOrEmpty(currentPersonUser.NickName))
                                          { %>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_ShowUserNickName",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=currentPersonUser.NickName%></dd>
                                        </dl>
                                        <%} %>
                                        <dl class="tn-helper-clearfix">
                                            <% int gender = (int)currentPersonUser.Gender; %>
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserGender",applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%if (gender == 2) Response.Write(GetResourceString("Enum_Genders_Female")); else Response.Write(GetResourceString("Enum_Genders_Male")); %>
                                            </dd>
                                        </dl>
                                        <% if (currentPersonUser.Age > 0 && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_Birthday()))
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserBirthday", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                            <dd>
                                                <%=string.Format(GetResourceString("Description_Pattern_Age", applicationID), currentPersonUser.Age)%></dd>
                                        </dl>
                                        <%}%>
                                        <% if (!string.IsNullOrEmpty(currentPersonUser.NowAreaCode))
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_UserAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <a target="_blank" title="<%=string.Format(GetResourceString("Action_Pattern_ClickSearchSameCityMembers",applicationID),Formatter.FormatArea(currentPersonUser.NowAreaCode,true)) %>"
                                                    href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { {"NowAreaCode",currentPersonUser.NowAreaCode} })%>">
                                                    <%=Formatter.FormatArea(currentPersonUser.NowAreaCode, true)%></a></dd>
                                        </dl>
                                        <%} %>
                                        <% if (!string.IsNullOrEmpty(currentPersonUser.HomeAreaCode))
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_UserHomeAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <a target="_blank" title="<%=string.Format(GetResourceString("Action_Pattern_ClickSearchSameHomeTownMembers",applicationID),Formatter.FormatArea(currentPersonUser.HomeAreaCode,true)) %>"
                                                    href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary {{"HomeAreaCode",currentPersonUser.HomeAreaCode}})%>">
                                                    <%=Formatter.FormatArea(currentPersonUser.HomeAreaCode, true)%></a></dd>
                                        </dl>
                                        <%} %>
                                        <%if (!string.IsNullOrEmpty(currentPersonUser.School))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserSchool", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <a target="_blank" title="<%=string.Format(GetResourceString("Action_Pattern_ClickSearchSameSchoolMembers",applicationID),currentPersonUser.School) %>"
                                                    href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { {"School",currentPersonUser.School} })%>">
                                                    <%=currentPersonUser.School%></a></dd>
                                        </dl>
                                        <%} %>
                                        <% if (currentPersonUser.Degree > 0)
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserDegrees", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Degree())[currentPersonUser.Degree].GetMultilingualName(CurrentUserLanguage)%></dd>
                                        </dl>
                                        <%} %>
                                        <%if (!string.IsNullOrEmpty(currentPersonUser.SelfAppraisal))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserSelfAppraisal", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                            <dd>
                                                <%=currentPersonUser.SelfAppraisal%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.Interest))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserInterest", applicationID)%><%=GetResourceString("Common_Colon")%>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.Interest%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.Expertise))
                                          { %>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserExpertise",applicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=currentPersonUser.Expertise%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.PersonalHomepage))
                                          { %>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonalWebAdress", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=currentPersonUser.PersonalHomepage%></dd>
                                        </dl>
                                        <%} %>
                                    </div>
                                    <div class="tn-info-part">
                                        <%if (CurrentUser != null && (currentPersonUser.UserName == CurrentUser.UserName || CurrentUser.IsContentAdministrator))
                                          {%>
                                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                                            <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "type", "PersonContact" } })%>">
                                                <%=GetResourceString("Action_Edit")%></a></span>
                                            <h4>
                                                <%=GetResourceString("Title_PersonContact", applicationID)%></h4>
                                        </div>
                                        <%} %>
                                        <%if (!string.IsNullOrEmpty(currentPersonUser.PublicEmail))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserPublicEmail",applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.PublicEmail%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.Mobile) && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_Mobile()))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserMobile", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.Mobile%></dd>
                                        </dl>
                                        <%} if (CurrentUser != null && !string.IsNullOrEmpty(currentPersonUser.HomeTel) && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_PersonalContactInfo()))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserTel", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.HomeTel%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.HomeFax))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserFax", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.HomeFax%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.PersonAddress))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserAddress", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.PersonAddress%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.PersonPostcode))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserPostcodel", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.PersonPostcode%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.MsnIM))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserMSN", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.MsnIM%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.QQIM))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserQQ", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.QQIM%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.SkypeIM))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserSkype", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.SkypeIM%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.YahooIM))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserYahooIM", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.YahooIM%></dd>
                                        </dl>
                                        <%} %>
                                    </div>
                                    <% if (CurrentUser != null && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_BusinessContactInfo()))
                                       { %>
                                    <div class="tn-info-part">
                                        <%if (currentPersonUser.UserName == CurrentUser.UserName || CurrentUser.IsContentAdministrator)
                                          {%>
                                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                                            <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "type", "BusinessContact" } })%>">
                                                <%=GetResourceString("Action_Edit")%></a></span>
                                            <h4>
                                                <%=GetResourceString("Title_BusinessContact", applicationID)%></h4>
                                        </div>
                                        <%} %>
                                        <%if (!string.IsNullOrEmpty(currentPersonUser.Title))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserJob", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.Title%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.JobSort))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserJobLevel", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=JobSorts.GetMultilingualJobSort(currentPersonUser.JobSort,currentDomainUser.Language)%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.CompanyName))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserCompanyName", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CompanyName%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.CompanyTrade > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_CompanyUserTrade", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <% 
                                                    string companyTrade = string.Empty;
                                                    if (CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade()).ContainsKey(currentPersonUser.CompanyTrade)) companyTrade = CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade())[currentPersonUser.CompanyTrade].GetMultilingualName(CurrentUserLanguage); %>
                                                <a target="_blank" title="<%=string.Format(GetResourceString("Action_Pattern_ClickSearchSameCompanyTradeMembers",applicationID),companyTrade) %>"
                                                    href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { {"CompanyTrade",currentPersonUser.CompanyTrade} })%>">
                                                    <%=companyTrade%></a></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.WorkTel))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_CompanyUserLinkTel", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.WorkTel%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.CompanyFax))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_CompanyUserFax", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CompanyFax%></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.CompanyAreaCode))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_UserAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <a target="_blank" title="<%=string.Format(GetResourceString("Action_Pattern_ClickSearchSameCityMembers",applicationID),Formatter.FormatArea(currentPersonUser.CompanyAreaCode,true)) %>"
                                                    href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { {"NowAreaCode",currentPersonUser.CompanyAreaCode} })%>">
                                                    <%=Formatter.FormatArea(currentPersonUser.CompanyAreaCode, true)%></a></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.CompanyAddress))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserCompanyAddress", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CompanyAddress %></dd>
                                        </dl>
                                        <%} if (!string.IsNullOrEmpty(currentPersonUser.CompanyPostcode))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserPostcodel", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CompanyPostcode%></dd>
                                        </dl>
                                        <%} if (CurrentUser != null && !string.IsNullOrEmpty(currentPersonUser.CompanyWebAddress) && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_BusinessContactInfo()))
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserCompanyWebAddress", applicationID)%><%=GetResourceString("Common_Colon") %>
                                            </dt>
                                            <dd>
                                                <%=currentPersonUser.CompanyWebAddress%></dd>
                                        </dl>
                                        <%} %>
                                    </div>
                                    <%} %>
                                    <% if (CurrentUser != null && Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserProfile_PersonalPrivateInfo()))
                                       {%>
                                    <div class="tn-info-part">
                                        <%if (currentPersonUser.UserName == CurrentUser.UserName || CurrentUser.IsContentAdministrator)
                                          {%>
                                        <div class="tn-text-heading tn-border-gray tn-border-bottom">
                                            <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("EditProfile", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName }, { "type", "PrivacyInfo" } })%>">
                                                <%=GetResourceString("Action_Edit")%></a></span>
                                            <h4>
                                                <%=GetResourceString("Title_PrivacyInfo", applicationID)%></h4>
                                        </div>
                                        <%} %>
                                        <%if (currentPersonUser.Stature > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserStature", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                            <dd>
                                                <%=string.Format("{0}Cm", currentPersonUser.Stature)%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Weight > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserWeight", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                            <dd>
                                                <%=string.Format("{0}Kg", currentPersonUser.Weight)%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Marriage > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserMarriage", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Marriage())[currentPersonUser.Marriage].Name%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Health > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserHealth", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Health())[currentPersonUser.Health].GetMultilingualName(CurrentUserLanguage)%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Smoke > 0)
                                          {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserSmoke", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Smoke())[currentPersonUser.Smoke].GetMultilingualName(CurrentUserLanguage)%></dd>
                                        </dl>
                                        <%} %>
                                        <% if (currentPersonUser.Drink > 0)
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserDrink", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Drink())[currentPersonUser.Drink].GetMultilingualName(CurrentUserLanguage)%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Shape > 0)
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserShape", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Shape())[currentPersonUser.Shape].GetMultilingualName(CurrentUserLanguage)%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.Blood > 0)
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserBlood", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Blood())[currentPersonUser.Blood].Name%></dd>
                                        </dl>
                                        <%} if (currentPersonUser.NowSalary > 0)
                                           {%>
                                        <dl class="tn-helper-clearfix">
                                            <dt>
                                                <%=GetResourceString("Label_PersonUserSalary", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
                                            <dd>
                                                <%=CodeItems.GetCodeItems(CodeSetCodes.Instance().Salary())[currentPersonUser.NowSalary].Name%></dd>
                                        </dl>
                                        <%} %>
                                    </div>
                                    <%} %>
                                    <%} %>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tn-block">
                        <% 
                            //用户头像及操作
                            SPBHtmlHelper.Instance().RenderWidgetInUserDomain(Html, "4e5ebc772a09bb65", currentDomainUser);
                        %>
                                        <% // 我的朋友
                            SPBHtmlHelper.Instance().RenderWidgetInUserDomain(Html, "539f986daf59b8d6", currentDomainUser);
                        %>
                              <% // 个人标签
                            SPBHtmlHelper.Instance().RenderWidgetInUserDomain(Html, "09d4627f96225a6e", currentDomainUser);
                        %>                        
                    </div>
                </div>
            </div>
        </div>
        <div id="tn-footer" class="tn-footer-bg">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
</body>
</html>
