﻿/*
gallery
*/


var $removeEvents = function (object, type)
{
	if (!object.events) return object;
	if (type){
		if (!object.events[type]) return object;
		for (var fn in object.events[type]) object.removeEvent(type, fn);
		object.events[type] = null;
	} else {
		for (var evType in object.events) object.removeEvents(evType);
		object.events = null;
	}
	return object;
};
		
		
// declaring the class
var gallery = new Class({
	initialize: function(element, options) {
		this.setOptions({
			showArrows: true,
			showCarousel: true,
			showInfopane: true,
			thumbHeight: 45,
			thumbWidth: 50,
			thumbSpacing: 5,
			embedLinks: true,
			fadeDuration: 500,
			timed: false,
			delay: 3000,
			preloader: true,
			manualData: [],
			populateData: true,
			elementSelector: "div.imageElement",
			titleSelector: "h3",
			subtitleSelector: "p",
			linkSelector: "a.open",
			imageSelector: "img.full",
			thumbnailSelector: "img.thumbnail",
			slideInfoZoneOpacity: 0.7,
			carouselMinimizedOpacity: 0.4,
			carouselMinimizedHeight: 20,
			carouselMaximizedOpacity: 0.7, 
			destroyAfterPopulate: true,
			baseClass: 'jdGallery',
			withArrowsClass: 'withArrows',
			textShowCarousel: 'Pictures',
			useThumbGenerator: false,
			thumbGenerator: 'resizer.php'
		}, options);
		this.fireEvent('onInit');
		this.currentIter = 0;
		this.lastIter = 0;
		this.maxIter = 0;
		this.galleryElement = element;
		this.galleryData = this.options.manualData;
		this.galleryInit = 1;
		this.galleryElements = Array();
		this.thumbnailElements = Array();
		this.galleryElement.addClass(this.options.baseClass);
		if (this.options.populateData)
			this.populateData();
		element.style.display="block";
		
		if (this.options.embedLinks)
		{
			this.currentLink = new Element('a').addClass('open').setProperties({
				href: '#',
				title: ''
			}).injectInside(element);
			if ((!this.options.showArrows) && (!this.options.showCarousel))
				this.galleryElement = element = this.currentLink;
			else
				this.currentLink.setStyle('display', 'none');
		}
		
		this.constructElements();
		if ((data.length>1)&&(this.options.showArrows))
		{
			var leftArrow = new Element('a').addClass('left').addEvent(
				'click',
				this.prevItem.bind(this)
			).injectInside(element);
			//左箭头的显示
			leftArrow.addEvent("mouseover",function(){this.setOpacity(0.7);})
			leftArrow.addEvent("mouseout",function(){this.setOpacity(0.3);})
			var rightArrow = new Element('a').addClass('right').addEvent(
				'click',
				this.nextItem.bind(this)
			).injectInside(element);
			//右箭头的显示
			rightArrow.addEvent("mouseover",function(){this.setOpacity(0.7);})
			rightArrow.addEvent("mouseout",function(){this.setOpacity(0.3);})
			this.galleryElement.addClass(this.options.withArrowsClass);
		}
		this.loadingElement = new Element('div').addClass('loadingElement').injectInside(element);
		if (this.options.showInfopane) this.initInfoSlideshow();
		if (this.options.showCarousel) this.initCarousel();
		this.initSlide();//initslider
		this.doSlideShow(1);
	},
	populateData: function() {
		currentArrayPlace = this.galleryData.length;
		options = this.options;
		data = this.galleryData;
		this.galleryElement.getElements(options.elementSelector).each(function(el) {
			elementDict = {
				image: el.getElement(options.imageSelector).getProperty('src'),
				number: currentArrayPlace
			};
			if ((options.showInfopane) | (options.showCarousel))
				Object.extend(elementDict, {
					title: el.getElement(options.titleSelector).innerHTML,
					description: el.getElement(options.subtitleSelector).innerHTML
				});
			if (options.embedLinks)
				Object.extend(elementDict, {
					link: el.getElement(options.linkSelector).href||false,
					linkTitle: el.getElement(options.linkSelector).title||false
				});
			if ((!options.useThumbGenerator) && (options.showCarousel))
				Object.extend(elementDict, {
					thumbnail: el.getElement(options.thumbnailSelector).src
				});
			else if (options.useThumbGenerator)
				Object.extend(elementDict, {
					thumbnail: 'resizer.php?imgfile=' + elementDict.image + '&max_width=' + options.thumbWidth + '&max_height=' + options.thumbHeight
				});
			
			data[currentArrayPlace] = elementDict;
			currentArrayPlace++;
			if (this.options.destroyAfterPopulate)
				el.remove();
		});
		this.galleryData = data;
		this.fireEvent('onPopulated');
	},
	constructElements: function() {
		el = this.galleryElement;
		this.maxIter = this.galleryData.length;
		var currentImg;
		for(i=0;i<this.galleryData.length;i++)
		{
			var currentImg = new Fx.Style(
				new Element('div').addClass('slideElement').setStyles({
					'position':'absolute',
					'left':'0px',
					'right':'0px',
					'margin':'0px',
					'padding':'0px',
					'backgroundImage':"url('" + this.galleryData[i].image + "')",
					'backgroundPosition':"center center",
					'opacity':'0'
				}).injectInside(el),
				'opacity',
				{duration: this.options.fadeDuration}
			);
			this.galleryElements[parseInt(i)] = currentImg;
		}
	},
	destroySlideShow: function(element) {
		var myClassName = element.className;
		var newElement = new Element('div').addClass('myClassName');
		element.parentNode.replaceChild(newElement, element);
	},
	startSlideShow: function() {
		this.fireEvent('onStart');
		this.loadingElement.style.display = "none";
		this.lastIter = this.maxIter - 1;
		this.currentIter = 0;
		this.galleryInit = 0;
		this.galleryElements[parseInt(this.currentIter)].set(1);
		if (this.options.showInfopane)
			this.showInfoSlideShow.delay(1000, this);
		this.prepareTimer();
		if (this.options.embedLinks)
			this.makeLink(this.currentIter);
	},
	nextItem: function() {
		this.fireEvent('onNextCalled');
		this.nextIter = this.currentIter+1;
		if (this.nextIter >= this.maxIter)
			this.nextIter = 0;
		this.galleryInit = 0;
		this.goTo(this.nextIter);
	},
	prevItem: function() {
		this.fireEvent('onPreviousCalled');
		this.nextIter = this.currentIter-1;
		if (this.nextIter <= -1)
			this.nextIter = this.maxIter - 1;
		this.galleryInit = 0;
		this.goTo(this.nextIter);
	},
	goTo: function(num) {
		this.clearTimer();
		if (this.options.embedLinks)
			this.clearLink();
		if (this.options.showInfopane)
		{
			this.slideInfoZone.clearChain();
			this.hideInfoSlideShow().chain(this.changeItem.pass(num, this));
		} else
			this.changeItem.delay(500, this, num);
		if (this.options.embedLinks)
			this.makeLink(num);
		this.prepareTimer();
		/*if (this.options.showCarousel)
			this.clearThumbnailsHighlights();*/
	},
	changeItem: function(num) {
		this.fireEvent('onStartChanging');
		this.galleryInit = 0;
		if (this.currentIter != num)
		{
			for(i=0;i<this.maxIter;i++)
			{
				if ((i != this.currentIter)) this.galleryElements[i].set(0);
			}
			if (num > this.currentIter) this.galleryElements[num].custom(1);
			else
			{
				this.galleryElements[num].set(1);
				this.galleryElements[this.currentIter].custom(0);
			}
			this.currentIter = num;
		}
		
		var nailPic=document.getElementById(num);
		if(nailPic != null)
		{
		   nailPic.setOpacity(0.99); 
		}
		if(num==0)
		num=this.maxIter;
		var PnailPic=document.getElementById(num-1);
		if(PnailPic != null)
		{
		  PnailPic.setOpacity(0.2);
		}
		if(num==this.maxIter)
		num=0;
		var NnailPic=document.getElementById(num+1);
		if(NnailPic != null)
		{
		  NnailPic.setOpacity(0.2);
		}
	
		this.doSlideShow.bind(this)();
		this.fireEvent('onChanged');
	},
	clearTimer: function() {
		if (this.options.timed)
			$clear(this.timer);
	},
	prepareTimer: function() {
		if (this.options.timed)
			this.timer = this.nextItem.delay(this.options.delay, this);
	},
	doSlideShow: function(position) {
		if (this.galleryInit == 1)
		{
			imgPreloader = new Image();
			imgPreloader.onload=function(){
				this.startSlideShow.delay(10, this);
			}.bind(this);
			imgPreloader.src = this.galleryData[0].image;
		} else {
			if (this.options.showInfopane)
			{
				if (this.options.showInfopane)
				{
					this.showInfoSlideShow.delay((500 + this.options.fadeDuration), this);
				} else
					if (this.options.showCarousel)
						this.centerCarouselOn(position);
			}
		}
	},
	initCarousel: function () {
		var carouselContainerElement = new Element('div').addClass('carouselContainer').injectInside(this.galleryElement);
		this.carouselContainer = new Fx.Styles(carouselContainerElement, {transition: Fx.Transitions.expoOut});
		this.carouselContainer.normalHeight = carouselContainerElement.offsetHeight;
		this.carouselContainer.set({'opacity': this.options.carouselManimizedOpacity, 'top': 370});
		//不显示pictures而让carousel一直显示
//		this.carouselBtn = new Element('a').addClass('carouselBtn').setProperties({
//			title: this.options.textShowCarousel
//		}).setHTML(this.options.textShowCarousel).injectInside(carouselContainerElement);
//		
//		this.carouselBtn.addEvent(
//			'click',
//			function () {
//				this.carouselContainer.clearTimer();
//				this.toggleCarousel();
//			}.bind(this)
//		);
		this.carouselActive = false;

		var carouselElement = new Element('div').addClass('carousel').injectInside(carouselContainerElement);
		this.carousel = new Fx.Styles(carouselElement);
		
		//this.carouselLabel = new Element('p').addClass('label').injectInside(this.carousel.element);
		this.carouselWrapper = new Element('div').addClass('carouselWrapper').injectInside(this.carousel.element);
		this.carouselInner = new Element('div').addClass('carouselInner').injectInside(this.carouselWrapper);
		
		var carousePage=new Element('div').addClass('carouselPage').injectInside(this.carousel.element);

		this.carouselWrapper.scroller = new Scroller(this.carouselWrapper, {
			area: 100,
			velocity: 0.2
		})
		
		this.carouselWrapper.elementScroller = new Fx.Scroll(this.carouselWrapper, {
			duration: 400,
		        onStart:this.carouselWrapper.scroller.stop.bind(this.carouselWrapper.scroller),
			onComplete: this.carouselWrapper.scroller.start.bind(this.carouselWrapper.scroller)
		});
    //////////////////////////////////屏蔽错误/////////////////////////////////////////
     function doNothing(){ return true; }
         window.onerror = doNothing;
    //////////////////////////////////////////////////////////////////////////////////
		this.constructThumbnails();

		this.carouselInner.style.width = ((this.maxIter * (this.options.thumbWidth + this.options.thumbSpacing + 2)) + 10) + "px";
		
		//////////////////////添加页面转换按钮/////////////////////////////////////////////
		//页面转换的控制(将所有要在幻灯片中显示的图片的缩略图显示在不同的页面)
       //首先页数也会跟着图片数的变换而变化所以用循环自动显示页面的数量
       
       //如果图片数大于72张，那么将所有的将所有图片分成9页，每页有所有图片除以9张图片
       //如果相簿里的图片小于等于72张，那么每页5张图片；共有所有图片除以8页。
       if(this.maxIter> 45)
       {
          var picQuantityE=this.maxIter/9;
          var picQuantity = parseInt(picQuantityE);
          var pageQuantity=9;
          
       }
       else
       {
          var picQuantity= 8 ;
          var pageQuantityF=this.maxIter/picQuantity + 1;
          var pageQuantity = parseInt(pageQuantityF);
       }            
		 var aa,bb,cc,dd,dd,ee,ff,gg,hh,ii;
           aa=0;
           bb=aa+picQuantity;
           cc=bb+picQuantity;
           dd=cc+picQuantity;
           ee=dd+picQuantity;
           ff=ee+picQuantity;
           gg=ff+picQuantity;
           hh=gg+picQuantity;
           ii=hh+picQuantity;
           
       for (i = 0;i < pageQuantity;i++)
       {
       if(i==0)
           {
            var firstBtn = new Element('div',{'id': i}).addClass('nialBtn1').injectInside(carousePage).addEvent('click', function() { this.goTo(aa); }.bind(this));
           }
           if(i==1)
           {
             var secondBtn = new Element('div',{'id': i}).addClass('nialBtn2').injectInside(carousePage).addEvent('click', function() { this.goTo(bb); }.bind(this));
           }
           if(i==2)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn3').injectInside(carousePage).addEvent('click', function() { this.goTo(cc); }.bind(this));
           }
           if(i==3)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn4').injectInside(carousePage).addEvent('click', function() { this.goTo(dd); }.bind(this));
           }
           if(i==4)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn5').injectInside(carousePage).addEvent('click', function() { this.goTo(ee); }.bind(this));
           }
           if(i==5)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn6').injectInside(carousePage).addEvent('click', function() { this.goTo(ff); }.bind(this));
           }
           if(i==6)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn7').injectInside(carousePage).addEvent('click', function() { this.goTo(gg); }.bind(this));
           }
            if(i==7)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn8').injectInside(carousePage).addEvent('click', function() { this.goTo(hh); }.bind(this));
           }
             if(i==8)
           {
             var thirdBtn = new Element('div',{'id': i}).addClass('nialBtn9').injectInside(carousePage).addEvent('click', function() { this.goTo(ii); }.bind(this));
           }
         }
	},
	toggleCarousel: function() {
		if (this.carouselActive)
			this.hideCarousel();
		else
			this.showCarousel();
	},
	showCarousel: function () {
		this.fireEvent('onShowCarousel');
		this.carouselContainer.custom({
			'opacity': this.options.carouselMaximizedOpacity,
			'top': 0
		}).addEvent('onComplete', function() { this.carouselActive = true; this.carouselWrapper.scroller.start(); }.bind(this));
	},
	hideCarousel: function () {
		this.fireEvent('onHideCarousel');
		this.carouselContainer.custom({
			'opacity': this.options.carouselMinimizedOpacity,
			'top': (this.options.carouselMinimizedHeight - this.carouselContainer.normalHeight)
		}).addEvent('onComplete', function() { this.carouselActive = false; this.carouselWrapper.scroller.stop(); }.bind(this));
	},
	initSlide: function(){
	   options=this.options;
	   //alert(options.delay);
	    var slideContainerElement = new Element('div').addClass('sliderContainer').injectInside(this.galleryElement);
		this.slideContainer = new Fx.Styles(slideContainerElement, {transition: Fx.Transitions.expoOut});
		this.slideContainer.normalHeight =30;
		this.slideContainer.set({'opacity': 0.8, 'top': -40});
        //outspread btn
		this.slideBtn = new Element('a').addClass('sliderBtn').setProperties({
			title: this.options.textShowCarousel
		}).setHTML("").injectInside(slideContainerElement);
		this.slideActive=false;		
		this.slideBtn.addEvent(
			'mouseover',
			//'click',
			function () {
			//alert("ok");
			this.toggleSlider();
			}.bind(this)
		);
       	//the slider control bar
	    var controlHolder=new Element('div').addClass('controlHolder').injectInside(slideContainerElement);
	   
	  	////////////////////////////////////////pause play control btn//////////////////////////////////////
	  	var justArea=new Element('div',{'id':'justArea'}).addClass('justArea').injectInside(controlHolder);
	  	var befArea=new Element('div').addClass('befArea').injectInside(controlHolder);
	    this.controlPlay=new Element('div',{'id':'control'}).addClass('control').injectInside(controlHolder);
	    //var speedTip=new Element('p',{'id':'speedTip'}).addClass('speedTip').injectAfter(this.controlPlay).setHTML('播放速度');
	    var midArea=new Element('div').addClass('midArea').injectInside(controlHolder);	
	    var speedNote=new Element('div',{'id':'speedNote'}).addClass('speedNote').injectInside(controlHolder);
	    var midArea2=new Element('div').addClass('midArea2').injectInside(controlHolder);	 
	    var sliderArea=new Element('div',{'id':'area'}).addClass('area').injectInside(controlHolder);
	    var sliderKnob=new Element('div',{'id':'knob'}).addClass('knob').injectInside(sliderArea);  
	    var midArea3=new Element('div').addClass('midArea2').injectInside(controlHolder);	 
	    var speedTip=new Element('div',{'id':'speedTip'}).addClass('speedTip').setHTML("5s").injectInside(controlHolder);
	     var midArea4=new Element('div').addClass('afterSpeedTip').injectInside(controlHolder);
	    var justArea2=new Element('div').addClass('justArea').injectInside(controlHolder);
	    this.controlPlay.addEvent(
	    'click',
	    function () {	      
	      this.toggleControl();
	    }.bind(this)
	    );
	    	     //alert("sliderBar out");
	     var newDelay=5000;
	     options.delay=newDelay;
	    // alert(options.delay);

       var slider = new Slider($('area'),$('knob'), {
	                steps: 600,
                onChange: function(step){
                     options.delay=step * 15+1000;
                     $('speedTip').setHTML(parseInt(options.delay/1000));
                    } ,
                 onComplete:function(step){

                    }               
                }).set(180);
      
                
	},
	///////pause-play toggleControl////////////////////////////////////////////////////
	toggleControl:function(){
	  if(options.timed)
	     this.controlPause();
	  else
	     this.controlStart();
	},
	controlPause:function()
    {
       options.timed=false;
       this.controlPlay.addClass('control2');
       //alert("Pause");
    },
    controlStart:function()
    {
       options.timed=true;

       this.controlPlay.removeClass('control2');
       this.controlPlay.addClass('control');
	  //alert("Start");
       this.prepareTimer();
    },
     ///////stop-play toggleSlider////////////////////////////////////////////////////
	toggleSlider: function() {
		if (this.sliderActive)
			this.hideSlide();
		else
			this.showSlide();
	},
	showSlide: function () {
       // alert("show control bar!");
		this.slideContainer.custom({
			'opacity': this.options.carouselMaximizedOpacity,
			'top': 0
		}).addEvent('onComplete', function() { this.sliderActive = true; }.bind(this));
	},
	hideSlide: function(){
	    // alert("hide control bar!");
	     this.slideContainer.custom({
			'opacity': this.options.carouselMaximizedOpacity,
			'top': -40
		}).addEvent('onComplete', function() { this.sliderActive = false; }.bind(this));
	},
	
	
	constructThumbnails: function () {
		element = this.carouselInner;
		//debugger
		for(i=0;i<this.galleryData.length;i++)
		{
		    //给每个缩略图配置一个id(id号为相应的数字<在changeItem使用到>)
			var currentImg = new Fx.Style(new Element ('div',{'id':i}).addClass("thumbnail").setStyles({
					backgroundImage: "url('" + this.galleryData[i].thumbnail + "')",
					backgroundPosition: "center center",
					backgroundRepeat: 'no-repeat',
					marginLeft: this.options.thumbSpacing + "px",
					width: this.options.thumbWidth + "px",
					height: this.options.thumbHeight + "px"
				}).injectInside(element), "opacity", {duration: 200}).set(0.2);
			currentImg.element.addEvents({
				'mouseover': function (myself) {
					myself.clearTimer();
					myself.custom(0.99);
					//$(this.carouselLabel).setHTML('<span class="number">' + (myself.relatedImage.number + 1) + "/" + this.maxIter + ":</span> " + myself.relatedImage.title);
				}.pass(currentImg, this),
				'mouseout': function (myself) {
					myself.clearTimer();
					myself.custom(0.2);
				}.pass(currentImg, this),
				'click': function (myself) {
					options.timed=false;
					this.controlPlay.addClass('control2');
					this.goTo(myself.relatedImage.number);
				}.pass(currentImg, this)
			});			
			
			currentImg.relatedImage = this.galleryData[i];
			this.thumbnailElements[parseInt(i)] = currentImg;
		}
		//debugger
	},
	clearThumbnailsHighlights: function()
	{
		for(i=0;i<this.galleryData.length;i++)
		{
			this.thumbnailElements[i].clearTimer();
			this.thumbnailElements[i].custom(0.2);
		}
	},
	centerCarouselOn: function(num) {
		var carouselElement = this.thumbnailElements[num];
		var position =carouselElement.element.offsetLeft + (carouselElement.element.offsetWidth / 2);
		var carouselWidth = this.carouselWrapper.offsetWidth;
		var carouselInnerWidth = this.carouselInner.offsetWidth;
		var diffWidth = carouselWidth / 2;
		var scrollPos = position-diffWidth;
		this.carouselWrapper.elementScroller.scrollTo(scrollPos,0);
	},
	initInfoSlideshow: function() {
		/*if (this.slideInfoZone.element)
			this.slideInfoZone.element.remove();*/
		this.slideInfoZone = new Fx.Styles(new Element('div').addClass('slideInfoZone').injectInside($(this.galleryElement))).set({'opacity':0});
		var slideInfoZoneTitle = new Element('h2').injectInside(this.slideInfoZone.element);
		var slideInfoZoneDescription = new Element('p').injectInside(this.slideInfoZone.element);
		this.slideInfoZone.normalHeight = this.slideInfoZone.element.offsetHeight;
		this.slideInfoZone.element.setStyle('opacity',0);
	},
	changeInfoSlideShow: function()
	{
		this.hideInfoSlideShow.delay(10, this);
		this.showInfoSlideShow.delay(500, this);
	},
	showInfoSlideShow: function() {
	    //将InfoSlide显示的时候的opacity和height都设为零(就是为了不让它显示)
		this.fireEvent('onShowInfopane');
		this.slideInfoZone.clearTimer();
		element = this.slideInfoZone.element;
		element.getElement('h2').setHTML(this.galleryData[this.currentIter].title);
		element.getElement('p').setHTML(this.galleryData[this.currentIter].description);
		this.slideInfoZone.custom({'opacity': 0, 'height': 0});
		if (this.options.showCarousel)
			this.slideInfoZone.chain(this.centerCarouselOn.pass(this.currentIter, this));
		return this.slideInfoZone;
	},
	hideInfoSlideShow: function() {
		this.fireEvent('onHideInfopane');
		this.slideInfoZone.clearTimer();
		this.slideInfoZone.custom({'opacity': 0, 'height': 0});
		return this.slideInfoZone;
	},
	makeLink: function(num) {
		this.currentLink.setProperties({
			href: this.galleryData[num].link,
			title: this.galleryData[num].linkTitle,
			target:"_blank"
		})
		if (!((this.options.embedLinks) && (!this.options.showArrows) && (!this.options.showCarousel)))
			this.currentLink.setStyle('display', 'block');
	},
	clearLink: function() {
		this.currentLink.setProperties({href: '', title: ''});
		if (!((this.options.embedLinks) && (!this.options.showArrows) && (!this.options.showCarousel)))
			this.currentLink.setStyle('display', 'none');
	}
});
gallery.implement(new Events);
gallery.implement(new Options);

/*  */